/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.reuse.classification;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jcolibri.extensions.classification.ClassificationSolution;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.reuse.classification.AbstractKNNClassificationMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimilarityWeightedVotingMethod
extends AbstractKNNClassificationMethod {
    @Override
    public ClassificationSolution getPredictedSolution(Collection<RetrievalResult> cases) {
        HashMap<Object, Double> votes = new HashMap<Object, Double>();
        HashMap<Object, ClassificationSolution> values = new HashMap<Object, ClassificationSolution>();
        for (RetrievalResult result : cases) {
            ClassificationSolution solution = (ClassificationSolution)result.get_case().getSolution();
            Object solnAttVal = solution.getClassification();
            double eval = result.getEval();
            if (votes.containsKey(solnAttVal)) {
                votes.put(solnAttVal, (Double)votes.get(solnAttVal) + eval);
                continue;
            }
            votes.put(solnAttVal, eval);
            values.put(solnAttVal, solution);
        }
        double highestVoteSoFar = 0.0;
        Object predictedClassVal = null;
        for (Map.Entry e : votes.entrySet()) {
            if (!((Double)e.getValue() >= highestVoteSoFar)) continue;
            highestVoteSoFar = (Double)e.getValue();
            predictedClassVal = e.getKey();
        }
        return (ClassificationSolution)values.get(predictedClassVal);
    }
}

