/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test15;

import jcolibri.casebase.CachedLinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.PlainTextConnector;
import jcolibri.evaluation.Evaluator;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.maintenance_evaluation.DetailedEvaluationReport;
import jcolibri.method.reuse.classification.KNNClassificationConfig;
import jcolibri.method.revise.classification.BasicClassificationOracle;
import jcolibri.util.FileIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IrisMaintainedEvaluableApp
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;
    KNNClassificationConfig irisSimConfig;
    private Log log;
    public static final String DATA_SERIES_NAME = "RENN Iris Prediction Cost";

    public IrisMaintainedEvaluableApp(KNNClassificationConfig irisSimConfig) {
        this.irisSimConfig = irisSimConfig;
    }

    public void configure() throws ExecutionException {
        try {
            this._connector = new PlainTextConnector();
            this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/test15/plaintextconfig.xml"));
            this._caseBase = new CachedLinealCaseBase();
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        this.log = LogFactory.getLog(this.getClass());
    }

    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        return this._caseBase;
    }

    public void cycle(CBRQuery query) throws ExecutionException {
        this.log.info((Object)("Query: " + query.getDescription()));
        BasicClassificationOracle oracle = new BasicClassificationOracle();
        double predictionCost = oracle.getPredictionCost(query, this._caseBase, this.irisSimConfig);
        ((DetailedEvaluationReport)Evaluator.getEvaluationReport()).addDataToSeries(DATA_SERIES_NAME, query, predictionCost);
    }

    public void postCycle() throws ExecutionException {
        this._connector.close();
    }
}

