/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Launcher {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: jcolibri.util.Launcher MainClass [eclipse_classpath_file]");
            System.exit(0);
        }
        try {
            String classpathfile = ".classpath";
            if (args.length == 2) {
                classpathfile = args[1];
            }
            System.out.println("Loading class path from file: " + classpathfile);
            URL[] libraries = Launcher.getClassPath(classpathfile);
            int i = 0;
            while (i < libraries.length) {
                Launcher.addURLtoClassLoader(libraries[i]);
                System.out.println("Adding library: " + libraries[i]);
                ++i;
            }
            Class<?> mainClass = Class.forName(args[0]);
            LogFactory.getLog(Launcher.class).info((Object)("Executing class: " + args[0]));
            Method mainMethod = mainClass.getMethod("main", args.getClass());
            String[] newargs = new String[args.length - 1];
            int i2 = 1;
            while (i2 < args.length) {
                newargs[i2 - 1] = args[1];
                ++i2;
            }
            Object[] methodparams = new Object[]{newargs};
            mainMethod.invoke(null, methodparams);
        }
        catch (Exception e) {
            LogFactory.getLog(Launcher.class).error((Object)("Launching class " + e.getMessage()));
            e.printStackTrace();
        }
        LogFactory.getLog(Launcher.class).info((Object)"Launch finished");
    }

    public static void addURLtoClassLoader(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Class[] parameters = new Class[]{URL.class};
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    protected static URL[] getClassPath(String classpathfile) throws Exception {
        ArrayList<URL> CLASSPATH = new ArrayList<URL>();
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = db.parse(classpathfile);
            NodeList nl = doc.getElementsByTagName("classpathentry");
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                NamedNodeMap nnm = n.getAttributes();
                if (nnm.getNamedItem("kind").getNodeValue().equals("lib")) {
                    String lib = nnm.getNamedItem("path").getNodeValue();
                    File f = new File(lib);
                    CLASSPATH.add(f.toURI().toURL());
                }
                ++i;
            }
        }
        catch (Exception e) {
            LogFactory.getLog(Launcher.class).error((Object)("Error obtaining classpath. Revise your classpath file \n" + e.getMessage()));
            throw e;
        }
        return CLASSPATH.toArray(new URL[0]);
    }
}

