/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.gui.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import jcolibri.method.gui.editors.ParameterEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumEditor
extends JComboBox
implements ParameterEditor {
    private static final long serialVersionUID = 1L;
    private final String EMPTY = "<empty>";

    public EnumEditor(Class enumeration) {
        T[] constants = enumeration.getEnumConstants();
        this.addItem("<empty>");
        int i = 0;
        while (i < constants.length) {
            this.addItem(constants[i]);
            ++i;
        }
    }

    @Override
    public Object getEditorValue() {
        Object value = this.getSelectedItem();
        if (value.equals("<empty>")) {
            return null;
        }
        return value;
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public void setEditorValue(Object value) {
        if (value == null) {
            this.setSelectedItem("<empty>");
        } else {
            this.setSelectedItem(value);
        }
    }

    @Override
    public void setAllowedValues(Collection<Object> allowedValues) {
        this.removeAllItems();
        ArrayList<Enum> list = new ArrayList<Enum>();
        for (Object o : allowedValues) {
            list.add((Enum)o);
        }
        Collections.sort(list);
        for (Enum e : list) {
            this.addItem(e);
        }
    }
}

