/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.selection.compromiseDriven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.exception.NoApplicableFilterPredicateException;
import jcolibri.method.retrieve.FilterBasedRetrieval.FilterConfig;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.FilterPredicate;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.SelectCases;
import jcolibri.method.retrieve.selection.compromiseDriven.CDRSet;
import jcolibri.util.AttributeUtils;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompromiseDrivenSelection {
    public static CDRSet CDR(CBRQuery query, Collection<RetrievalResult> cases, FilterConfig preferences) {
        CDRSet rs = new CDRSet();
        ArrayList<CBRCase> candidates = new ArrayList<CBRCase>(SelectCases.selectAll(cases));
        while (!candidates.isEmpty()) {
            CBRCase c1 = candidates.get(0);
            rs.add(c1);
            rs.addToLikeSet(c1, c1);
            rs.addToCoveredSet(c1, c1);
            candidates.remove(0);
            for (CBRCase c2 : candidates) {
                Set<Attribute> compromises2;
                Set<Attribute> compromises1 = CompromiseDrivenSelection.getCompromises(c1, query, preferences);
                if (compromises1.equals(compromises2 = CompromiseDrivenSelection.getCompromises(c2, query, preferences))) {
                    rs.addToLikeSet(c1, c2);
                }
                if (!compromises2.containsAll(compromises1)) continue;
                rs.addToCoveredSet(c1, c2);
            }
            candidates.removeAll(rs.getCoveredSet(c1));
        }
        return rs;
    }

    public static Set<Attribute> getCompromises(CBRCase _case, CBRQuery query, FilterConfig preferences) {
        HashSet<Attribute> compromises = new HashSet<Attribute>();
        for (Attribute at : preferences.getDefinedAttributes()) {
            try {
                FilterPredicate predicate = preferences.getPredicate(at);
                Object caseObject = AttributeUtils.findValue(at, _case.getDescription());
                Object queryObject = AttributeUtils.findValue(at, query.getDescription());
                if (predicate.compute(caseObject, queryObject)) continue;
                compromises.add(at);
            }
            catch (NoApplicableFilterPredicateException e) {
                LogFactory.getLog(CompromiseDrivenSelection.class).error((Object)e);
            }
        }
        return compromises;
    }
}

