/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test12;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Date;
import jcolibri.extensions.textual.IE.common.DomainTopicClassifier;
import jcolibri.extensions.textual.IE.common.FeaturesExtractor;
import jcolibri.extensions.textual.IE.common.PhrasesExtractor;
import jcolibri.extensions.textual.IE.common.StopWordsDetector;
import jcolibri.extensions.textual.IE.common.TextStemmer;
import jcolibri.extensions.textual.IE.gate.GateFeaturesExtractor;
import jcolibri.extensions.textual.IE.gate.GatePOStagger;
import jcolibri.extensions.textual.IE.gate.GatePhrasesExtractor;
import jcolibri.extensions.textual.IE.gate.GateSplitter;
import jcolibri.extensions.textual.IE.gate.IETextGate;
import jcolibri.util.FileIO;
import org.apache.commons.logging.LogFactory;

public class TestGate {
    public static void main(String[] args) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(FileIO.findFile("jcolibri/test/test12/restest.txt").openStream()));
            String content = "";
            while ((line = br.readLine()) != null) {
                content = String.valueOf(content) + line + "\n";
            }
            long startTime = new Date().getTime();
            IETextGate text = new IETextGate(content);
            GateSplitter.split(text);
            StopWordsDetector.detectStopWords(text);
            TextStemmer.stem(text);
            GatePOStagger.tag(text);
            PhrasesExtractor.loadRules("jcolibri/test/test12/phrasesRules.txt");
            PhrasesExtractor.extractPhrases(text);
            GatePhrasesExtractor.loadDefaultRules();
            GatePhrasesExtractor.extractPhrases(text);
            FeaturesExtractor.loadRules("jcolibri/test/test12/featuresRules.txt");
            FeaturesExtractor.extractFeatures(text);
            GateFeaturesExtractor.loadDefaultRules();
            GateFeaturesExtractor.extractFeatures(text);
            DomainTopicClassifier.loadRules("jcolibri/test/test12/domainRules.txt");
            DomainTopicClassifier.classifyWithTopic(text);
            System.out.println(text.printAnnotations());
            long endTime = new Date().getTime();
            System.out.println("Total time: " + (endTime - startTime) + " milliseconds");
        }
        catch (Exception e) {
            LogFactory.getLog(TestGate.class).error((Object)e);
        }
    }
}

