/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.evaluation.tools;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jcolibri.evaluation.EvaluationReport;
import net.sourceforge.chart2d.Chart2D;
import net.sourceforge.chart2d.Chart2DProperties;
import net.sourceforge.chart2d.Dataset;
import net.sourceforge.chart2d.GraphChart2DProperties;
import net.sourceforge.chart2d.GraphProperties;
import net.sourceforge.chart2d.LBChart2D;
import net.sourceforge.chart2d.LegendProperties;
import net.sourceforge.chart2d.MultiColorsProperties;
import net.sourceforge.chart2d.Object2DProperties;

public class EvaluationResultGUI {
    private static final long serialVersionUID = 1L;
    private static Chart2D chart;
    private static JFrame dialog;
    private static EvaluationReport evalReport;

    public static void show(EvaluationReport er, String title, boolean exitOnClose) {
        evalReport = er;
        dialog = new JFrame();
        dialog.setTitle("jCOLIBRI Evaluation");
        dialog.getContentPane().setLayout(new BorderLayout());
        JPanel data = new JPanel();
        data.setLayout(new BoxLayout(data, 0));
        data.add(new JLabel("Cycles: " + er.getNumberOfCycles()));
        data.add(Box.createGlue());
        data.add(new JLabel("Time: " + er.getTotalTime() + " ms"));
        data.add(Box.createGlue());
        data.add(new JLabel("Time per cycle: " + er.getTimePerCycle() + " ms"));
        dialog.getContentPane().add((Component)data, "North");
        chart = EvaluationResultGUI.getChart(title, er);
        JTextArea textArea = new JTextArea();
        JScrollPane sp = new JScrollPane(textArea);
        sp.setViewportView(textArea);
        textArea.setText(er.toString());
        textArea.setEditable(false);
        dialog.getContentPane().add((Component)chart, "Center");
        JPanel buttons = new JPanel();
        JButton exportData = new JButton("Export data");
        exportData.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    FileDialog fd = new FileDialog((Frame)dialog, "Save as CSV", 1);
                    fd.setFile("evaluation.csv");
                    fd.setVisible(true);
                    String name = String.valueOf(fd.getDirectory()) + fd.getFile();
                    File file = new File(name);
                    EvaluationResultGUI.saveEvaluationToCSV(evalReport, file);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JButton exportChart = new JButton("Export chart");
        exportChart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    FileDialog fd = new FileDialog((Frame)dialog, "Save as JPG", 1);
                    fd.setFile("evaluation.jpg");
                    fd.setVisible(true);
                    String name = String.valueOf(fd.getDirectory()) + fd.getFile();
                    File file = new File(name);
                    EvaluationResultGUI.saveComponentToJPG((Component)chart, file);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        buttons.add(exportData);
        buttons.add(exportChart);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(sp);
        p.add(buttons);
        dialog.getContentPane().add((Component)p, "South");
        dialog.setPreferredSize(new Dimension(640, 400));
        dialog.pack();
        dialog.doLayout();
        dialog.setVisible(true);
        if (exitOnClose) {
            dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent arg0) {
                    System.exit(0);
                }
            });
        }
    }

    private static Chart2D getChart(String title, EvaluationReport er) {
        Object2DProperties object2DProps = new Object2DProperties();
        object2DProps.setObjectTitleText(title);
        Chart2DProperties chart2DProps = new Chart2DProperties();
        chart2DProps.setChartDataLabelsPrecision(-2);
        LegendProperties legendProps = new LegendProperties();
        legendProps.setLegendExistence(true);
        String[] labels = er.getSeriesLabels();
        legendProps.setLegendLabelsTexts(labels);
        GraphChart2DProperties graphChart2DProps = new GraphChart2DProperties();
        graphChart2DProps.setLabelsAxisExistence(false);
        graphChart2DProps.setNumbersAxisTitleText("Evaluation");
        graphChart2DProps.setLabelsAxisTicksAlignment(0);
        GraphProperties graphProps = new GraphProperties();
        graphProps.setGraphBarsExistence(false);
        graphProps.setGraphLinesExistence(true);
        graphProps.setGraphLinesThicknessModel(2);
        graphProps.setGraphLinesWithinCategoryOverlapRatio(1.0f);
        graphProps.setGraphDotsExistence(false);
        graphProps.setGraphDotsThicknessModel(4);
        graphProps.setGraphDotsWithinCategoryOverlapRatio(1.0f);
        graphProps.setGraphAllowComponentAlignment(true);
        graphProps.setGraphOutlineComponentsExistence(true);
        int lines = labels.length;
        int lineSize = er.getSeries(labels[0]).size();
        Dataset dataset = new Dataset(lines, lineSize, 1);
        int l = 0;
        while (l < lines) {
            Vector<Double> line = er.getSeries(labels[l]);
            int j = 0;
            while (j < dataset.getNumCats()) {
                dataset.set(l, j, 0, line.get(j).floatValue());
                ++j;
            }
            ++l;
        }
        MultiColorsProperties multiColorsProps = new MultiColorsProperties();
        LBChart2D chart2D = new LBChart2D();
        chart2D.setObject2DProperties(object2DProps);
        chart2D.setChart2DProperties(chart2DProps);
        chart2D.setLegendProperties(legendProps);
        chart2D.setGraphChart2DProperties(graphChart2DProps);
        chart2D.addGraphProperties(graphProps);
        chart2D.addDataset(dataset);
        chart2D.addMultiColorsProperties(multiColorsProps);
        if (!chart2D.validate(false)) {
            chart2D.validate(true);
        }
        return chart2D;
    }

    static void saveEvaluationToCSV(EvaluationReport er, File file) throws IOException {
        PrintWriter pw = new PrintWriter(file);
        pw.println("# Cycles: " + er.getNumberOfCycles());
        pw.println("# Time: " + er.getTotalTime() + " ms");
        pw.println("# Time per cycle: " + er.getTimePerCycle() + " ms");
        String[] labels = er.getSeriesLabels();
        int l = 0;
        while (l < labels.length) {
            Vector<Double> res = er.getSeries(labels[l]);
            pw.print(labels[l]);
            int i = 0;
            while (i < res.size()) {
                pw.print(";" + res.get(i));
                ++i;
            }
            pw.println();
            ++l;
        }
        pw.close();
    }

    static void saveComponentToJPG(Component component, File file) throws IOException {
        BufferedImage image = (BufferedImage)component.createImage(component.getWidth(), component.getHeight());
        Graphics graphics = image.getGraphics();
        if (graphics != null) {
            component.paintAll(graphics);
        }
        FileOutputStream fileStream = new FileOutputStream(file);
        JPEGEncodeParam encodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)image);
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)fileStream);
        encoder.encode(image, encodeParam);
        fileStream.close();
    }
}

