/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.lucene;

import jcolibri.extensions.textual.lucene.LuceneIndex;
import jcolibri.extensions.textual.lucene.LuceneSearchResult;
import jcolibri.extensions.textual.lucene.spanish.SpanishAnalyzer;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class LuceneSearcher {
    public static LuceneSearchResult search(LuceneIndex index, String query, String fieldName) {
        try {
            IndexSearcher searcher = new IndexSearcher(index.getDirectory());
            StandardAnalyzer analyzer = new StandardAnalyzer();
            QueryParser parser = new QueryParser(fieldName, (Analyzer)analyzer);
            Query q = parser.parse(query);
            Hits hits = searcher.search(q);
            LuceneSearchResult lsr = new LuceneSearchResult(hits, index);
            searcher.close();
            return lsr;
        }
        catch (Exception e) {
            LogFactory.getLog(LuceneSearcher.class).error((Object)e);
            return null;
        }
    }

    public static LuceneSearchResult searchSpanish(LuceneIndex index, String query, String fieldName) {
        try {
            IndexSearcher searcher = new IndexSearcher(index.getDirectory());
            SpanishAnalyzer analyzer = new SpanishAnalyzer();
            QueryParser parser = new QueryParser(fieldName, (Analyzer)analyzer);
            Query q = parser.parse(query);
            Hits hits = searcher.search(q);
            LuceneSearchResult lsr = new LuceneSearchResult(hits, index);
            searcher.close();
            return lsr;
        }
        catch (Exception e) {
            LogFactory.getLog(LuceneSearcher.class).error((Object)e);
            return null;
        }
    }
}

