/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test16;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CaseBaseFilter;
import jcolibri.cbrcore.Connector;
import jcolibri.exception.InitializingException;
import jcolibri.extensions.textual.IE.opennlp.IETextOpenNLP;
import jcolibri.test.test16.EmailDescription;
import jcolibri.test.test16.EmailSolution;
import jcolibri.util.FileIO;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailConnector
implements Connector {
    String zipfile;

    public EmailConnector(String zipfile) {
        this.zipfile = zipfile;
    }

    @Override
    public void close() {
    }

    @Override
    public void deleteCases(Collection<CBRCase> cases) {
    }

    @Override
    public void initFromXMLfile(URL file) throws InitializingException {
    }

    @Override
    public Collection<CBRCase> retrieveAllCases() {
        int ham_easy = 0;
        int ham_hard = 0;
        int spam = 0;
        ArrayList<CBRCase> cases = new ArrayList<CBRCase>();
        try {
            ZipEntry entry;
            BufferedInputStream source = new BufferedInputStream(FileIO.openFile(this.zipfile));
            ZipInputStream zip_in_stream = new ZipInputStream(source);
            BufferedReader br = new BufferedReader(new InputStreamReader(zip_in_stream));
            while ((entry = zip_in_stream.getNextEntry()) != null) {
                String _class;
                String id = entry.getName();
                StringBuffer buffer = new StringBuffer();
                while (br.ready()) {
                    buffer.append(br.readLine());
                    buffer.append("\n");
                }
                if (id.startsWith("spam")) {
                    _class = "spam";
                    ++spam;
                } else {
                    _class = "ham";
                    if (id.startsWith("hard")) {
                        ++ham_hard;
                    } else {
                        ++ham_easy;
                    }
                }
                EmailDescription desc = new EmailDescription(id, new IETextOpenNLP(new String(buffer)));
                EmailSolution sol = new EmailSolution(_class);
                CBRCase _case = new CBRCase();
                _case.setDescription(desc);
                _case.setSolution(sol);
                cases.add(_case);
            }
            LogFactory.getLog(this.getClass()).info((Object)("Loaded " + ham_easy + " easy ham - " + ham_hard + " hard ham - " + spam + " spam"));
            br.close();
        }
        catch (IOException e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
        return cases;
    }

    @Override
    public Collection<CBRCase> retrieveSomeCases(CaseBaseFilter filter) {
        return null;
    }

    @Override
    public void storeCases(Collection<CBRCase> cases) {
    }
}

