/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.recommenders.rec12;

import java.util.Collection;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.PlainTextConnector;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.recommendation.ContentBasedProfile.ObtainQueryFromProfile;
import jcolibri.extensions.recommendation.casesDisplay.DisplayCasesTableMethod;
import jcolibri.extensions.recommendation.casesDisplay.UserChoice;
import jcolibri.extensions.recommendation.collaborative.CollaborativeRetrievalMethod;
import jcolibri.extensions.recommendation.collaborative.MatrixCaseBase;
import jcolibri.extensions.recommendation.collaborative.PearsonMatrixCaseBase;
import jcolibri.extensions.recommendation.conditionals.BuyOrQuit;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.SelectCases;
import jcolibri.test.main.SwingProgressBar;
import jcolibri.test.recommenders.rec12.moviesDB.Rating;
import jcolibri.test.recommenders.rec12.moviesDB.User;
import jcolibri.util.FileIO;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

public class MoviesRecommender
implements StandardCBRApplication {
    Connector _connector;
    PearsonMatrixCaseBase _caseBase;

    public void configure() throws ExecutionException {
        this._connector = new PlainTextConnector();
        this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/recommenders/rec12/plaintextconfig.xml"));
        this._caseBase = new PearsonMatrixCaseBase(new Attribute("rating", Rating.class), 20);
    }

    public void cycle(CBRQuery query) throws ExecutionException {
        query = ObtainQueryFromProfile.obtainQueryFromProfile("src/jcolibri/test/recommenders/rec12/profile.xml");
        Collection<RetrievalResult> res = CollaborativeRetrievalMethod.getRecommendation(this._caseBase, query, 10);
        Collection<CBRCase> cases = SelectCases.selectTopK(res, 5);
        UserChoice choice = DisplayCasesTableMethod.displayCasesInTableBasic(cases);
        if (BuyOrQuit.buyOrQuit(choice)) {
            System.out.println("Finish - User Buys: " + choice.getSelectedCase());
        } else {
            System.out.println("Finish - User Quits");
        }
    }

    public void postCycle() throws ExecutionException {
    }

    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        Collection<CBRCase> cases = this._caseBase.getCases();
        LogFactory.getLog(this.getClass()).info((Object)(String.valueOf(cases.size()) + " cases loaded"));
        return this._caseBase;
    }

    public static void main(String[] args) {
        ProgressController.clear();
        ProgressController.register(new SwingProgressBar(), MatrixCaseBase.class);
        MoviesRecommender recommender = new MoviesRecommender();
        try {
            recommender.configure();
            recommender.preCycle();
            CBRQuery query = new CBRQuery();
            query.setDescription(new User());
            recommender.cycle(query);
            recommender.postCycle();
        }
        catch (Exception e) {
            LogFactory.getLog(MoviesRecommender.class).error((Object)e);
        }
    }
}

