import java.io.File;
import java.io.IOException;
import java.util.List;


import org.jdom.Document;			
import org.jdom.Element;			
import org.jdom.JDOMException;		
import org.jdom.input.SAXBuilder;	

	public class ReadRequest {


		public static void ReadXML(Request request)throws IOException 
		{

			//Parsing file with SAX Builder
			SAXBuilder builder = new SAXBuilder();
			File xmlFile = new File( "Resources\\Request1.xml" );
			try
			{
				//Document creation
				Document document = (Document) builder.build( xmlFile );

				//Getting root....
				Element rootNode = document.getRootElement();

				//Getting roots childs
				List list = rootNode.getChildren( "table" );

				//Going throug tables
				for ( int i = 0; i < list.size(); i++ )
				{
					//Getting element.....
					Element tabla = (Element) list.get(i);

					//Getting "name" attribute
					//String nombreTabla = tabla.getAttributeValue("name");
					//System.out.println( "Table: " + nombreTabla );

					//Getting fields.....
					List lista_campos = tabla.getChildren();
					//System.out.println( "\t"+"Name"+"\t\t"+"Type"+"\t\t"+"Value" );

					//Going through fields....
					for ( int j = 0; j < lista_campos.size(); j++ )
					{
						//Se obtiene el elemento 'campo'
						Element campo = (Element)lista_campos.get( j );

						//Getting name .......
						String name = campo.getChildTextTrim("name");

						//Getting type......
						String type = campo.getChildTextTrim("type");

						//Getting value....
						String value = campo.getChildTextTrim("value");
						//System.out.println( "\t"+name+"\t\t"+type+"\t\t"+value);
						assign(name,type,value, request);
					}
				}
			}catch ( IOException io ) {
				System.out.println( io.getMessage() );
			}catch ( JDOMException jdomex ) {
				System.out.println( jdomex.getMessage() );
			}
		}
		
		public static void assign(String name,String type,String value, Request request )throws IOException 
		{

			if(name.compareTo("IDUser")==0)
				request.IDUser=Integer.parseInt(value);	
			else if (name.compareTo("IDRecipe")==0)
				request.IDRecipe=Integer.parseInt(value);	
			else if(name.compareTo("Type_Load")==0)
				request.Type_Load=value;	
			else if (name.compareTo("Dirtyness")==0)
				request.Dirtyness=value;				
			else if(name.compareTo("Load")==0)
					request.Load=value;	
		}
}


