/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.casebase;

import java.util.Collection;
import java.util.HashMap;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CaseBaseFilter;
import jcolibri.cbrcore.Connector;
import jcolibri.exception.AttributeAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDIndexedLinealCaseBase
implements CBRCaseBase {
    private Connector connector;
    private Collection<CBRCase> cases;
    private HashMap<Object, CBRCase> index;

    private void indexCases(Collection<CBRCase> cases) {
        this.index = new HashMap();
        for (CBRCase c : cases) {
            try {
                Object o = c.getDescription().getIdAttribute().getValue(c.getDescription());
                this.index.put(o, c);
            }
            catch (AttributeAccessException attributeAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public void init(Connector connector) {
        this.connector = connector;
        this.cases = this.connector.retrieveAllCases();
        this.indexCases(this.cases);
    }

    @Override
    public void close() {
        this.connector.close();
    }

    @Override
    public void forgetCases(Collection<CBRCase> cases) {
    }

    @Override
    public Collection<CBRCase> getCases() {
        return this.cases;
    }

    @Override
    public Collection<CBRCase> getCases(CaseBaseFilter filter) {
        return null;
    }

    @Override
    public void learnCases(Collection<CBRCase> cases) {
        this.connector.storeCases(cases);
        this.indexCases(cases);
        this.cases.addAll(cases);
    }

    public CBRCase getCase(Object id) {
        return this.index.get(id);
    }
}

