/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.connector;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CaseBaseFilter;
import jcolibri.cbrcore.CaseComponent;
import jcolibri.cbrcore.Connector;
import jcolibri.exception.InitializingException;
import jcolibri.util.FileIO;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBaseConnector
implements Connector {
    SessionFactory sessionFactory;
    private String descriptionClassName;
    private String solutionClassName;
    private String justOfSolutionClassName;
    private String resultClassName;

    @Override
    public void close() {
    }

    @Override
    public void deleteCases(Collection<CBRCase> cases) {
    }

    @Override
    public void initFromXMLfile(URL file) throws InitializingException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(file.openStream());
            String hcf = document.getElementsByTagName("HibernateConfigFile").item(0).getTextContent();
            String descriptionMapFile = document.getElementsByTagName("DescriptionMappingFile").item(0).getTextContent();
            this.descriptionClassName = document.getElementsByTagName("DescriptionClassName").item(0).getTextContent();
            Configuration hbconfig = new Configuration();
            hbconfig.configure(FileIO.findFile(hcf));
            hbconfig.addURL(FileIO.findFile(descriptionMapFile));
            try {
                String solutionMapFile = document.getElementsByTagName("SolutionMappingFile").item(0).getTextContent();
                this.solutionClassName = document.getElementsByTagName("SolutionClassName").item(0).getTextContent();
                hbconfig.addResource(solutionMapFile);
            }
            catch (Exception e) {
                LogFactory.getLog(this.getClass()).info((Object)"Case does not have solution");
            }
            try {
                String justOfSolutionMapFile = document.getElementsByTagName("JustificationOfSolutionMappingFile").item(0).getTextContent();
                this.justOfSolutionClassName = document.getElementsByTagName("JustificationOfSolutionClassName").item(0).getTextContent();
                hbconfig.addResource(justOfSolutionMapFile);
            }
            catch (Exception e) {
                LogFactory.getLog(this.getClass()).info((Object)"Case does not have justification of the solution");
            }
            try {
                String resultMapFile = document.getElementsByTagName("ResultMappingFile").item(0).getTextContent();
                this.resultClassName = document.getElementsByTagName("ResultClassName").item(0).getTextContent();
                hbconfig.addResource(resultMapFile);
            }
            catch (Exception e) {
                LogFactory.getLog(this.getClass()).info((Object)"Case does not have result");
            }
            this.sessionFactory = hbconfig.buildSessionFactory();
        }
        catch (Throwable ex) {
            throw new InitializingException(ex);
        }
    }

    @Override
    public Collection<CBRCase> retrieveAllCases() {
        ArrayList<CBRCase> res = new ArrayList<CBRCase>();
        try {
            List l;
            Transaction transaction;
            Session session;
            List descList = null;
            HashMap<Object, CaseComponent> solList = null;
            HashMap<Object, CaseComponent> justSolList = null;
            HashMap<Object, CaseComponent> resList = null;
            if (this.solutionClassName != null) {
                session = this.sessionFactory.openSession();
                transaction = session.beginTransaction();
                solList = new HashMap<Object, CaseComponent>();
                l = session.createQuery("from " + this.solutionClassName).list();
                transaction.commit();
                session.close();
                for (CaseComponent cc : l) {
                    solList.put(cc.getIdAttribute().getValue(cc), cc);
                }
            }
            if (this.justOfSolutionClassName != null) {
                session = this.sessionFactory.openSession();
                transaction = session.beginTransaction();
                justSolList = new HashMap<Object, CaseComponent>();
                l = session.createQuery("from " + this.justOfSolutionClassName).list();
                transaction.commit();
                session.close();
                for (CaseComponent cc : l) {
                    justSolList.put(cc.getIdAttribute().getValue(cc), cc);
                }
            }
            if (this.resultClassName != null) {
                session = this.sessionFactory.openSession();
                transaction = session.beginTransaction();
                resList = new HashMap<Object, CaseComponent>();
                l = session.createQuery("from " + this.resultClassName).list();
                transaction.commit();
                session.close();
                for (CaseComponent cc : l) {
                    resList.put(cc.getIdAttribute().getValue(cc), cc);
                }
            }
            session = this.sessionFactory.openSession();
            transaction = session.beginTransaction();
            descList = session.createQuery("from " + this.descriptionClassName).list();
            transaction.commit();
            session.close();
            Iterator iter = descList.iterator();
            while (iter.hasNext()) {
                CaseComponent cc;
                CBRCase _case = new CBRCase();
                CaseComponent desc = (CaseComponent)iter.next();
                _case.setDescription(desc);
                if (this.solutionClassName != null && (cc = (CaseComponent)solList.get(desc.getIdAttribute().getValue(desc))) != null) {
                    _case.setSolution(cc);
                }
                if (this.justOfSolutionClassName != null && (cc = (CaseComponent)justSolList.get(desc.getIdAttribute().getValue(desc))) != null) {
                    _case.setJustificationOfSolution(cc);
                }
                if (this.resultClassName != null && (cc = (CaseComponent)resList.get(desc.getIdAttribute().getValue(desc))) != null) {
                    _case.setResult(cc);
                }
                res.add(_case);
            }
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
        LogFactory.getLog(this.getClass()).info((Object)(String.valueOf(res.size()) + " cases read from the database."));
        return res;
    }

    @Override
    public Collection<CBRCase> retrieveSomeCases(CaseBaseFilter filter) {
        return null;
    }

    @Override
    public void storeCases(Collection<CBRCase> cases) {
        for (CBRCase c : cases) {
            Session session = this.sessionFactory.openSession();
            Transaction transaction = session.beginTransaction();
            session.save((Object)c.getDescription());
            transaction.commit();
            session.close();
            session = this.sessionFactory.openSession();
            transaction = session.beginTransaction();
            if (c.getSolution() != null) {
                session.saveOrUpdate((Object)c.getSolution());
            }
            transaction.commit();
            session.close();
            session = this.sessionFactory.openSession();
            transaction = session.beginTransaction();
            if (c.getJustificationOfSolution() != null) {
                session.saveOrUpdate((Object)c.getJustificationOfSolution());
            }
            transaction.commit();
            session.close();
            session = this.sessionFactory.openSession();
            transaction = session.beginTransaction();
            if (c.getResult() != null) {
                session.saveOrUpdate((Object)c.getResult());
            }
            transaction.commit();
            session.close();
        }
        LogFactory.getLog(this.getClass()).info((Object)(String.valueOf(cases.size()) + " cases stored into the database."));
    }
}

