/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.connector;

import es.ucm.fdi.gaia.ontobridge.OntoBridge;
import es.ucm.fdi.gaia.ontobridge.OntologyDocument;
import java.io.FileWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CaseBaseFilter;
import jcolibri.cbrcore.CaseComponent;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.ontologyutils.OntologyInfo;
import jcolibri.connector.ontologyutils.OntologyMapping;
import jcolibri.datatypes.Instance;
import jcolibri.exception.InitializingException;
import jcolibri.util.FileIO;
import jcolibri.util.OntoBridgeSingleton;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyConnector
implements Connector {
    private Class descriptionClass;
    private Class solutionClass;
    private Class justOfSolutionClass;
    private Class resultClass;
    private OntologyInfo mainOntologyInfo;
    private ArrayList<OntologyInfo> subOntologiesInfo;
    private String CaseMainConcept;
    private ArrayList<OntologyMapping> descriptionMappings;
    private ArrayList<OntologyMapping> solutionMappings;
    private ArrayList<OntologyMapping> justOfSolutionMappings;
    private ArrayList<OntologyMapping> resultMappings;
    private boolean modified;

    private OntologyInfo getOntologyInfo(Node node) {
        OntologyInfo oi = new OntologyInfo();
        NodeList ontologyNodes = node.getChildNodes();
        int i = 0;
        while (i < ontologyNodes.getLength()) {
            Node n = ontologyNodes.item(i);
            if (n.getNodeName().equals("URL")) {
                oi.setUrl(n.getTextContent());
            } else if (n.getNodeName().equals("LocalCopy")) {
                oi.setLocalCopy(n.getTextContent());
            }
            ++i;
        }
        return oi;
    }

    private void getOntologyMappings(Node mappings, ArrayList<OntologyMapping> descriptionMappings) {
        NodeList mappingNodes = mappings.getChildNodes();
        int i = 0;
        while (i < mappingNodes.getLength()) {
            Node n = mappingNodes.item(i);
            if (n.getNodeName().equals("Map")) {
                OntologyMapping om = new OntologyMapping();
                NodeList contents = n.getChildNodes();
                int j = 0;
                while (j < contents.getLength()) {
                    Node c = contents.item(j);
                    if (c.getNodeName().equals("Property")) {
                        om.setProperty(c.getTextContent());
                    } else if (c.getNodeName().equals("Concept")) {
                        om.setConcept(c.getTextContent());
                    } else if (c.getNodeName().equals("Attribute")) {
                        om.setAttribute(c.getTextContent());
                    }
                    ++j;
                }
                descriptionMappings.add(om);
            }
            ++i;
        }
    }

    @Override
    public void initFromXMLfile(URL file) throws InitializingException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file.openStream());
            this.mainOntologyInfo = this.getOntologyInfo(doc.getElementsByTagName("MainOntology").item(0));
            this.subOntologiesInfo = new ArrayList();
            NodeList subOntologiesNodes = doc.getElementsByTagName("SubOntology");
            int i = 0;
            while (i < subOntologiesNodes.getLength()) {
                this.subOntologiesInfo.add(this.getOntologyInfo(subOntologiesNodes.item(i)));
                ++i;
            }
            this.CaseMainConcept = doc.getElementsByTagName("CaseMainConcept").item(0).getTextContent();
            this.descriptionClass = Class.forName(doc.getElementsByTagName("DescriptionClassName").item(0).getTextContent());
            Node mappings = doc.getElementsByTagName("DescriptionMappings").item(0);
            this.descriptionMappings = new ArrayList();
            this.getOntologyMappings(mappings, this.descriptionMappings);
            try {
                this.solutionClass = Class.forName(doc.getElementsByTagName("SolutionClassName").item(0).getTextContent());
                mappings = doc.getElementsByTagName("SolutionMappings").item(0);
                this.solutionMappings = new ArrayList();
                this.getOntologyMappings(mappings, this.solutionMappings);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.justOfSolutionClass = Class.forName(doc.getElementsByTagName("JustificationOfSolutionClassName").item(0).getTextContent());
                mappings = doc.getElementsByTagName("JustificationOfSolutionMappings").item(0);
                this.justOfSolutionMappings = new ArrayList();
                this.getOntologyMappings(mappings, this.justOfSolutionMappings);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.resultClass = Class.forName(doc.getElementsByTagName("ResultClassName").item(0).getTextContent());
                mappings = doc.getElementsByTagName("ResultMappings").item(0);
                this.resultMappings = new ArrayList();
                this.getOntologyMappings(mappings, this.resultMappings);
            }
            catch (Exception exception) {
                // empty catch block
            }
            OntoBridge ob = OntoBridgeSingleton.getOntoBridge();
            ob.initWithPelletReasoner();
            OntologyDocument mainOnto = new OntologyDocument(this.mainOntologyInfo.getUrl(), FileIO.findFile(this.mainOntologyInfo.getLocalCopy()).toExternalForm());
            ArrayList<OntologyDocument> subOntologies = new ArrayList<OntologyDocument>();
            for (OntologyInfo oi : this.subOntologiesInfo) {
                OntologyDocument subOnto = new OntologyDocument(oi.getUrl(), FileIO.findFile(oi.getLocalCopy()).toURI().toString());
                subOntologies.add(subOnto);
            }
            ob.loadOntology(mainOnto, subOntologies, false);
            this.modified = false;
        }
        catch (Exception e) {
            throw new InitializingException(e);
        }
    }

    @Override
    public Collection<CBRCase> retrieveAllCases() {
        ArrayList<CBRCase> cases = new ArrayList<CBRCase>();
        OntoBridge ob = OntoBridgeSingleton.getOntoBridge();
        ProgressController.init(this.getClass(), "Loading concepts", -1);
        Iterator caseInstances = ob.listInstances(this.CaseMainConcept);
        while (caseInstances.hasNext()) {
            String caseInstance = (String)caseInstances.next();
            CBRCase _case = new CBRCase();
            try {
                CaseComponent cc;
                CaseComponent description = (CaseComponent)this.descriptionClass.newInstance();
                this.retrieveCaseComponent(ob, description, caseInstance, this.descriptionMappings);
                _case.setDescription(description);
                if (this.solutionClass != null) {
                    cc = (CaseComponent)this.solutionClass.newInstance();
                    this.retrieveCaseComponent(ob, cc, caseInstance, this.solutionMappings);
                    _case.setSolution(cc);
                }
                if (this.justOfSolutionClass != null) {
                    cc = (CaseComponent)this.justOfSolutionClass.newInstance();
                    this.retrieveCaseComponent(ob, cc, caseInstance, this.justOfSolutionMappings);
                    _case.setJustificationOfSolution(cc);
                }
                if (this.resultClass != null) {
                    cc = (CaseComponent)this.resultClass.newInstance();
                    this.retrieveCaseComponent(ob, cc, caseInstance, this.resultMappings);
                    _case.setResult(cc);
                }
                cases.add(_case);
            }
            catch (Exception e) {
                LogFactory.getLog(this.getClass()).error((Object)e);
            }
            ProgressController.step(this.getClass());
        }
        ProgressController.finish(this.getClass());
        return cases;
    }

    private void retrieveCaseComponent(OntoBridge ob, CaseComponent cc, String mainInstanceName, ArrayList<OntologyMapping> mappings) throws Exception {
        Instance id = new Instance(mainInstanceName);
        cc.getIdAttribute().setValue(cc, id);
        for (OntologyMapping om : mappings) {
            Attribute at = new Attribute(om.getAttribute(), cc.getClass());
            Iterator values = ob.listPropertyValue(mainInstanceName, om.getProperty());
            boolean found = false;
            while (values.hasNext() && !found) {
                String valueInstance = (String)values.next();
                if (!ob.isInstanceOf(valueInstance, om.getConcept())) continue;
                found = true;
                Instance concept = new Instance(valueInstance);
                at.setValue(cc, concept);
            }
        }
    }

    @Override
    public Collection<CBRCase> retrieveSomeCases(CaseBaseFilter filter) {
        LogFactory.getLog(this.getClass()).error((Object)"retrieveSomeCases(CaseBaseFilter) method is not yet implemented");
        return null;
    }

    @Override
    public void storeCases(Collection<CBRCase> cases) {
        if (cases.isEmpty()) {
            return;
        }
        this.modified = true;
        OntoBridge ob = OntoBridgeSingleton.getOntoBridge();
        ProgressController.init(this.getClass(), "Storing concepts/cases", cases.size());
        for (CBRCase _case : cases) {
            try {
                if (!ob.existsInstance(_case.getID().toString(), this.CaseMainConcept)) {
                    ob.createInstance(this.CaseMainConcept, _case.getID().toString());
                }
                this.createCaseComponent(_case.getDescription(), this.descriptionMappings);
                this.createCaseComponent(_case.getSolution(), this.solutionMappings);
                this.createCaseComponent(_case.getJustificationOfSolution(), this.justOfSolutionMappings);
                this.createCaseComponent(_case.getResult(), this.resultMappings);
            }
            catch (Exception e) {
                LogFactory.getLog(this.getClass()).error((Object)("Error storing case: " + _case + ". Cause: " + e.getMessage()));
            }
            ProgressController.step(this.getClass());
        }
        ProgressController.finish(this.getClass());
    }

    private void createCaseComponent(CaseComponent cc, ArrayList<OntologyMapping> maps) throws Exception {
        if (cc == null || maps == null) {
            return;
        }
        OntoBridge ob = OntoBridgeSingleton.getOntoBridge();
        String mainInstance = cc.getIdAttribute().getValue(cc).toString();
        for (OntologyMapping om : maps) {
            Attribute at = new Attribute(om.getAttribute(), cc.getClass());
            String instance = at.getValue(cc).toString();
            if (!ob.existsInstance(instance, om.getConcept())) {
                ob.createInstance(om.getConcept(), instance);
            }
            ob.createOntProperty(mainInstance, om.getProperty(), instance);
        }
    }

    @Override
    public void close() {
        if (!this.modified) {
            return;
        }
        OntoBridge ob = OntoBridgeSingleton.getOntoBridge();
        try {
            ob.save(new FileWriter(FileIO.findFile(this.mainOntologyInfo.getLocalCopy()).getFile()));
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    @Override
    public void deleteCases(Collection<CBRCase> cases) {
        if (cases.isEmpty()) {
            return;
        }
        this.modified = true;
        OntoBridge ob = OntoBridgeSingleton.getOntoBridge();
        ProgressController.init(this.getClass(), "Deleting concepts/cases", cases.size());
        for (CBRCase _case : cases) {
            ob.delete(_case.getID().toString());
            ProgressController.step(this.getClass());
        }
        ProgressController.finish(this.getClass());
    }

    public String getCaseMainConcept() {
        return this.CaseMainConcept;
    }

    public ArrayList<OntologyMapping> getDescriptionMappings() {
        return this.descriptionMappings;
    }

    public ArrayList<OntologyMapping> getJustOfSolutionMappings() {
        return this.justOfSolutionMappings;
    }

    public OntologyInfo getMainOntologyInfo() {
        return this.mainOntologyInfo;
    }

    public ArrayList<OntologyMapping> getResultMappings() {
        return this.resultMappings;
    }

    public ArrayList<OntologyMapping> getSolutionMappings() {
        return this.solutionMappings;
    }

    public ArrayList<OntologyInfo> getSubOntologiesInfo() {
        return this.subOntologiesInfo;
    }
}

