/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.connector;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CaseBaseFilter;
import jcolibri.cbrcore.CaseComponent;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.plaintextutils.PlainTextTypeConverter;
import jcolibri.exception.AttributeAccessException;
import jcolibri.exception.InitializingException;
import jcolibri.util.FileIO;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainTextConnector
implements Connector {
    protected String PROP_FILEPATH = "";
    protected String PROP_DELIM = "";
    private Class descriptionClass;
    private Class solutionClass;
    private Class justOfSolutionClass;
    private Class resultClass;
    List<Attribute> descriptionMaps;
    List<Attribute> solutionMaps;
    List<Attribute> justOfSolutionMaps;
    List<Attribute> resultMaps;

    @Override
    public void initFromXMLfile(URL file) throws InitializingException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file.openStream());
            this.PROP_FILEPATH = doc.getElementsByTagName("FilePath").item(0).getTextContent();
            this.PROP_DELIM = doc.getElementsByTagName("Delimiters").item(0).getTextContent();
            this.descriptionClass = Class.forName(doc.getElementsByTagName("DescriptionClassName").item(0).getTextContent());
            try {
                this.solutionClass = Class.forName(doc.getElementsByTagName("SolutionClassName").item(0).getTextContent());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.justOfSolutionClass = Class.forName(doc.getElementsByTagName("JustificationOfSolutionClassName").item(0).getTextContent());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.resultClass = Class.forName(doc.getElementsByTagName("ResultClassName").item(0).getTextContent());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.descriptionMaps = this.findMaps(doc.getElementsByTagName("DescriptionMappings").item(0), this.descriptionClass);
            if (this.solutionClass != null) {
                this.solutionMaps = this.findMaps(doc.getElementsByTagName("SolutionMappings").item(0), this.solutionClass);
            }
            if (this.justOfSolutionClass != null) {
                this.justOfSolutionMaps = this.findMaps(doc.getElementsByTagName("JustificationOfSolutionMappings").item(0), this.justOfSolutionClass);
            }
            if (this.resultClass != null) {
                this.resultMaps = this.findMaps(doc.getElementsByTagName("ResultMappings").item(0), this.resultClass);
            }
        }
        catch (Exception e) {
            throw new InitializingException(e);
        }
    }

    private List<Attribute> findMaps(Node n, Class _class) {
        ArrayList<Attribute> res = new ArrayList<Attribute>();
        NodeList childs = n.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node c = childs.item(i);
            if (c.getNodeName().equals("Map")) {
                String attributeName = c.getTextContent();
                res.add(new Attribute(attributeName, _class));
            }
            ++i;
        }
        return res;
    }

    @Override
    public void close() {
    }

    @Override
    public void storeCases(Collection<CBRCase> cases) {
        try {
            BufferedWriter br = null;
            br = new BufferedWriter(new FileWriter(FileIO.findFile(this.PROP_FILEPATH).getFile(), true));
            if (br == null) {
                throw new Exception("Error opening file for writing: " + this.PROP_FILEPATH);
            }
            char separator = this.PROP_DELIM.charAt(0);
            for (CBRCase _case : cases) {
                CaseComponent result;
                CaseComponent justOfSolution;
                br.newLine();
                StringBuffer line = new StringBuffer();
                CaseComponent description = _case.getDescription();
                this.writeComponent(description, this.descriptionMaps, line, separator, true);
                CaseComponent solution = _case.getSolution();
                if (solution != null) {
                    line.append(separator);
                    this.writeComponent(solution, this.solutionMaps, line, separator, false);
                }
                if ((justOfSolution = _case.getJustificationOfSolution()) != null) {
                    line.append(separator);
                    this.writeComponent(justOfSolution, this.justOfSolutionMaps, line, separator, false);
                }
                if ((result = _case.getResult()) != null) {
                    line.append(separator);
                    this.writeComponent(result, this.resultMaps, line, separator, false);
                }
                br.write(line.toString());
            }
            br.close();
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    private void writeComponent(CaseComponent comp, List<Attribute> maps, StringBuffer line, char separator, boolean includeId) {
        try {
            if (includeId) {
                line.append(comp.getIdAttribute().getValue(comp));
            }
            for (Attribute a : maps) {
                line.append(separator);
                line.append(a.getValue(comp));
            }
        }
        catch (AttributeAccessException e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    @Override
    public void deleteCases(Collection<CBRCase> cases) {
        try {
            BufferedReader br = null;
            br = new BufferedReader(new InputStreamReader(FileIO.findFile(this.PROP_FILEPATH).openStream()));
            if (br == null) {
                throw new Exception("Error opening file for reading: " + this.PROP_FILEPATH);
            }
            ArrayList<String> lines = new ArrayList<String>();
            String line = "";
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.length() == 0) {
                    lines.add(line);
                    continue;
                }
                StringTokenizer st = new StringTokenizer(line, this.PROP_DELIM);
                String caseId = st.nextToken();
                for (CBRCase _case : cases) {
                    if (caseId.equals(_case.getID().toString())) continue;
                    lines.add(line);
                }
            }
            br.close();
            BufferedWriter bw = null;
            bw = new BufferedWriter(new FileWriter(FileIO.findFile(this.PROP_FILEPATH).getFile(), false));
            if (bw == null) {
                throw new Exception("Error opening file for writing: " + this.PROP_FILEPATH);
            }
            ListIterator lIter = lines.listIterator();
            while (lIter.hasNext()) {
                line = (String)lIter.next();
                bw.write(line);
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)("Error deleting cases " + e.getMessage()));
        }
    }

    @Override
    public Collection<CBRCase> retrieveAllCases() {
        LinkedList<CBRCase> cases = new LinkedList<CBRCase>();
        try {
            BufferedReader br = null;
            br = new BufferedReader(new InputStreamReader(FileIO.openFile(this.PROP_FILEPATH)));
            if (br == null) {
                throw new Exception("Error opening file: " + this.PROP_FILEPATH);
            }
            String line = "";
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.length() == 0) continue;
                StringTokenizer st = new StringTokenizer(line, this.PROP_DELIM);
                CBRCase _case = new CBRCase();
                CaseComponent description = (CaseComponent)this.descriptionClass.newInstance();
                this.fillComponent(description, st, this.descriptionMaps, true);
                _case.setDescription(description);
                if (this.solutionClass != null) {
                    CaseComponent solution = (CaseComponent)this.solutionClass.newInstance();
                    this.fillComponent(solution, st, this.solutionMaps, false);
                    _case.setSolution(solution);
                }
                if (this.justOfSolutionClass != null) {
                    CaseComponent justificationOfSolution = (CaseComponent)this.justOfSolutionClass.newInstance();
                    this.fillComponent(justificationOfSolution, st, this.justOfSolutionMaps, false);
                    _case.setJustificationOfSolution(justificationOfSolution);
                }
                if (this.resultClass != null) {
                    CaseComponent result = (CaseComponent)this.resultClass.newInstance();
                    this.fillComponent(result, st, this.resultMaps, false);
                    _case.setResult(result);
                }
                cases.add(_case);
            }
            br.close();
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)("Error retrieving cases " + e.getMessage()));
        }
        return cases;
    }

    private void fillComponent(CaseComponent component, StringTokenizer st, List<Attribute> maps, boolean includeId) {
        try {
            Object value;
            Class<?> type;
            if (includeId) {
                Attribute idAttribute = component.getIdAttribute();
                type = idAttribute.getType();
                value = PlainTextTypeConverter.convert(st.nextToken(), type);
                idAttribute.setValue(component, value);
            }
            for (Attribute at : maps) {
                type = at.getType();
                value = PlainTextTypeConverter.convert(st.nextToken(), type);
                at.setValue(component, value);
            }
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)("Error creating case: " + e.getMessage()));
        }
    }

    @Override
    public Collection<CBRCase> retrieveSomeCases(CaseBaseFilter filter) {
        return null;
    }
}

