/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.evaluation.evaluators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import jcolibri.casebase.CachedLinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.evaluation.EvaluationReport;
import jcolibri.evaluation.Evaluator;
import jcolibri.exception.ExecutionException;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NFoldEvaluator
extends Evaluator {
    protected StandardCBRApplication app;
    protected ArrayList<ArrayList<CBRCase>> _folds;

    @Override
    public void init(StandardCBRApplication cbrApp) {
        report = new EvaluationReport();
        this.app = cbrApp;
        try {
            this.app.configure();
        }
        catch (ExecutionException e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    public void NFoldEvaluation(int folds, int repetitions) {
        try {
            long t = new Date().getTime();
            int numberOfCycles = 0;
            LogFactory.getLog(this.getClass()).info((Object)"Running precycle()");
            CBRCaseBase caseBase = this.app.preCycle();
            if (!(caseBase instanceof CachedLinealCaseBase)) {
                LogFactory.getLog(this.getClass()).warn((Object)"Evaluation should be executed using a cached case base");
            }
            ArrayList<CBRCase> cases = new ArrayList<CBRCase>(caseBase.getCases());
            int r = 0;
            while (r < repetitions) {
                this.createFolds(cases, folds);
                int f = 0;
                while (f < folds) {
                    ArrayList<CBRCase> querySet = new ArrayList<CBRCase>();
                    ArrayList<CBRCase> caseBaseSet = new ArrayList<CBRCase>();
                    this.getFolds(f, querySet, caseBaseSet);
                    caseBase.forgetCases(cases);
                    caseBase.learnCases(caseBaseSet);
                    for (CBRCase c : querySet) {
                        LogFactory.getLog(this.getClass()).info((Object)("Running cycle() " + numberOfCycles));
                        this.app.cycle(c);
                        ++numberOfCycles;
                    }
                    ++f;
                }
                ++r;
            }
            caseBase.forgetCases(cases);
            caseBase.learnCases(cases);
            LogFactory.getLog(this.getClass()).info((Object)"Running postcycle()");
            this.app.postCycle();
            report.setTotalTime(t);
            report.setNumberOfCycles(numberOfCycles);
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    protected void createFolds(Collection<CBRCase> cases, int folds) {
        this._folds = new ArrayList();
        int foldsize = cases.size() / folds;
        ArrayList<CBRCase> copy = new ArrayList<CBRCase>(cases);
        int f = 0;
        while (f < folds) {
            ArrayList<CBRCase> fold = new ArrayList<CBRCase>();
            int i = 0;
            while (i < foldsize && copy.size() > 0) {
                int random = (int)(Math.random() * (double)copy.size());
                CBRCase _case = copy.get(random);
                copy.remove(random);
                fold.add(_case);
                ++i;
            }
            this._folds.add(fold);
            ++f;
        }
    }

    protected void getFolds(int f, List<CBRCase> querySet, List<CBRCase> caseBaseSet) {
        querySet.clear();
        caseBaseSet.clear();
        querySet.addAll((Collection<CBRCase>)this._folds.get(f));
        int i = 0;
        while (i < this._folds.size()) {
            if (i != f) {
                caseBaseSet.addAll((Collection<CBRCase>)this._folds.get(i));
            }
            ++i;
        }
    }
}

