/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.evaluation.evaluators;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import jcolibri.casebase.CachedLinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.evaluation.EvaluationReport;
import jcolibri.evaluation.Evaluator;
import jcolibri.exception.ExecutionException;
import jcolibri.util.FileIO;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SameSplitEvaluator
extends Evaluator {
    protected StandardCBRApplication app;

    @Override
    public void init(StandardCBRApplication cbrApp) {
        report = new EvaluationReport();
        this.app = cbrApp;
        try {
            this.app.configure();
        }
        catch (ExecutionException e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    public void generateSplit(int testPercent, String filename) {
        LogFactory.getLog(this.getClass()).info((Object)"Running precycle()");
        CBRCaseBase caseBase = null;
        try {
            caseBase = this.app.preCycle();
        }
        catch (ExecutionException e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
        if (!(caseBase instanceof CachedLinealCaseBase)) {
            LogFactory.getLog(this.getClass()).warn((Object)"Evaluation should be executed using a cached case base");
        }
        ArrayList<CBRCase> originalCases = new ArrayList<CBRCase>(caseBase.getCases());
        ArrayList<CBRCase> querySet = new ArrayList<CBRCase>();
        ArrayList<CBRCase> caseBaseSet = new ArrayList<CBRCase>();
        this.splitCaseBase(originalCases, querySet, caseBaseSet, testPercent);
        this.save(querySet, filename);
    }

    protected void save(Collection<CBRCase> queries, String filename) {
        try {
            BufferedWriter br = null;
            br = new BufferedWriter(new FileWriter(filename));
            if (br == null) {
                throw new Exception("Error opening file for writing: " + filename);
            }
            for (CBRCase _case : queries) {
                br.write(_case.getID().toString());
                br.newLine();
            }
            br.close();
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    public void HoldOutfromFile(String file) {
        try {
            long t = new Date().getTime();
            int numberOfCycles = 0;
            LogFactory.getLog(this.getClass()).info((Object)"Running precycle()");
            CBRCaseBase caseBase = this.app.preCycle();
            if (!(caseBase instanceof CachedLinealCaseBase)) {
                LogFactory.getLog(this.getClass()).warn((Object)"Evaluation should be executed using a cached case base");
            }
            ArrayList<CBRCase> originalCases = new ArrayList<CBRCase>(caseBase.getCases());
            ArrayList<CBRCase> querySet = new ArrayList<CBRCase>();
            ArrayList<CBRCase> caseBaseSet = new ArrayList<CBRCase>();
            this.splitCaseBaseFromFile(originalCases, querySet, caseBaseSet, file);
            int totalSteps = querySet.size();
            ProgressController.init(this.getClass(), "Same Split - Hold Out Evaluation", totalSteps);
            caseBase.forgetCases(originalCases);
            caseBase.learnCases(caseBaseSet);
            for (CBRCase c : querySet) {
                LogFactory.getLog(this.getClass()).info((Object)("Running cycle() " + numberOfCycles));
                this.app.cycle(c);
                ProgressController.step(this.getClass());
                ++numberOfCycles;
            }
            ProgressController.finish(this.getClass());
            caseBase.forgetCases(originalCases);
            caseBase.learnCases(originalCases);
            LogFactory.getLog(this.getClass()).info((Object)"Running postcycle()");
            this.app.postCycle();
            t = new Date().getTime() - t;
            report.setTotalTime(t);
            report.setNumberOfCycles(numberOfCycles);
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    protected void splitCaseBase(Collection<CBRCase> wholeCaseBase, List<CBRCase> querySet, List<CBRCase> casebaseSet, int testPercent) {
        querySet.clear();
        casebaseSet.clear();
        int querySetSize = wholeCaseBase.size() * testPercent / 100;
        casebaseSet.addAll(wholeCaseBase);
        int i = 0;
        while (i < querySetSize) {
            int random = (int)(Math.random() * (double)casebaseSet.size());
            CBRCase _case = casebaseSet.get(random);
            casebaseSet.remove(random);
            querySet.add(_case);
            ++i;
        }
    }

    protected void splitCaseBaseFromFile(Collection<CBRCase> wholeCaseBase, List<CBRCase> querySet, List<CBRCase> casebaseSet, String filename) {
        querySet.clear();
        casebaseSet.clear();
        casebaseSet.addAll(wholeCaseBase);
        try {
            BufferedReader br = null;
            br = new BufferedReader(new FileReader(FileIO.findFile(filename).getFile()));
            if (br == null) {
                throw new Exception("Error opening file: " + filename);
            }
            String line = "";
            while ((line = br.readLine()) != null) {
                CBRCase c = null;
                int pos = 0;
                boolean found = false;
                Iterator<CBRCase> iter = casebaseSet.iterator();
                while (iter.hasNext() && !found) {
                    c = iter.next();
                    if (c.getID().toString().equals(line)) {
                        found = true;
                        continue;
                    }
                    ++pos;
                }
                if (c == null) {
                    LogFactory.getLog(this.getClass()).error((Object)("Case " + line + " not found into case base"));
                    continue;
                }
                casebaseSet.remove(pos);
                querySet.add(c);
            }
            br.close();
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }
}

