/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.recommendation.casesDisplay;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CaseComponent;
import jcolibri.exception.AttributeAccessException;
import jcolibri.extensions.recommendation.casesDisplay.UserChoice;
import jcolibri.method.gui.utils.LayoutUtils;
import jcolibri.method.gui.utils.WindowUtils;
import jcolibri.util.AttributeUtils;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayCasesMethod {
    private static CBRCase[] _cases;
    private static int i;
    private static JPanel casesPanel;
    private static JDialog dialog;
    private static int returnCode;
    private static CBRCase selectedCase;

    static {
        i = 0;
        returnCode = -1;
        selectedCase = null;
    }

    public static UserChoice displayCases(Collection<CBRCase> cases) {
        return DisplayCasesMethod.displayCases(cases, false);
    }

    public static UserChoice displayCasesWithEditOption(Collection<CBRCase> cases) {
        return DisplayCasesMethod.displayCases(cases, true);
    }

    public static UserChoice displayCases(Collection<CBRCase> cases, boolean editQueryEnabled) {
        _cases = new CBRCase[cases.size()];
        cases.toArray(_cases);
        dialog = new JDialog();
        dialog.setModal(true);
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        casesPanel = new JPanel();
        casesPanel.setLayout(new BoxLayout(casesPanel, 1));
        DisplayCasesMethod.displayCase();
        main.add((Component)casesPanel, "Center");
        JPanel actionsPanel = new JPanel();
        actionsPanel.setLayout(new BoxLayout(actionsPanel, 0));
        JButton next = new JButton("Next >>");
        next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                i = (i + 1) % _cases.length;
                DisplayCasesMethod.displayCase();
            }
        });
        JButton prev = new JButton("<< Previous");
        prev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                i = (i - 1) % _cases.length;
                DisplayCasesMethod.displayCase();
            }
        });
        JButton ok = new JButton("Add to Basket");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                returnCode = -3;
                selectedCase = _cases[i];
                dialog.setVisible(false);
            }
        });
        JButton quit = new JButton("Quit");
        quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                returnCode = -1;
                dialog.setVisible(false);
            }
        });
        JButton refine = new JButton("Edit Query");
        refine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                returnCode = -2;
                dialog.setVisible(false);
            }
        });
        refine.setEnabled(editQueryEnabled);
        actionsPanel.add(ok);
        actionsPanel.add(quit);
        if (editQueryEnabled) {
            actionsPanel.add(refine);
        }
        actionsPanel.add(Box.createHorizontalGlue());
        actionsPanel.add(prev);
        actionsPanel.add(next);
        main.add((Component)actionsPanel, "South");
        dialog.getContentPane().add(main);
        dialog.pack();
        dialog.setSize(new Dimension((int)dialog.getSize().getWidth() + 50, (int)dialog.getSize().getHeight()));
        WindowUtils.centerWindow(dialog);
        dialog.setTitle(String.valueOf(cases.size()) + " Retrieved cases");
        dialog.setVisible(true);
        return new UserChoice(returnCode, selectedCase);
    }

    private static void displayCase() {
        casesPanel.removeAll();
        CBRCase c = _cases[i];
        DisplayCasesMethod.displayCaseComponent(c.getDescription(), "Description", casesPanel);
        DisplayCasesMethod.displayCaseComponent(c.getSolution(), "Solution", casesPanel);
        DisplayCasesMethod.displayCaseComponent(c.getJustificationOfSolution(), "Justification of Solution", casesPanel);
        DisplayCasesMethod.displayCaseComponent(c.getResult(), "Result", casesPanel);
        casesPanel.validate();
        casesPanel.repaint();
        dialog.setTitle("Case " + (i + 1) + "/" + _cases.length);
    }

    private static void displayCaseComponent(CaseComponent cc, String title, JPanel parentPanel) {
        if (cc == null) {
            return;
        }
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(title));
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel simplePanel = new JPanel();
        simplePanel.setLayout(new SpringLayout());
        JPanel compoundPanel = new JPanel();
        compoundPanel.setLayout(new BoxLayout(compoundPanel, 1));
        try {
            Attribute[] ats = AttributeUtils.getAttributes(cc.getClass());
            ArrayList<Attribute> compounds = new ArrayList<Attribute>();
            int sAtts = 0;
            Attribute[] attributeArray = ats;
            int n = 0;
            int n2 = attributeArray.length;
            while (n < n2) {
                Attribute a = attributeArray[n];
                if (a.getType().equals(CaseComponent.class)) {
                    compounds.add(a);
                } else {
                    simplePanel.add(new JLabel(a.getName()));
                    simplePanel.add(new JLabel(a.getValue(cc).toString()));
                    ++sAtts;
                }
                ++n;
            }
            LayoutUtils.makeCompactGrid(simplePanel, sAtts, 2, 5, 5, 15, 5);
            for (Attribute comp : compounds) {
                DisplayCasesMethod.displayCaseComponent((CaseComponent)comp.getValue(cc), comp.getName(), compoundPanel);
            }
            panel.add(simplePanel);
            panel.add(compoundPanel);
            casesPanel.add(panel);
        }
        catch (AttributeAccessException e) {
            LogFactory.getLog(AttributeUtils.class).error((Object)e);
        }
    }
}

