/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.recommendation.collaborative;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.extensions.recommendation.collaborative.MatrixCaseBase;
import jcolibri.extensions.recommendation.collaborative.PearsonMatrixCaseBase;
import jcolibri.method.retrieve.RetrievalResult;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollaborativeRetrievalMethod {
    public static Collection<RetrievalResult> getRecommendation(PearsonMatrixCaseBase cb, CBRQuery query, int kUsers) {
        ArrayList<RetrievalResult> result = new ArrayList<RetrievalResult>();
        int id = (Integer)query.getID();
        Collection<MatrixCaseBase.SimilarTuple> simil = cb.getSimilar(id);
        if (simil == null) {
            LogFactory.getLog(CollaborativeRetrievalMethod.class).error((Object)("Id " + id + " does not exists"));
            return result;
        }
        ArrayList<MatrixCaseBase.SimilarTuple> select = new ArrayList<MatrixCaseBase.SimilarTuple>();
        int i = 0;
        Iterator<MatrixCaseBase.SimilarTuple> iter = simil.iterator();
        while (iter.hasNext() && i < kUsers) {
            select.add(iter.next());
            ++i;
        }
        System.out.println("\nQuery: " + cb.getDescription(id));
        System.out.println(String.valueOf(cb.getRatingTuples(id).size()) + " Ratings: " + cb.getRatingTuples(id));
        System.out.println("\nSimilar ratings:");
        for (MatrixCaseBase.SimilarTuple st : select) {
            System.out.print(String.valueOf(st.getSimilarity()) + " <--- ");
            System.out.println(cb.getDescription(st.getSimilarId()));
            System.out.println(String.valueOf(cb.getRatingTuples(st.getSimilarId()).size()) + " Ratings: " + cb.getRatingTuples(st.getSimilarId()));
        }
        for (Integer solId : cb.getSolutions()) {
            double mean = cb.getAverage(id);
            double acum = 0.0;
            double simacum = 0.0;
            for (MatrixCaseBase.SimilarTuple st : select) {
                int other = st.getSimilarId();
                double rating = CollaborativeRetrievalMethod.findRating(cb, other, solId);
                double otherMean = cb.getAverage(other);
                acum += (rating - otherMean) * st.getSimilarity();
                simacum += st.getSimilarity();
            }
            double res = mean + acum / simacum;
            CBRCase c = new CBRCase();
            c.setDescription(cb.getDescription(id));
            c.setSolution(cb.getSolution(solId));
            result.add(new RetrievalResult(c, res));
        }
        Collections.sort(result);
        return result;
    }

    private static double findRating(PearsonMatrixCaseBase cb, int descId, int solId) {
        for (MatrixCaseBase.RatingTuple rt : cb.getRatingTuples(descId)) {
            if (rt.getSolutionId() != solId) continue;
            return rt.getRating();
        }
        return 0.0;
    }
}

