/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.recommendation.collaborative;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CaseBaseFilter;
import jcolibri.cbrcore.CaseComponent;
import jcolibri.cbrcore.Connector;
import jcolibri.exception.AttributeAccessException;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MatrixCaseBase
implements CBRCaseBase {
    private Connector connector;
    private Collection<CBRCase> cases;
    private Attribute value;
    HashMap<Integer, ArrayList<RatingTuple>> byDescriptionId;
    HashMap<Integer, CaseComponent> descriptions;
    HashMap<Integer, CaseComponent> solutions;

    protected abstract void computeSimilarities();

    public abstract double getSimil(Integer var1, Integer var2);

    public abstract Collection<SimilarTuple> getSimilar(Integer var1);

    public MatrixCaseBase(Attribute value) {
        this.value = value;
    }

    @Override
    public void init(Connector connector) {
        this.connector = connector;
        ProgressController.init(MatrixCaseBase.class, "Organizing Collaborative Case Base", -1);
        LogFactory.getLog(this.getClass()).info((Object)"Loading cases from connector");
        this.cases = this.connector.retrieveAllCases();
        this.organizeByDescriptionId();
        this.computeSimilarities();
        ProgressController.finish(MatrixCaseBase.class);
    }

    public CaseComponent getDescription(Integer id) {
        return this.descriptions.get(id);
    }

    public Set<Integer> getDescriptions() {
        return this.descriptions.keySet();
    }

    public CaseComponent getSolution(Integer id) {
        return this.solutions.get(id);
    }

    public Set<Integer> getSolutions() {
        return this.solutions.keySet();
    }

    public Collection<RatingTuple> getRatingTuples(int descriptionId) {
        return this.byDescriptionId.get(descriptionId);
    }

    private void organizeByDescriptionId() {
        LogFactory.getLog(this.getClass()).info((Object)"Organizing cases");
        try {
            this.byDescriptionId = new HashMap();
            this.descriptions = new HashMap();
            this.solutions = new HashMap();
            for (CBRCase cBRCase : this.cases) {
                Integer descId = (Integer)cBRCase.getID();
                ArrayList<RatingTuple> list = this.byDescriptionId.get(descId);
                if (list == null) {
                    list = new ArrayList();
                    this.byDescriptionId.put(descId, list);
                    this.descriptions.put(descId, cBRCase.getDescription());
                }
                Integer solId = (Integer)cBRCase.getSolution().getIdAttribute().getValue(cBRCase.getSolution());
                this.solutions.put(solId, cBRCase.getSolution());
                Number resId = (Number)this.value.getValue(cBRCase.getResult());
                list.add(new RatingTuple(solId, resId.doubleValue()));
                ProgressController.step(MatrixCaseBase.class);
            }
            for (ArrayList arrayList : this.byDescriptionId.values()) {
                Collections.sort(arrayList);
            }
        }
        catch (AttributeAccessException attributeAccessException) {
            LogFactory.getLog(this.getClass()).error((Object)attributeAccessException);
        }
    }

    @Override
    public void close() {
        this.connector.close();
    }

    @Override
    public void forgetCases(Collection<CBRCase> cases) {
    }

    @Override
    public Collection<CBRCase> getCases() {
        return this.cases;
    }

    @Override
    public Collection<CBRCase> getCases(CaseBaseFilter filter) {
        return null;
    }

    @Override
    public void learnCases(Collection<CBRCase> cases) {
        this.cases.addAll(cases);
        this.connector.storeCases(cases);
        this.organizeByDescriptionId();
        this.computeSimilarities();
    }

    public class RatingTuple
    implements Comparable {
        int solutionId;
        double rating;

        public RatingTuple(int solutionId, double rating) {
            this.solutionId = solutionId;
            this.rating = rating;
        }

        public boolean equals(Object o) {
            return this.solutionId == ((RatingTuple)o).getSolutionId();
        }

        public int compareTo(Object o) {
            return this.solutionId - ((RatingTuple)o).solutionId;
        }

        public double getRating() {
            return this.rating;
        }

        public int getSolutionId() {
            return this.solutionId;
        }

        public String toString() {
            return "(" + this.solutionId + "->" + this.rating + ")";
        }
    }

    public class SimilarTuple
    implements Comparable {
        int similarId;
        double similarity;

        public SimilarTuple(int similarId, double similarity) {
            this.similarId = similarId;
            this.similarity = similarity;
        }

        public int getSimilarId() {
            return this.similarId;
        }

        public double getSimilarity() {
            return this.similarity;
        }

        public int compareTo(Object o) {
            return (int)(1000.0 * (((SimilarTuple)o).similarity - this.similarity));
        }

        public String toString() {
            return "[" + this.similarId + "," + this.similarity + "]";
        }
    }

    class CommonRatingTuple {
        int id1;
        double rating1;
        int id2;
        double rating2;
        int ratedId;

        public CommonRatingTuple(int id1, double rating1, int id2, double rating2, int ratedId) {
            this.id1 = id1;
            this.rating1 = rating1;
            this.id2 = id2;
            this.rating2 = rating2;
            this.ratedId = ratedId;
        }

        public int getId1() {
            return this.id1;
        }

        public int getId2() {
            return this.id2;
        }

        public int getRatedId() {
            return this.ratedId;
        }

        public double getRating1() {
            return this.rating1;
        }

        public double getRating2() {
            return this.rating2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CommonRatingsIterator
    implements Iterator {
        int idA;
        int idB;
        Collection<RatingTuple> rtsA;
        Collection<RatingTuple> rtsB;
        Iterator<RatingTuple> iterA;
        Iterator<RatingTuple> iterB;
        RatingTuple rka;
        RatingTuple rkb;
        boolean moreRatings;
        CommonRatingTuple current;

        public CommonRatingsIterator(int idA, int idB, Collection<RatingTuple> rtsA, Collection<RatingTuple> rtsB) {
            this.idA = idA;
            this.idB = idB;
            this.rtsA = rtsA;
            this.rtsB = rtsB;
            this.iterA = rtsA.iterator();
            this.iterB = rtsB.iterator();
            if (this.iterA.hasNext() && this.iterB.hasNext()) {
                this.rka = this.iterA.next();
                this.rkb = this.iterB.next();
                this.moreRatings = true;
                this.current = this.getNextMatch();
            } else {
                this.current = null;
                this.moreRatings = false;
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        public Object next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            CommonRatingTuple temp = this.current;
            this.current = this.getNextMatch();
            return temp;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("remove not supported in CommonRatingsIterator");
        }

        /*
         * Unable to fully structure code
         */
        private CommonRatingTuple getNextMatch() {
            match = null;
            ** GOTO lbl22
            {
                if (this.iterA.hasNext()) {
                    this.rka = this.iterA.next();
                } else {
                    this.moreRatings = false;
                }
                do {
                    if (this.rka.compareTo(this.rkb) < 0 && this.moreRatings) continue block0;
                    if (this.rka.compareTo(this.rkb) == 0) {
                        match = new CommonRatingTuple(this.idA, this.rka.getRating(), this.idB, this.rkb.getRating(), this.rka.getSolutionId());
                        if (this.iterA.hasNext() && this.iterB.hasNext()) {
                            this.rka = this.iterA.next();
                            this.rkb = this.iterB.next();
                        } else {
                            this.moreRatings = false;
                        }
                    }
                    while (this.rka.compareTo(this.rkb) > 0 && this.moreRatings) {
                        if (this.iterB.hasNext()) {
                            this.rkb = this.iterB.next();
                            continue;
                        }
                        this.moreRatings = false;
                    }
lbl22:
                    // 2 sources

                } while (this.moreRatings && match == null);
            }
            return match;
        }
    }
}

