/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.IE.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.CaseComponent;
import jcolibri.exception.AttributeAccessException;
import jcolibri.extensions.textual.IE.IEutils;
import jcolibri.extensions.textual.IE.common.GlossaryLinker;
import jcolibri.extensions.textual.IE.representation.IEText;
import jcolibri.extensions.textual.IE.representation.Token;
import jcolibri.extensions.textual.IE.representation.info.WeightedRelation;
import jcolibri.extensions.textual.wordnet.WordNetBridge;
import jcolibri.util.AttributeUtils;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThesaurusLinker {
    public static void linkWithWordNet(Collection<CBRCase> cases, CBRQuery query) {
        LogFactory.getLog(ThesaurusLinker.class).info((Object)"Linking tokens with WordNet.");
        ProgressController.init(ThesaurusLinker.class, "Linking tokens with WordNet ...", cases.size());
        ArrayList<IEText> queryTexts = new ArrayList<IEText>();
        IEutils.addTexts(query.getDescription(), queryTexts);
        for (CBRCase c : cases) {
            ArrayList<IEText> caseTexts = new ArrayList<IEText>();
            IEutils.addTexts(c.getDescription(), caseTexts);
            int i = 0;
            while (i < queryTexts.size()) {
                IEText queryText = (IEText)queryTexts.get(i);
                IEText caseText = (IEText)caseTexts.get(i);
                ThesaurusLinker.linkWithWordNet(caseText, queryText);
                ++i;
            }
            ProgressController.step(ThesaurusLinker.class);
        }
        ProgressController.finish(ThesaurusLinker.class);
    }

    public static void linkWithWordNet(Collection<CBRCase> cases, CBRQuery query, Collection<Attribute> attributes) {
        LogFactory.getLog(ThesaurusLinker.class).info((Object)"Linking tokens with WordNet.");
        ProgressController.init(ThesaurusLinker.class, "Linking tokens with WordNet ...", cases.size());
        for (CBRCase c : cases) {
            for (Attribute at : attributes) {
                CaseComponent caseCC = AttributeUtils.findBelongingComponent(at, c);
                CaseComponent queryCC = AttributeUtils.findBelongingComponent(at, query);
                try {
                    IEText queryText = (IEText)at.getValue(queryCC);
                    IEText caseText = (IEText)at.getValue(caseCC);
                    ThesaurusLinker.linkWithWordNet(caseText, queryText);
                }
                catch (AttributeAccessException e) {
                    LogFactory.getLog(GlossaryLinker.class).error((Object)e);
                }
            }
            ProgressController.step(ThesaurusLinker.class);
        }
        ProgressController.finish(ThesaurusLinker.class);
    }

    public static void linkWithWordNet(IEText caseText, IEText queryText) {
        List<Token> queryTokens = queryText.getAllTokens();
        List<Token> caseTokens = caseText.getAllTokens();
        for (Token queryTok : queryTokens) {
            for (Token caseTok : caseTokens) {
                WordNetBridge.POS casePOS;
                WordNetBridge.POS queryPOS = ThesaurusLinker.lookupWordNetPos(queryTok.getPostag());
                if (queryPOS != (casePOS = ThesaurusLinker.lookupWordNetPos(caseTok.getPostag())) || queryTok.isStopWord() || caseTok.isStopWord() || queryTok.getStem().equals(caseTok.getStem()) || !WordNetBridge.sameSynset((String)queryTok.getRawContent(), (WordNetBridge.POS)queryPOS, (String)caseTok.getRawContent(), (WordNetBridge.POS)casePOS)) continue;
                queryTok.addRelation(new WeightedRelation(queryTok, caseTok, 0.75));
            }
        }
    }

    public static void loadWordNet() {
        WordNetBridge.init();
    }

    static WordNetBridge.POS lookupWordNetPos(String tag) {
        if (tag.equals("NN") || tag.equals("NNS")) {
            return WordNetBridge.POS.NOUN;
        }
        if (tag.startsWith("V")) {
            return WordNetBridge.POS.VERB;
        }
        if (tag.startsWith("J")) {
            return WordNetBridge.POS.ADJECTIVE;
        }
        if (tag.startsWith("RB")) {
            return WordNetBridge.POS.ADVERB;
        }
        return null;
    }
}

