/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.IE.gate;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Factory;
import gate.creole.ExecutionException;
import gate.creole.Transducer;
import java.util.Collection;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.extensions.textual.IE.IEutils;
import jcolibri.extensions.textual.IE.gate.GatePhrasesExtractor;
import jcolibri.extensions.textual.IE.gate.IETextGate;
import jcolibri.extensions.textual.IE.representation.IEText;
import jcolibri.extensions.textual.IE.representation.info.FeatureInfo;
import jcolibri.util.AttributeUtils;
import jcolibri.util.FileIO;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GateFeaturesExtractor {
    static Transducer featureExtractor;
    private static String defaultRulesFileName;

    static {
        defaultRulesFileName = "jcolibri/extensions/textual/IE/gate/gateinit/plugins/ANNIE/resources/NE/main.jape";
    }

    public static void extractFeatures(Collection<CBRCase> cases, Collection<Attribute> attributes) {
        LogFactory.getLog(GateFeaturesExtractor.class).info((Object)"Extracting features.");
        ProgressController.init(GateFeaturesExtractor.class, "Extracting features ...", cases.size());
        for (CBRCase c : cases) {
            for (Attribute a : attributes) {
                Object o = AttributeUtils.findValue(a, c);
                GateFeaturesExtractor.extractFeatures((IETextGate)o);
            }
            ProgressController.step(GateFeaturesExtractor.class);
        }
        ProgressController.finish(GateFeaturesExtractor.class);
    }

    public static void extractFeatures(CBRQuery query, Collection<Attribute> attributes) {
        LogFactory.getLog(GateFeaturesExtractor.class).info((Object)"Extracting features.");
        for (Attribute a : attributes) {
            Object o = AttributeUtils.findValue(a, query);
            GateFeaturesExtractor.extractFeatures((IETextGate)o);
        }
    }

    public static void extractFeatures(Collection<CBRCase> cases) {
        LogFactory.getLog(GateFeaturesExtractor.class).info((Object)"Extracting features.");
        ProgressController.init(GateFeaturesExtractor.class, "Extracting features ...", cases.size());
        for (CBRCase c : cases) {
            Collection<IEText> texts = IEutils.getTexts(c);
            for (IEText t : texts) {
                if (!(t instanceof IETextGate)) continue;
                GateFeaturesExtractor.extractFeatures((IETextGate)t);
            }
            ProgressController.step(GateFeaturesExtractor.class);
        }
        ProgressController.finish(GateFeaturesExtractor.class);
    }

    public static void extractFeatures(CBRQuery query) {
        LogFactory.getLog(GateFeaturesExtractor.class).info((Object)"Extracting features.");
        Collection<IEText> texts = IEutils.getTexts(query);
        for (IEText t : texts) {
            if (!(t instanceof IETextGate)) continue;
            GateFeaturesExtractor.extractFeatures((IETextGate)t);
        }
    }

    public static void extractFeatures(IETextGate text) {
        try {
            featureExtractor.setDocument(text.getDocument());
            featureExtractor.execute();
            String content = text.getRAWContent();
            AnnotationSet featuresAnnotations = text.getDocument().getAnnotations("Features");
            for (Annotation anot : featuresAnnotations) {
                String Type2 = anot.getType();
                int begin = anot.getStartNode().getOffset().intValue();
                int end = anot.getEndNode().getOffset().intValue();
                String value = content.substring(begin, end);
                text.addFeature(new FeatureInfo(Type2, value, begin, end));
            }
        }
        catch (ExecutionException e) {
            LogFactory.getLog(GateFeaturesExtractor.class).error((Object)e);
        }
    }

    public static void loadDefaultRules() {
        GateFeaturesExtractor.loadRules(defaultRulesFileName);
    }

    public static void loadRules(String filename) {
        try {
            featureExtractor = (Transducer)Factory.createResource((String)"gate.creole.ANNIETransducer");
            featureExtractor.setGrammarURL(FileIO.findFile(filename));
            featureExtractor.setOutputASName("Features");
            featureExtractor.init();
        }
        catch (Exception e) {
            LogFactory.getLog(GatePhrasesExtractor.class).error((Object)e);
        }
    }
}

