/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.IE.gate;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Factory;
import gate.creole.POSTagger;
import java.util.Collection;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.extensions.textual.IE.IEutils;
import jcolibri.extensions.textual.IE.gate.IETextGate;
import jcolibri.extensions.textual.IE.representation.IEText;
import jcolibri.extensions.textual.IE.representation.Token;
import jcolibri.util.AttributeUtils;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatePOStagger {
    private static POSTagger tagger = null;

    public static void tag(Collection<CBRCase> cases, Collection<Attribute> attributes) {
        LogFactory.getLog(GatePOStagger.class).info((Object)"Gate POS tagging...");
        ProgressController.init(GatePOStagger.class, "Gate POS tagging...", cases.size());
        for (CBRCase c : cases) {
            for (Attribute a : attributes) {
                Object o = AttributeUtils.findValue(a, c);
                if (!(o instanceof IETextGate)) continue;
                GatePOStagger.tag((IETextGate)o);
            }
            ProgressController.step(GatePOStagger.class);
        }
        ProgressController.finish(GatePOStagger.class);
    }

    public static void tag(CBRQuery query, Collection<Attribute> attributes) {
        LogFactory.getLog(GatePOStagger.class).info((Object)"Gate POS tagging...");
        for (Attribute a : attributes) {
            Object o = AttributeUtils.findValue(a, query);
            if (!(o instanceof IETextGate)) continue;
            GatePOStagger.tag((IETextGate)o);
        }
    }

    public static void tag(Collection<CBRCase> cases) {
        LogFactory.getLog(GatePOStagger.class).info((Object)"Gate POS tagging...");
        ProgressController.init(GatePOStagger.class, "Gate POS tagging...", cases.size());
        for (CBRCase c : cases) {
            Collection<IEText> texts = IEutils.getTexts(c);
            for (IEText t : texts) {
                if (!(t instanceof IETextGate)) continue;
                GatePOStagger.tag((IETextGate)t);
            }
            ProgressController.step(GatePOStagger.class);
        }
        ProgressController.finish(GatePOStagger.class);
    }

    public static void tag(CBRQuery query) {
        LogFactory.getLog(GatePOStagger.class).info((Object)"Gate POS tagging...");
        Collection<IEText> texts = IEutils.getTexts(query);
        for (IEText t : texts) {
            if (!(t instanceof IETextGate)) continue;
            GatePOStagger.tag((IETextGate)t);
        }
    }

    public static void tag(IETextGate text) {
        try {
            POSTagger tagger = GatePOStagger.getTokeniser();
            tagger.setDocument(text.getDocument());
            tagger.execute();
            AnnotationSet posAnnotations = text.getDocument().getAnnotations().get("POS");
            for (Token t : text.getAllTokens()) {
                Annotation anotToken = text.getTokenMapping(t);
                AnnotationSet posAnnots = posAnnotations.get(anotToken.getStartNode().getOffset(), anotToken.getEndNode().getOffset());
                Annotation anot = (Annotation)posAnnots.iterator().next();
                String postag = (String)anot.getFeatures().get((Object)"category");
                t.setPostag(postag);
            }
        }
        catch (Exception e) {
            LogFactory.getLog(GatePOStagger.class).error((Object)e);
        }
    }

    private static POSTagger getTokeniser() throws Exception {
        if (tagger == null) {
            tagger = (POSTagger)Factory.createResource((String)"gate.creole.POSTagger");
            tagger.setBaseSentenceAnnotationType("Sentence");
            tagger.setBaseTokenAnnotationType("Token");
            tagger.setOutputAnnotationType("POS");
            tagger.init();
        }
        return tagger;
    }
}

