/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.IE.gate;

import gate.Annotation;
import gate.AnnotationSet;
import gate.Document;
import gate.Factory;
import gate.creole.splitter.SentenceSplitter;
import gate.creole.tokeniser.DefaultTokeniser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.extensions.textual.IE.IEutils;
import jcolibri.extensions.textual.IE.gate.IETextGate;
import jcolibri.extensions.textual.IE.representation.IEText;
import jcolibri.extensions.textual.IE.representation.Paragraph;
import jcolibri.extensions.textual.IE.representation.Sentence;
import jcolibri.extensions.textual.IE.representation.Token;
import jcolibri.util.AttributeUtils;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GateSplitter {
    private static DefaultTokeniser tokeniser = null;
    private static SentenceSplitter sentenceSplitter = null;

    public static void split(Collection<CBRCase> cases, Collection<Attribute> attributes) {
        LogFactory.getLog(GateSplitter.class).info((Object)"Splitting Gate text.");
        ProgressController.init(GateSplitter.class, "Splitting Gate text", cases.size());
        for (CBRCase c : cases) {
            for (Attribute a : attributes) {
                Object o = AttributeUtils.findValue(a, c);
                if (!(o instanceof IETextGate)) continue;
                GateSplitter.split((IETextGate)o);
            }
            ProgressController.step(GateSplitter.class);
        }
        ProgressController.finish(GateSplitter.class);
    }

    public static void split(CBRQuery query, Collection<Attribute> attributes) {
        LogFactory.getLog(GateSplitter.class).info((Object)"Splitting Gate text.");
        for (Attribute a : attributes) {
            Object o = AttributeUtils.findValue(a, query);
            if (!(o instanceof IETextGate)) continue;
            GateSplitter.split((IETextGate)o);
        }
    }

    public static void split(Collection<CBRCase> cases) {
        LogFactory.getLog(GateSplitter.class).info((Object)"Splitting Gate text.");
        ProgressController.init(GateSplitter.class, "Splitting Gate text", cases.size());
        for (CBRCase c : cases) {
            Collection<IEText> texts = IEutils.getTexts(c);
            for (IEText t : texts) {
                if (!(t instanceof IETextGate)) continue;
                GateSplitter.split((IETextGate)t);
            }
            ProgressController.step(GateSplitter.class);
        }
        ProgressController.finish(GateSplitter.class);
    }

    public static void split(CBRQuery query) {
        LogFactory.getLog(GateSplitter.class).info((Object)"Splitting Gate text.");
        Collection<IEText> texts = IEutils.getTexts(query);
        for (IEText t : texts) {
            if (!(t instanceof IETextGate)) continue;
            GateSplitter.split((IETextGate)t);
        }
    }

    public static void split(IETextGate text) {
        try {
            DefaultTokeniser tokeniser = GateSplitter.getTokeniser();
            tokeniser.setDocument(text.getDocument());
            tokeniser.execute();
            SentenceSplitter sentenceSplitter = GateSplitter.getSentenceSplitter();
            sentenceSplitter.setDocument(text.getDocument());
            sentenceSplitter.execute();
            GateSplitter.organizeText(text);
        }
        catch (Exception e) {
            LogFactory.getLog(GateSplitter.class).error((Object)e);
        }
    }

    protected static void organizeText(IETextGate text) {
        Document doc = text.getDocument();
        String content = text.getRAWContent();
        AnnotationSet parAnnot = doc.getAnnotations("Original markups");
        AnnotationSet paragraphs = parAnnot.get("paragraph");
        AnnotationSet annot = doc.getAnnotations();
        ArrayList sents = new ArrayList(annot.get("Sentence"));
        Collections.sort(sents);
        ArrayList tokens = new ArrayList(annot.get("Token"));
        Collections.sort(tokens);
        ArrayList sentsToRemove = new ArrayList();
        ArrayList<Annotation> tokensToRemove = new ArrayList<Annotation>();
        int p = 0;
        while (p < paragraphs.size()) {
            Annotation par = paragraphs.get(Integer.valueOf(p));
            int beginP = par.getStartNode().getOffset().intValue();
            int endP = par.getEndNode().getOffset().intValue();
            Paragraph myPar = new Paragraph(content.substring(beginP, endP));
            text.addParagraph(myPar);
            text.setParagraphMapping(myPar, par);
            sentsToRemove.clear();
            int s = 0;
            while (s < sents.size()) {
                Annotation sent = (Annotation)sents.get(s);
                int beginS = sent.getStartNode().getOffset().intValue();
                int endS = sent.getEndNode().getOffset().intValue();
                if (beginS >= beginP && endS <= endP) {
                    Sentence mySent = new Sentence(content.substring(beginS, endS));
                    myPar.addSentence(mySent);
                    text.setSentenceMapping(mySent, sent);
                    sentsToRemove.remove(sent);
                    tokensToRemove.clear();
                    int t = 0;
                    while (t < tokens.size()) {
                        Annotation token = (Annotation)tokens.get(t);
                        int beginT = token.getStartNode().getOffset().intValue();
                        int endT = token.getEndNode().getOffset().intValue();
                        if (beginT >= beginS && endT <= endS) {
                            Token myToken = new Token(content.substring(beginT, endT));
                            mySent.addToken(myToken);
                            text.setTokenMapping(myToken, token);
                            tokensToRemove.add(token);
                        }
                        ++t;
                    }
                    tokens.removeAll(tokensToRemove);
                }
                ++s;
            }
            sents.removeAll(sentsToRemove);
            ++p;
        }
    }

    private static DefaultTokeniser getTokeniser() throws Exception {
        if (tokeniser == null) {
            tokeniser = (DefaultTokeniser)Factory.createResource((String)"gate.creole.tokeniser.DefaultTokeniser");
            tokeniser.init();
        }
        return tokeniser;
    }

    private static SentenceSplitter getSentenceSplitter() throws Exception {
        if (sentenceSplitter == null) {
            sentenceSplitter = (SentenceSplitter)Factory.createResource((String)"gate.creole.splitter.SentenceSplitter");
            sentenceSplitter.init();
        }
        return sentenceSplitter;
    }
}

