/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.IE.opennlp;

import java.util.Collection;
import java.util.Iterator;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.extensions.textual.IE.IEutils;
import jcolibri.extensions.textual.IE.opennlp.IETextOpenNLP;
import jcolibri.extensions.textual.IE.representation.IEText;
import jcolibri.extensions.textual.IE.representation.Token;
import jcolibri.util.AttributeUtils;
import jcolibri.util.ProgressController;
import opennlp.grok.preprocess.namefind.EnglishNameFinderME;
import opennlp.grok.preprocess.namefind.NameFinderME;
import org.apache.commons.logging.LogFactory;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpennlpMainNamesExtractor {
    private static NameFinderME nameFinder = null;

    public static void extractMainNames(Collection<CBRCase> cases, Collection<Attribute> attributes) {
        LogFactory.getLog(OpennlpMainNamesExtractor.class).info((Object)"Extracting main names.");
        ProgressController.init(OpennlpMainNamesExtractor.class, "Extracting main names...", cases.size());
        for (CBRCase c : cases) {
            for (Attribute a : attributes) {
                Object o = AttributeUtils.findValue(a, c);
                if (!(o instanceof IETextOpenNLP)) continue;
                OpennlpMainNamesExtractor.extractMainNames((IETextOpenNLP)o);
            }
            ProgressController.step(OpennlpMainNamesExtractor.class);
        }
        ProgressController.finish(OpennlpMainNamesExtractor.class);
    }

    public static void extractMainNames(CBRQuery query, Collection<Attribute> attributes) {
        LogFactory.getLog(OpennlpMainNamesExtractor.class).info((Object)"Extracting main names.");
        for (Attribute a : attributes) {
            Object o = AttributeUtils.findValue(a, query);
            if (!(o instanceof IETextOpenNLP)) continue;
            OpennlpMainNamesExtractor.extractMainNames((IETextOpenNLP)o);
        }
    }

    public static void extractMainNames(Collection<CBRCase> cases) {
        LogFactory.getLog(OpennlpMainNamesExtractor.class).info((Object)"Extracting main names.");
        ProgressController.init(OpennlpMainNamesExtractor.class, "Extracting main names", cases.size());
        for (CBRCase c : cases) {
            Collection<IEText> texts = IEutils.getTexts(c);
            for (IEText t : texts) {
                if (!(t instanceof IETextOpenNLP)) continue;
                OpennlpMainNamesExtractor.extractMainNames((IETextOpenNLP)t);
            }
            ProgressController.step(OpennlpMainNamesExtractor.class);
        }
        ProgressController.finish(OpennlpMainNamesExtractor.class);
    }

    public static void extractMainNames(CBRQuery query) {
        LogFactory.getLog(OpennlpMainNamesExtractor.class).info((Object)"Extracting main names.");
        Collection<IEText> texts = IEutils.getTexts(query);
        for (IEText t : texts) {
            if (!(t instanceof IETextOpenNLP)) continue;
            OpennlpMainNamesExtractor.extractMainNames((IETextOpenNLP)t);
        }
    }

    public static void extractMainNames(IETextOpenNLP text) {
        NameFinderME nameFinder = OpennlpMainNamesExtractor.getNameFinder();
        try {
            nameFinder.process(text.getDocument());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Iterator<Token> iterator = text.getAllTokens().iterator();
        while (iterator.hasNext()) {
            Token t;
            Element tok = text.getTokenMapping(t = iterator.next());
            String val = tok.getAttributeValue("type");
            t.setMainName(val != null && val.equals("name"));
        }
    }

    private static NameFinderME getNameFinder() {
        if (nameFinder == null) {
            nameFinder = new EnglishNameFinderME();
        }
        return nameFinder;
    }
}

