/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.textual.lucene.spanish;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Set;
import jcolibri.extensions.textual.lucene.spanish.SpanishStemmerFilter;
import jcolibri.util.FileIO;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class SpanishAnalyzer
extends Analyzer {
    private Set stopSet = StopFilter.makeStopSet((String[])SpanishAnalyzer.loadStopWords());

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new StandardTokenizer(reader);
        result = new StandardFilter((TokenStream)result);
        result = new LowerCaseFilter((TokenStream)result);
        result = new StopFilter((TokenStream)result, this.stopSet);
        result = new SpanishStemmerFilter((TokenStream)result);
        return result;
    }

    private static String[] loadStopWords() throws IOException {
        InputStreamReader isr = new InputStreamReader(FileIO.openFile("jcolibri/extensions/textual/lucene/spanish/stopwords-spanish.txt"));
        BufferedReader br = new BufferedReader(isr);
        String line = br.readLine();
        ArrayList<String> list = new ArrayList<String>();
        while (line != null) {
            list.add(line.trim());
            line = br.readLine();
        }
        String[] stopWords = new String[list.toArray().length];
        int i = 0;
        while (i < list.toArray().length) {
            stopWords[i] = (String)list.get(i);
            ++i;
        }
        return stopWords;
    }
}

