/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.extensions.visualization;

import es.csic.iiia.visualgraph.CBGraph;
import es.csic.iiia.visualgraph.CaseBaseVis;
import es.csic.iiia.visualgraph.GraphLayout;
import es.csic.iiia.visualgraph.InfoVisual;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import jcolibri.cbrcore.CBRCase;
import jcolibri.extensions.classification.ClassificationSolution;
import jcolibri.method.retrieve.NNretrieval.NNConfig;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.util.ProgressController;
import prefuse.data.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasesVisualization {
    public static void visualize(Collection<CBRCase> cases, NNConfig knnConfig) {
        CBGraph graph = new CBGraph();
        Hashtable<CBRCase, Integer> case2id = new Hashtable<CBRCase, Integer>();
        for (CBRCase c : cases) {
            ClassificationSolution sol = (ClassificationSolution)c.getSolution();
            int id = graph.addCase(c.getID().toString(), sol.getClassification().toString());
            case2id.put(c, id);
        }
        ArrayList<CBRCase> copy = new ArrayList<CBRCase>(cases);
        int total = cases.size() * (cases.size() - 1) / 2;
        ProgressController.init(CasesVisualization.class, "Computing distances", total);
        for (CBRCase c : cases) {
            copy.remove(c);
            Collection<RetrievalResult> result = NNScoringMethod.evaluateSimilarity(copy, c, knnConfig);
            int currentcaseId = (Integer)case2id.get(c);
            for (RetrievalResult sim : result) {
                CBRCase otherCase = sim.get_case();
                int othercaseId = (Integer)case2id.get(otherCase);
                float distance = (float)(1.0 - sim.getEval());
                graph.addDistance(currentcaseId, othercaseId, distance);
                System.out.println("Distance: " + c.getID() + " <--> " + otherCase.getID() + ": " + distance);
                ProgressController.step(CasesVisualization.class);
            }
        }
        ProgressController.finish(CasesVisualization.class);
        new InfoVisual((GraphLayout)new CaseBaseVis((Graph)graph), true, false);
    }
}

