/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.gui.formFilling;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.CaseComponent;
import jcolibri.exception.AttributeAccessException;
import jcolibri.method.gui.editors.ParameterEditor;
import jcolibri.method.gui.editors.ParameterEditorFactory;
import jcolibri.method.gui.utils.LayoutUtils;
import jcolibri.method.gui.utils.WindowUtils;
import jcolibri.util.AttributeUtils;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObtainQueryWithFormMethod {
    private static Hashtable<Attribute, ParameterEditor> editors;
    private static JDialog dialog;

    public static void obtainQueryWithoutInitialValues(CBRQuery query, Collection<Attribute> hiddenAttributes, Map<Attribute, String> labels) {
        ObtainQueryWithFormMethod.obtainQuery(query, false, hiddenAttributes, labels);
    }

    public static void obtainQueryWithInitialValues(CBRQuery query, Collection<Attribute> hiddenAttributes, Map<Attribute, String> labels) {
        ObtainQueryWithFormMethod.obtainQuery(query, true, hiddenAttributes, labels);
    }

    static void obtainQuery(CBRQuery query, boolean useQueryvalues, Collection<Attribute> hiddenAttributes, Map<Attribute, String> labels) {
        dialog = new JDialog();
        dialog.setModal(true);
        editors = new Hashtable();
        JPanel panel = new JPanel();
        ObtainQueryWithFormMethod.addAttributes(query.getDescription(), panel, hiddenAttributes, labels);
        if (useQueryvalues) {
            for (Attribute a : editors.keySet()) {
                ParameterEditor editor = editors.get(a);
                editor.setEditorValue(AttributeUtils.findValue(a, query));
            }
        }
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)panel, "Center");
        JPanel okPanel = new JPanel();
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                dialog.setVisible(false);
            }
        });
        okPanel.add(okButton);
        dialog.getContentPane().add((Component)okPanel, "South");
        dialog.pack();
        WindowUtils.centerWindow(dialog);
        dialog.setTitle("Query");
        dialog.setVisible(true);
        for (Attribute a : editors.keySet()) {
            Object value = editors.get(a).getEditorValue();
            AttributeUtils.setValue(a, query, value);
        }
        System.out.println(query);
    }

    private static void addAttributes(CaseComponent cc, JPanel panel, Collection<Attribute> hiddenAttributes, Map<Attribute, String> labels) {
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel simplePanel = new JPanel();
        simplePanel.setLayout(new SpringLayout());
        JPanel compoundPanel = new JPanel();
        compoundPanel.setLayout(new BoxLayout(compoundPanel, 1));
        try {
            if (hiddenAttributes == null) {
                hiddenAttributes = new ArrayList<Attribute>();
            }
            if (labels == null) {
                labels = new HashMap<Attribute, String>();
            }
            Attribute[] ats = AttributeUtils.getAttributes(cc.getClass());
            Attribute id = cc.getIdAttribute();
            ArrayList<Attribute> compounds = new ArrayList<Attribute>();
            int sAtts = 0;
            Attribute[] attributeArray = ats;
            int n = 0;
            int n2 = attributeArray.length;
            while (n < n2) {
                Attribute a = attributeArray[n];
                if (!a.equals(id)) {
                    if (a.getType().equals(CaseComponent.class)) {
                        compounds.add(a);
                    } else if (!hiddenAttributes.contains(a)) {
                        String label = labels.get(a);
                        if (label == null) {
                            label = a.getName();
                        }
                        simplePanel.add(new JLabel(label));
                        ParameterEditor pe = ParameterEditorFactory.getEditor(a.getType());
                        simplePanel.add(pe.getJComponent());
                        editors.put(a, pe);
                        ++sAtts;
                    }
                }
                ++n;
            }
            LayoutUtils.makeCompactGrid(simplePanel, sAtts, 2, 5, 5, 5, 5);
            for (Attribute comp : compounds) {
                JPanel subpanel = new JPanel();
                subpanel.setBorder(BorderFactory.createTitledBorder(comp.getName()));
                ObtainQueryWithFormMethod.addAttributes((CaseComponent)comp.getValue(cc), subpanel, hiddenAttributes, labels);
                compoundPanel.add(subpanel);
            }
            panel.add(simplePanel);
            panel.add(compoundPanel);
        }
        catch (AttributeAccessException e) {
            LogFactory.getLog(AttributeUtils.class).error((Object)e);
        }
    }
}

