/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.maintenance.algorithms;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jcolibri.cbrcore.CBRCase;
import jcolibri.exception.InitializingException;
import jcolibri.method.maintenance.AbstractCaseBaseEditMethod;
import jcolibri.method.maintenance.CaseResult;
import jcolibri.method.maintenance.CompetenceModel;
import jcolibri.method.maintenance.solvesFunctions.CBESolvesFunction;
import jcolibri.method.reuse.classification.KNNClassificationConfig;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRRRedundancyRemoval
extends AbstractCaseBaseEditMethod {
    public List<CBRCase> retrieveCasesToDelete(Collection<CBRCase> cases, KNNClassificationConfig simConfig) {
        ProgressController.init(this.getClass(), "Conservative Redundancy Removal(CRR)", -1);
        LinkedList<CBRCase> localCases = new LinkedList<CBRCase>();
        for (CBRCase c : cases) {
            localCases.add(c);
        }
        CompetenceModel sc = new CompetenceModel();
        sc.computeCompetenceModel(new CBESolvesFunction(), simConfig, localCases);
        LinkedList<CBRCase> tSet = new LinkedList<CBRCase>();
        List<CaseResult> caseCoverageSetSizes = new LinkedList<CaseResult>();
        for (CBRCase c : localCases) {
            tSet.add(c);
            Collection<CBRCase> currCoverageSet = null;
            try {
                currCoverageSet = sc.getCoverageSet(c);
                caseCoverageSetSizes.add(new CaseResult(c, (double)currCoverageSet.size()));
            }
            catch (InitializingException e) {
                LogFactory.getLog(this.getClass()).error((Object)e);
            }
            ProgressController.step(this.getClass());
        }
        caseCoverageSetSizes = CaseResult.sortResults(true, caseCoverageSetSizes);
        LinkedList<CBRCase> newCases = new LinkedList<CBRCase>();
        LinkedList<CBRCase> allCasesToBeRemoved = new LinkedList<CBRCase>();
        while (caseCoverageSetSizes.size() > 0) {
            LinkedList<CBRCase> removeThese = new LinkedList<CBRCase>();
            CBRCase c = caseCoverageSetSizes.get(0).getCase();
            newCases.add(c);
            try {
                Collection<CBRCase> cCoverageSet = sc.getCoverageSet(c);
                for (CBRCase removed : cCoverageSet) {
                    if (!removed.equals(c) && !allCasesToBeRemoved.contains(removed)) {
                        allCasesToBeRemoved.add(removed);
                    }
                    removeThese.add(removed);
                }
                ListIterator<CaseResult> iter = null;
                iter = caseCoverageSetSizes.listIterator();
                while (iter.hasNext() && removeThese.size() > 0) {
                    CaseResult cResult = iter.next();
                    if (!removeThese.contains(cResult.getCase())) continue;
                    iter.remove();
                    removeThese.remove(cResult.getCase());
                }
                caseCoverageSetSizes = CaseResult.sortResults(true, caseCoverageSetSizes);
            }
            catch (InitializingException e) {
                LogFactory.getLog(this.getClass()).error((Object)e);
            }
            ProgressController.step(this.getClass());
        }
        ProgressController.finish(this.getClass());
        return allCasesToBeRemoved;
    }
}

