/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.maintenance.algorithms;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import jcolibri.cbrcore.CBRCase;
import jcolibri.extensions.classification.ClassificationSolution;
import jcolibri.method.maintenance.AbstractCaseBaseEditMethod;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.SelectCases;
import jcolibri.method.reuse.classification.KNNClassificationConfig;
import jcolibri.method.reuse.classification.KNNClassificationMethod;
import jcolibri.method.revise.classification.BasicClassificationOracle;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RENNNoiseReduction
extends AbstractCaseBaseEditMethod {
    @Override
    public Collection<CBRCase> retrieveCasesToDelete(Collection<CBRCase> cases, KNNClassificationConfig simConfig) {
        ProgressController.init(this.getClass(), "RENN Noise Reduction", -1);
        LinkedList<CBRCase> localCases = new LinkedList<CBRCase>();
        for (CBRCase c : cases) {
            localCases.add(c);
        }
        LinkedList<CBRCase> allCasesToBeRemoved = new LinkedList<CBRCase>();
        boolean changes = true;
        while (changes && localCases.size() > 1) {
            changes = false;
            ListIterator<CBRCase> iter = localCases.listIterator();
            while (iter.hasNext()) {
                CBRCase q = (CBRCase)iter.next();
                iter.remove();
                Collection<RetrievalResult> knn = NNScoringMethod.evaluateSimilarity(localCases, q, simConfig);
                knn = SelectCases.selectTopKRR(knn, simConfig.getK());
                try {
                    KNNClassificationMethod classifier = simConfig.getClassificationMethod();
                    ClassificationSolution predictedSolution = classifier.getPredictedSolution(knn);
                    BasicClassificationOracle oracle = new BasicClassificationOracle();
                    if (!oracle.isCorrectPrediction(predictedSolution, q)) {
                        allCasesToBeRemoved.add(q);
                        changes = true;
                        continue;
                    }
                    iter.add(q);
                }
                catch (ClassCastException cce) {
                    LogFactory.getLog(RENNNoiseReduction.class).error((Object)cce);
                    System.exit(0);
                }
            }
            ProgressController.step(this.getClass());
        }
        ProgressController.finish(this.getClass());
        return allCasesToBeRemoved;
    }
}

