/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.LuceneRetrieval;

import java.util.ArrayList;
import java.util.Collection;
import jcolibri.casebase.IDIndexedLinealCaseBase;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.datatypes.Text;
import jcolibri.extensions.textual.lucene.LuceneIndex;
import jcolibri.extensions.textual.lucene.LuceneSearchResult;
import jcolibri.extensions.textual.lucene.LuceneSearcher;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.util.AttributeUtils;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneRetrieval {
    public static Collection<RetrievalResult> LuceneRetrieve(CBRCaseBase casebase, CBRQuery query, LuceneIndex index, Attribute searchField, boolean normalized, int k) {
        ArrayList<RetrievalResult> res = new ArrayList<RetrievalResult>();
        Object queryString = AttributeUtils.findValue(searchField, query);
        if (!(queryString instanceof Text)) {
            LogFactory.getLog(LuceneRetrieval.class).error((Object)"Search field has not a Text value. Returning empty RetrievalResult list.");
            return res;
        }
        Text qs = (Text)queryString;
        String sf = searchField.getName();
        LuceneSearchResult lsr = LuceneSearcher.search(index, qs.toString(), sf);
        int max = lsr.getResultLength();
        if (k < max) {
            max = k;
        }
        int i = 0;
        while (i < max) {
            res.add(new RetrievalResult(LuceneRetrieval.findCase(casebase, lsr.getDocAt(i).getDocID()), new Double(lsr.getDocScore(i, normalized))));
            ++i;
        }
        return res;
    }

    private static CBRCase findCase(CBRCaseBase casebase, String descriptionID) {
        if (casebase instanceof IDIndexedLinealCaseBase) {
            IDIndexedLinealCaseBase cb = (IDIndexedLinealCaseBase)casebase;
            return cb.getCase(descriptionID);
        }
        for (CBRCase c : casebase.getCases()) {
            try {
                Object descIDObj = c.getDescription().getIdAttribute().getValue(c.getDescription());
                String descID = (String)descIDObj;
                if (!descID.equals(descriptionID)) continue;
                return c;
            }
            catch (Exception e) {
                LogFactory.getLog(LuceneRetrieval.class).error((Object)e);
            }
        }
        return null;
    }
}

