/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.NNretrieval.similarity;

import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.CaseComponent;
import jcolibri.method.retrieve.NNretrieval.NNConfig;
import jcolibri.method.retrieve.NNretrieval.similarity.GlobalSimilarityFunction;
import jcolibri.method.retrieve.NNretrieval.similarity.InContextLocalSimilarityFunction;
import jcolibri.method.retrieve.NNretrieval.similarity.LocalSimilarityFunction;
import jcolibri.util.AttributeUtils;

public abstract class StandardGlobalSimilarityFunction
implements GlobalSimilarityFunction {
    public double compute(CaseComponent componentOfCase, CaseComponent componentOfQuery, CBRCase _case, CBRQuery _query, NNConfig numSimConfig) {
        GlobalSimilarityFunction gsf = null;
        LocalSimilarityFunction lsf = null;
        Attribute[] attributes = AttributeUtils.getAttributes(componentOfCase.getClass());
        double[] values = new double[attributes.length];
        double[] weights = new double[attributes.length];
        int ivalue = 0;
        int i = 0;
        while (i < attributes.length) {
            Attribute at1 = attributes[i];
            Attribute at2 = new Attribute(at1.getName(), componentOfQuery.getClass());
            try {
                gsf = numSimConfig.getGlobalSimilFunction(at1);
                if (gsf != null) {
                    values[ivalue] = gsf.compute((CaseComponent)at1.getValue(componentOfCase), (CaseComponent)at2.getValue(componentOfQuery), _case, _query, numSimConfig);
                    weights[ivalue++] = numSimConfig.getWeight(at1);
                } else {
                    lsf = numSimConfig.getLocalSimilFunction(at1);
                    if (lsf != null) {
                        if (lsf instanceof InContextLocalSimilarityFunction) {
                            InContextLocalSimilarityFunction iclsf = (InContextLocalSimilarityFunction)lsf;
                            iclsf.setContext(componentOfCase, componentOfQuery, _case, _query, at1.getName());
                        }
                        values[ivalue] = lsf.compute(at1.getValue(componentOfCase), at2.getValue(componentOfQuery));
                        weights[ivalue++] = numSimConfig.getWeight(at1);
                    }
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
            ++i;
        }
        return this.computeSimilarity(values, weights, ivalue);
    }

    public abstract double computeSimilarity(double[] var1, double[] var2, int var3);
}

