/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.NNretrieval.similarity.local;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import jcolibri.exception.NoApplicableSimilarityFunctionException;
import jcolibri.method.retrieve.NNretrieval.similarity.LocalSimilarityFunction;
import jcolibri.util.FileIO;
import org.apache.commons.logging.LogFactory;

public class Table
implements LocalSimilarityFunction {
    double[][] matrix = null;
    ArrayList<String> categories = new ArrayList();

    public Table(String filename) {
        try {
            InputStream is = FileIO.openFile(filename);
            BufferedReader br = null;
            br = new BufferedReader(new InputStreamReader(is));
            if (br == null) {
                LogFactory.getLog(this.getClass()).error((Object)("Cannot find file: " + filename));
                return;
            }
            String line = br.readLine();
            StringTokenizer st = new StringTokenizer(line, ",");
            while (st.hasMoreTokens()) {
                this.categories.add(st.nextToken());
            }
            int size = this.categories.size();
            this.matrix = new double[size][size];
            int i = 0;
            while ((line = br.readLine()) != null) {
                st = new StringTokenizer(line, ",");
                int j = 0;
                while (st.hasMoreTokens()) {
                    this.matrix[i][j++] = Double.parseDouble(st.nextToken());
                }
                ++i;
            }
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
    }

    public double compute(Object caseObject, Object queryObject) throws NoApplicableSimilarityFunctionException {
        String queryS;
        String caseS;
        if (caseObject == null || queryObject == null) {
            return 0.0;
        }
        if (!(caseObject instanceof String) && !(caseObject instanceof Enum)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), caseObject.getClass());
        }
        if (!(queryObject instanceof String) && !(queryObject instanceof Enum)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), queryObject.getClass());
        }
        if (caseObject instanceof String) {
            caseS = (String)caseObject;
            queryS = (String)queryObject;
        } else {
            caseS = ((Enum)caseObject).toString();
            queryS = ((Enum)queryObject).toString();
        }
        if (this.matrix == null) {
            LogFactory.getLog(this.getClass()).error((Object)"Similarity table empty");
            return 0.0;
        }
        int pos1 = this.categories.indexOf(caseS);
        if (pos1 == -1) {
            LogFactory.getLog(this.getClass()).error((Object)(String.valueOf(caseS) + " not found in table"));
            return 0.0;
        }
        int pos2 = this.categories.indexOf(queryS);
        if (pos2 == -1) {
            LogFactory.getLog(this.getClass()).error((Object)(String.valueOf(queryS) + " not found in table"));
            return 0.0;
        }
        return this.matrix[pos1][pos2];
    }

    public boolean isApplicable(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null) {
            return o2 instanceof String || o2 instanceof Enum;
        }
        if (o2 == null) {
            return o1 instanceof String || o1 instanceof Enum;
        }
        return o1 instanceof String && o2 instanceof String || o1 instanceof Enum && o2 instanceof Enum;
    }
}

