/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.NNretrieval.similarity.local.textual;

import java.util.HashSet;
import jcolibri.exception.NoApplicableSimilarityFunctionException;
import jcolibri.extensions.textual.IE.representation.IEText;
import jcolibri.method.retrieve.NNretrieval.similarity.LocalSimilarityFunction;
import jcolibri.method.retrieve.NNretrieval.similarity.local.textual.TextualSimUtils;

public class JaccardCoefficient
implements LocalSimilarityFunction {
    public double compute(Object caseObject, Object queryObject) throws NoApplicableSimilarityFunctionException {
        if (caseObject == null || queryObject == null) {
            return 0.0;
        }
        if (!(caseObject instanceof IEText)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), caseObject.getClass());
        }
        if (!(queryObject instanceof IEText)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), queryObject.getClass());
        }
        IEText caseText = (IEText)caseObject;
        IEText queryText = (IEText)queryObject;
        HashSet<TextualSimUtils.WeightedString> caseSet = new HashSet<TextualSimUtils.WeightedString>();
        HashSet<TextualSimUtils.WeightedString> querySet = new HashSet<TextualSimUtils.WeightedString>();
        TextualSimUtils.expandTokensSet(caseText.getAllTokens(), queryText.getAllTokens(), caseSet, querySet);
        HashSet<TextualSimUtils.WeightedString> union = new HashSet<TextualSimUtils.WeightedString>(caseSet);
        union.addAll(querySet);
        double unionSize = TextualSimUtils.getSize(union);
        caseSet.retainAll(querySet);
        double intersectionSize = TextualSimUtils.getSize(caseSet);
        return intersectionSize / unionSize;
    }

    public boolean isApplicable(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null) {
            return o2 instanceof IEText;
        }
        if (o2 == null) {
            return o1 instanceof IEText;
        }
        return o1 instanceof IEText && o2 instanceof IEText;
    }
}

