/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.NNretrieval.similarity.local.textual.compressionbased;

import jcolibri.datatypes.Text;
import jcolibri.exception.NoApplicableSimilarityFunctionException;
import jcolibri.method.retrieve.NNretrieval.similarity.LocalSimilarityFunction;
import jcolibri.method.retrieve.NNretrieval.similarity.local.textual.compressionbased.GZipCompressor;
import jcolibri.method.retrieve.NNretrieval.similarity.local.textual.compressionbased.ICompressor;

public class CompressionBased
implements LocalSimilarityFunction {
    private ICompressor compressor;

    public CompressionBased(ICompressor compressor) {
        this.compressor = compressor;
    }

    public double compare(String x, String y) {
        return 1.0 - this.CDM(x, y);
    }

    public double compute(Object o1, Object o2) throws NoApplicableSimilarityFunctionException {
        if (o1 == null || o2 == null) {
            return 0.0;
        }
        if (!(o1 instanceof String) && !(o1 instanceof Text)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), o1.getClass());
        }
        if (!(o2 instanceof String) && !(o1 instanceof Text)) {
            throw new NoApplicableSimilarityFunctionException(this.getClass(), o2.getClass());
        }
        if (o1 instanceof Text) {
            o1 = ((Text)o1).toString();
        }
        if (o2 instanceof Text) {
            o2 = ((Text)o2).toString();
        }
        String s1 = (String)o1;
        String s2 = (String)o2;
        double res = this.compare(s1, s2);
        return res;
    }

    public boolean isApplicable(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null) {
            return o2 instanceof String || o2 instanceof Text;
        }
        if (o2 == null) {
            return o1 instanceof String || o1 instanceof Text;
        }
        return o1 instanceof String && o2 instanceof String || o1 instanceof Text && o2 instanceof Text;
    }

    private double CDM(String x, String y) {
        return (float)this.compressor.getCompressedSize(String.valueOf(x) + y) * 1.0f / (float)(this.compressor.getCompressedSize(x) + this.compressor.getCompressedSize(y));
    }

    public static void main(String[] args) {
        CompressionBased a = new CompressionBased(new GZipCompressor());
        double res = a.compare("Hello", "Goodbye");
        System.out.println("Hello-Goodbye: " + res);
        res = a.compare("aaaaaaaaaaaaaaaaaaaaaaa", "zzzzzzzzzzzzzzzzzzzzzzzz");
        System.out.println("a-z: " + res);
        res = a.compare("Hello", "Hello");
        System.out.println("Hello-Hello: " + res);
        res = a.compare("abcdefghijkl", "bcdefghijk");
        System.out.println("abcdefghijkl-bcd: " + res);
    }
}

