/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.retrieve.selection.diversity;

import java.util.ArrayList;
import java.util.Collection;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.method.retrieve.NNretrieval.NNConfig;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.SelectCases;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GreedySelection {
    public static Collection<CBRCase> greedySelection(Collection<RetrievalResult> cases, CBRQuery query, NNConfig simConfig, int k) {
        Collection<CBRCase> C = SelectCases.selectAll(cases);
        ArrayList<CBRCase> R = new ArrayList<CBRCase>();
        int i = 0;
        while (i < k) {
            CBRCase best = GreedySelection.getMoreQuality(query, C, R, simConfig);
            R.add(best);
            C.remove(best);
            ++i;
        }
        return R;
    }

    public static CBRCase getMoreQuality(CBRQuery query, Collection<CBRCase> cases, Collection<CBRCase> R, NNConfig simConfig) {
        Collection<RetrievalResult> nn = NNScoringMethod.evaluateSimilarity(cases, query, simConfig);
        CBRCase best = null;
        double maxQuality = -1.7976931348623157E308;
        for (RetrievalResult rr : nn) {
            double quality = rr.getEval() * GreedySelection.relDiversity(rr.get_case(), R, simConfig);
            if (!(quality > maxQuality)) continue;
            maxQuality = quality;
            best = rr.get_case();
        }
        return best;
    }

    public static double relDiversity(CBRCase c, Collection<CBRCase> R, NNConfig simConfig) {
        if (R.isEmpty()) {
            return 1.0;
        }
        double sum = 0.0;
        for (CBRCase _case : R) {
            ArrayList<CBRCase> aux = new ArrayList<CBRCase>();
            aux.add(_case);
            CBRQuery query = new CBRQuery();
            query.setDescription(c.getDescription());
            double sim = NNScoringMethod.evaluateSimilarity(aux, query, simConfig).iterator().next().getEval();
            sum += sim;
        }
        return sum /= (double)R.size();
    }
}

