/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.method.reuse.classification;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jcolibri.extensions.classification.ClassificationSolution;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.reuse.classification.AbstractKNNClassificationMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MajorityVotingMethod
extends AbstractKNNClassificationMethod {
    @Override
    public ClassificationSolution getPredictedSolution(Collection<RetrievalResult> cases) {
        HashMap<Object, Integer> votes = new HashMap<Object, Integer>();
        HashMap<Object, ClassificationSolution> values = new HashMap<Object, ClassificationSolution>();
        for (RetrievalResult result : cases) {
            ClassificationSolution solution = (ClassificationSolution)result.get_case().getSolution();
            Object classif = solution.getClassification();
            if (votes.containsKey(classif)) {
                votes.put(classif, (Integer)votes.get(classif) + 1);
            } else {
                votes.put(classif, 1);
            }
            values.put(classif, solution);
        }
        int highestVoteSoFar = 0;
        Object predictedClass = null;
        for (Map.Entry e : votes.entrySet()) {
            if ((Integer)e.getValue() < highestVoteSoFar) continue;
            highestVoteSoFar = (Integer)e.getValue();
            predictedClass = e.getKey();
        }
        return (ClassificationSolution)values.get(predictedClass);
    }
}

