/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.database;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.HashMap;
import jcolibri.test.database.SqlFile;
import jcolibri.util.FileIO;
import org.apache.commons.logging.LogFactory;
import org.hsqldb.Server;

public class HSQLDBserver {
    static boolean initialized = false;
    private static Server server;

    public static void init() {
        if (initialized) {
            return;
        }
        LogFactory.getLog(HSQLDBserver.class).info((Object)"Creating data base ...");
        server = new Server();
        server.setDatabaseName(0, "travel");
        server.setDatabasePath(0, "mem:travel;sql.enforce_strict_size=true");
        server.setDatabaseName(1, "travelext");
        server.setDatabasePath(1, "mem:travelext;sql.enforce_strict_size=true");
        server.setLogWriter(null);
        server.setErrWriter(null);
        server.setSilent(true);
        server.start();
        initialized = true;
        try {
            Class.forName("org.hsqldb.jdbcDriver");
            PrintStream out = new PrintStream(new ByteArrayOutputStream());
            Connection conn = DriverManager.getConnection("jdbc:hsqldb:hsql://localhost/travel", "sa", "");
            SqlFile file = new SqlFile(new File(FileIO.findFile("jcolibri/test/database/travel.sql").getFile()), false, new HashMap());
            file.execute(conn, out, out, true);
            Connection connExt = DriverManager.getConnection("jdbc:hsqldb:hsql://localhost/travelext", "sa", "");
            SqlFile fileExt = new SqlFile(new File(FileIO.findFile("jcolibri/test/database/travelext.sql").getFile()), false, new HashMap());
            fileExt.execute(connExt, out, out, true);
            LogFactory.getLog(HSQLDBserver.class).info((Object)"Data base generation finished");
        }
        catch (Exception e) {
            LogFactory.getLog(HSQLDBserver.class).error((Object)e);
        }
    }

    public static void shutDown() {
        if (initialized) {
            server.stop();
            initialized = false;
        }
    }

    public static void main(String[] args) {
        HSQLDBserver.init();
        HSQLDBserver.shutDown();
        System.exit(0);
    }
}

