/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.database;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import jcolibri.util.FileIO;
import org.hsqldb.util.SqlToolError;

public class SqlFile {
    private static final int DEFAULT_HISTORY_SIZE = 20;
    private File file;
    private boolean interactive;
    private String primaryPrompt = "sql> ";
    private String chunkPrompt = "raw> ";
    private String contPrompt = "  +> ";
    private Connection curConn = null;
    private boolean htmlMode = false;
    private HashMap userVars = null;
    private String[] statementHistory = null;
    private boolean chunking = false;
    private String csvNullRep = null;
    BooleanBucket possiblyUncommitteds = new BooleanBucket();
    private static final int SEP_LEN = 2;
    private static final String DIVIDER = "----------------------------------------------------------------------------------------------------------------------------------";
    private static final String SPACES = "                                                                                                                                  ";
    private static String revnum = null;
    private static String BANNER;
    private static final String BUFFER_HELP_TEXT = "BUFFER Commands (only \":;\" is available for non-interactive use).\n    :?                Help\n    :;                Execute current buffer as an SQL Statement\n    :a[text]          Enter append mode with a copy of the buffer\n    :l                List current contents of buffer\n    :s/from/to        Substitute \"to\" for first occurrence of \"from\"\n    :s/from/to/[i;g2] Substitute \"to\" for occurrence(s) of \"from\"\n                from:  '$'s represent line breaks\n                to:    If empty, from's will be deleted (e.g. \":s/x//\").\n                       '$'s represent line breaks\n                       You can't use ';' in order to execute the SQL (use\n                       the ';' switch for this purpose, as explained below).\n                /:     Can actually be any character which occurs in\n                       neither \"to\" string nor \"from\" string.\n                SUBSTITUTION MODE SWITCHES:\n                       i:  case Insensitive\n                       ;:  execute immediately after substitution\n                       g:  Global (substitute ALL occurrences of \"from\" string)\n                       2:  Narrows substitution to specified buffer line number\n                           (Use any line number in place of '2').\n";
    private static final String HELP_TEXT = "SPECIAL Commands.\n* commands only available for interactive use.\nIn place of \"3\" below, you can use nothing for the previous command, or\nan integer \"X\" to indicate the Xth previous command.\nFilter substrings are cases-sensitive!  Use \"SCHEMANAME.\" to narrow schema.\n    \\?                   Help\n    \\p [line to print]   Print string to stdout\n    \\w file/path.sql     Append current buffer to file\n    \\i file/path.sql     Include/execute commands from external file\n    \\d{tvsiSanur*} [substr]  List objects of specified type:\n  (Tbls/Views/Seqs/Indexes/SysTbls/Aliases/schemaNames/Users/Roles/table-like)\n    \\d OBJECTNAME [subs] Describe table or view columns\n    \\o [file/path.html]  Tee (or stop teeing) query output to specified file\n    \\H                   Toggle HTML output mode\n    \\! COMMAND ARGS      Execute external program (no support for stdin)\n    \\c [true|false]      Continue upon errors (a.o.t. abort upon error)\n    \\a [true|false]      Auto-commit JDBC DML commands\n    \\b                   save next result to Binary buffer (no display)\n    \\bd file/path.bin    Dump Binary buffer to file\n    \\bl file/path.bin    Load file into Binary buffer\n    \\bp                  Use ? in next SQL statement to upload Bin. buffer\n    \\.                   Enter raw SQL.  End with line containing only \".\"\n    \\s                   * Show previous commands (i.e. SQL command history)\n    \\-[3][;]             * reload a command to buffer (opt. exec. w/ \":;\"))\n    \\x {TABLE|SELECT...} eXport table or query to CSV text file\n    \\m file/path.csv     iMport CSV text file records into a table\n    \\q [abort message]   Quit (or end input like Ctrl-Z or Ctrl-D)\n";
    private static final String PL_HELP_TEXT = "PROCEDURAL LANGUAGE Commands.\n    *?                            Help\n    *                             Expand PL variables from now on.\n                                  (this is also implied by all the following).\n    * VARNAME = Variable value    Set variable value\n    * VARNAME =                   Unset variable\n    * VARNAME ~                   Set variable value to the value of the very\n                                  next SQL statement executed (see details\n                                  at the bottom of this listing).\n    * VARNAME _                   Same as * VARNAME _, except the query is\n                                  done silently (i.e, no rows to screen)\n    * list[value] [VARNAME1...]   List variable(s) (defaults to all)\n    * load VARNAME path.txt       Load variable value from text file\n    * dump VARNAME path.txt       Dump variable value to text file\n    * prepare VARNAME             Use ? in next SQL statement to upload val.\n    * foreach VARNAME ([val1...]) Repeat the following PL block with the\n                                  variable set to each value in turn.\n    * if (logical expr)           Execute following PL block only if expr true\n    * while (logical expr)        Repeat following PL block while expr true\n    * end foreach|if|while        Ends a PL block\n    * break [foreach|if|while|file] Exits a PL block or file early\n    * continue [foreach|while]    Exits a PL block iteration early\n\nUse PL variables (which you have set) like: *{VARNAME}.\nYou may use /VARNAME instead iff /VARNAME is the first word of a SQL command.\nUse PL variables in logical expressions like: *VARNAME.\n\n'* VARNAME ~' or '* VARNAME _' sets the variable value according to the very\nnext SQL statement (~ will echo the value, _ will do it silently):\n    Query:  The value of the first field of the first row returned.\n    other:  Return status of the command (for updates this will be\n            the number of rows updated).\n";
    public boolean recursed = false;
    private String curCommand = null;
    private int curLinenum = -1;
    private int curHist = -1;
    private PrintStream psStd = null;
    private PrintStream psErr = null;
    private PrintWriter pwQuery = null;
    private PrintWriter pwCsv = null;
    StringBuffer stringBuffer = new StringBuffer();
    private boolean continueOnError = false;
    private static final String DEFAULT_CHARSET = "US-ASCII";
    private BufferedReader br = null;
    private String charset = null;
    private boolean doPrepare = false;
    private String prepareVar = null;
    private String csvColDelim = null;
    private String csvRowDelim = null;
    private static final String CSV_SYNTAX_MSG = "Export syntax:  x table_or_view_anme [column_delimiter [record_delimiter]]";
    private static final char[] nonVarChars;
    public boolean plMode = false;
    private String fetchingVar = null;
    private boolean silentFetch = false;
    private boolean fetchBinary = false;
    private static final String DEFAULT_NULL_REP = "[null]";
    private static final String DEFAULT_ROW_DELIM;
    private static final String DEFAULT_COL_DELIM = "|";
    private static final int DEFAULT_ELEMENT = 0;
    private static final int HSQLDB_ELEMENT = 1;
    private static final int ORACLE_ELEMENT = 2;
    private static final int[] listMDSchemaCols;
    private static final int[] listMDIndexCols;
    private static final int[][] listMDTableCols;
    private static final String[] oracleSysSchemas;
    private boolean excludeSysSchemas = false;
    private static final int COL_HEAD = 0;
    private static final int COL_ODD = 1;
    private static final int COL_EVEN = 2;
    private static final String PRE_TR;
    private static final String PRE_TD;
    byte[] binBuffer = null;
    private static final int JDBC3_BOOLEAN = 16;
    private static final int JDBC3_DATALINK = 70;

    static {
        revnum = "$Revision: 1.135 $".substring("$Revision: ".length(), "$Revision: 1.135 $".length() - 2);
        BANNER = "(SqlFile processor v. " + revnum + ")\n" + "Distribution is permitted under the terms of the HSQLDB license.\n" + "(c) 2004-2005 Blaine Simpson and the HSQLDB Development Group.\n\n" + "    \\q    to Quit.\n" + "    \\?    lists Special Commands.\n" + "    :?    lists Buffer/Editing commands.\n" + "    *?    lists PL commands (including alias commands).\n\n" + "SPECIAL Commands begin with '\\' and execute when you hit ENTER.\n" + "BUFFER Commands begin with ':' and execute when you hit ENTER.\n" + "COMMENTS begin with '/*' and end with the very next '*/'.\n" + "PROCEDURAL LANGUAGE commands begin with '*' and end when you hit ENTER.\n" + "All other lines comprise SQL Statements.\n" + "  SQL Statements are terminated by either a blank line (which moves the\n" + "  statement into the buffer without executing) or a line ending with ';'\n" + "  (which executes the statement).\n" + "  SQL Statements may begin with '/PLVARNAME' and/or contain *{PLVARNAME}s.\n";
        nonVarChars = new char[]{' ', '\t', '=', '}', '\n', '\r'};
        DEFAULT_ROW_DELIM = System.getProperty("line.separator");
        listMDSchemaCols = new int[]{1};
        listMDIndexCols = new int[]{2, 6, 3, 9, 4, 10, 11};
        listMDTableCols = new int[][]{{2, 3}, {2, 3}, {2, 3}};
        oracleSysSchemas = new String[]{"SYS", "SYSTEM", "OUTLN", "DBSNMP", "OUTLN", "MDSYS", "ORDSYS", "ORDPLUGINS", "CTXSYS", "DSSYS", "PERFSTAT", "WKPROXY", "WKSYS", "WMSYS", "XDB", "ANONYMOUS", "ODM", "ODM_MTR", "OLAPSYS", "TRACESVR", "REPADMIN"};
        PRE_TR = SqlFile.spaces(4);
        PRE_TD = SqlFile.spaces(8);
    }

    public SqlFile(File inFile, boolean inInteractive, HashMap inVars) throws IOException {
        this.file = inFile;
        this.interactive = inInteractive;
        this.userVars = inVars;
        try {
            this.statementHistory = new String[this.interactive ? Integer.parseInt(System.getProperty("sqltool.historyLength")) : 1];
        }
        catch (Throwable t) {
            this.statementHistory = null;
        }
        if (this.statementHistory == null) {
            this.statementHistory = new String[20];
        }
        if (this.file == null) {
            throw new IOException("Can't read SQL file '" + this.file + "'");
        }
    }

    public SqlFile(boolean inInteractive, HashMap inVars) throws IOException {
        this(null, inInteractive, inVars);
    }

    public void execute(Connection conn, Boolean coeOverride) throws IOException, SqlToolError, SQLException {
        this.execute(conn, System.out, System.err, coeOverride);
    }

    public void execute(Connection conn, boolean coeOverride) throws IOException, SqlToolError, SQLException {
        this.execute(conn, System.out, System.err, new Boolean(coeOverride));
    }

    public synchronized void execute(Connection conn, PrintStream stdIn, PrintStream errIn, Boolean coeOverride) throws IOException, SqlToolError, SQLException {
        String specifiedCharSet;
        this.psStd = stdIn;
        this.psErr = errIn;
        this.curConn = conn;
        this.curLinenum = -1;
        boolean inComment = false;
        boolean gracefulExit = false;
        boolean bl = this.continueOnError = coeOverride == null ? this.interactive : coeOverride;
        if (this.userVars != null && this.userVars.size() > 0) {
            this.plMode = true;
        }
        this.charset = (specifiedCharSet = System.getProperty("sqlfile.charset")) == null ? DEFAULT_CHARSET : specifiedCharSet;
        try {
            try {
                this.br = new BufferedReader(new InputStreamReader(FileIO.openFile(this.file.toString())));
                this.curLinenum = 0;
                if (this.interactive) {
                    this.stdprintln(BANNER);
                }
                while (true) {
                    block54: {
                        String msg;
                        int postCommentIndex;
                        String inputLine;
                        if (this.interactive) {
                            this.psStd.print(this.stringBuffer.length() == 0 ? (this.chunking ? this.chunkPrompt : this.primaryPrompt) : this.contPrompt);
                        }
                        if ((inputLine = this.br.readLine()) == null) {
                            if (!this.interactive) break;
                            this.psStd.println();
                            break;
                        }
                        ++this.curLinenum;
                        if (this.chunking) {
                            if (inputLine.equals(".")) {
                                this.chunking = false;
                                this.setBuf(this.stringBuffer.toString());
                                this.stringBuffer.setLength(0);
                                if (!this.interactive) continue;
                                this.stdprintln("Raw SQL chunk moved into buffer.  Run \":;\" to execute the chunk.");
                                continue;
                            }
                            if (this.stringBuffer.length() > 0) {
                                this.stringBuffer.append('\n');
                            }
                            this.stringBuffer.append(inputLine);
                            continue;
                        }
                        if (inComment) {
                            postCommentIndex = inputLine.indexOf("*/") + 2;
                            if (postCommentIndex <= 1) continue;
                            inputLine = inputLine.substring(postCommentIndex);
                            this.stringBuffer.setLength(0);
                            inComment = false;
                        }
                        String trimmedInput = inputLine.trim();
                        try {
                            if (this.stringBuffer.length() == 0) {
                                if (trimmedInput.startsWith("/*")) {
                                    postCommentIndex = trimmedInput.indexOf("*/", 2) + 2;
                                    if (postCommentIndex > 1) {
                                        inputLine = inputLine.substring(postCommentIndex + inputLine.length() - trimmedInput.length());
                                        trimmedInput = inputLine.trim();
                                    } else {
                                        this.stringBuffer.append("COMMENT");
                                        inComment = true;
                                        continue;
                                    }
                                }
                                if (trimmedInput.length() == 0) continue;
                                if (trimmedInput.charAt(0) == '*' && (trimmedInput.length() < 2 || trimmedInput.charAt(1) != '{')) {
                                    try {
                                        this.processPL(trimmedInput.length() == 1 ? "" : trimmedInput.substring(1).trim());
                                        continue;
                                    }
                                    catch (BadSpecial bs) {
                                        this.errprintln("Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + inputLine + "\"\n" + bs.getMessage());
                                        if (this.continueOnError) continue;
                                        throw new SqlToolError((Exception)bs);
                                    }
                                }
                                if (trimmedInput.charAt(0) == '\\') {
                                    try {
                                        this.processSpecial(trimmedInput.substring(1));
                                        continue;
                                    }
                                    catch (BadSpecial bs) {
                                        this.errprintln("Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + inputLine + "\"\n" + bs.getMessage());
                                        if (this.continueOnError) continue;
                                        throw new SqlToolError((Exception)bs);
                                    }
                                }
                                if (trimmedInput.charAt(0) == ':' && (this.interactive || trimmedInput.charAt(1) == ';')) {
                                    try {
                                        this.processBuffer(trimmedInput.substring(1));
                                        continue;
                                    }
                                    catch (BadSpecial bs) {
                                        this.errprintln("Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + inputLine + "\"\n" + bs.getMessage());
                                        if (this.continueOnError) continue;
                                        throw new SqlToolError((Exception)bs);
                                    }
                                }
                                String ucased = trimmedInput.toUpperCase();
                                if (ucased.startsWith("DECLARE") || ucased.startsWith("BEGIN")) {
                                    this.chunking = true;
                                    this.stringBuffer.append(inputLine);
                                    if (!this.interactive) continue;
                                    this.stdprintln("Enter RAW SQL.  No \\, :, * commands.  End with a line containing only \".\":");
                                    continue;
                                }
                            }
                            if (trimmedInput.length() == 0) {
                                if (!this.interactive || inComment) continue;
                                this.setBuf(this.stringBuffer.toString());
                                this.stringBuffer.setLength(0);
                                this.stdprintln("Current input moved into buffer.");
                                continue;
                            }
                            String deTerminated = SqlFile.deTerminated(inputLine);
                            if (!trimmedInput.equals(";")) {
                                if (this.stringBuffer.length() > 0) {
                                    this.stringBuffer.append('\n');
                                }
                                this.stringBuffer.append(deTerminated == null ? inputLine : deTerminated);
                            }
                            if (deTerminated == null) continue;
                            this.curCommand = this.stringBuffer.toString();
                            String trimmedCommand = this.curCommand.trim();
                            if (trimmedCommand.length() == 0) {
                                throw new SQLException("Empty SQL Statement");
                            }
                            this.setBuf(this.curCommand);
                            this.processSQL();
                        }
                        catch (SQLException se) {
                            this.errprintln("SQL Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + this.curCommand + "\"\n" + se.getMessage());
                            if (!this.continueOnError) {
                                throw se;
                            }
                        }
                        catch (BreakException be) {
                            msg = be.getMessage();
                            if (!this.recursed && msg != null && !msg.equals("file")) {
                                this.errprintln("Unsatisfied break statement" + (msg == null ? "" : " (type " + msg + ')') + '.');
                            } else {
                                gracefulExit = true;
                            }
                            if (this.recursed || !this.continueOnError) {
                                throw be;
                            }
                        }
                        catch (ContinueException ce) {
                            msg = ce.getMessage();
                            if (!this.recursed) {
                                this.errprintln("Unsatisfied continue statement" + (msg == null ? "" : " (type " + msg + ')') + '.');
                            } else {
                                gracefulExit = true;
                            }
                            if (this.recursed || !this.continueOnError) {
                                throw ce;
                            }
                        }
                        catch (QuitNow qn) {
                            throw qn;
                        }
                        catch (SqlToolError ste) {
                            if (this.continueOnError) break block54;
                            throw ste;
                        }
                    }
                    this.stringBuffer.setLength(0);
                }
                if (inComment || this.stringBuffer.length() != 0) {
                    this.errprintln("Unterminated input:  [" + this.stringBuffer + ']');
                    throw new SqlToolError("Unterminated input:  [" + this.stringBuffer + ']');
                }
                gracefulExit = true;
            }
            catch (QuitNow qn) {
                boolean bl2 = gracefulExit = qn.getMessage() == null;
                if (!this.recursed && !gracefulExit) {
                    this.errprintln("Aborting: " + qn.getMessage());
                }
                if (this.recursed || !gracefulExit) {
                    throw qn;
                }
                this.closeQueryOutputStream();
                if (this.fetchingVar != null) {
                    this.errprintln("PL variable setting incomplete:  " + this.fetchingVar);
                    gracefulExit = false;
                }
                if (this.br != null) {
                    this.br.close();
                }
                if (!gracefulExit && this.possiblyUncommitteds.get()) {
                    this.errprintln("Rolling back SQL transaction.");
                    this.curConn.rollback();
                    this.possiblyUncommitteds.set(false);
                }
                return;
            }
        }
        finally {
            this.closeQueryOutputStream();
            if (this.fetchingVar != null) {
                this.errprintln("PL variable setting incomplete:  " + this.fetchingVar);
                gracefulExit = false;
            }
            if (this.br != null) {
                this.br.close();
            }
            if (!gracefulExit && this.possiblyUncommitteds.get()) {
                this.errprintln("Rolling back SQL transaction.");
                this.curConn.rollback();
                this.possiblyUncommitteds.set(false);
            }
        }
    }

    private static String deTerminated(String inString) {
        int index = inString.lastIndexOf(59);
        if (index < 0) {
            return null;
        }
        int i = index + 1;
        while (i < inString.length()) {
            if (!Character.isWhitespace(inString.charAt(i))) {
                return null;
            }
            ++i;
        }
        return inString.substring(0, index);
    }

    private void processBuffer(String inString) throws BadSpecial, SQLException {
        boolean index = false;
        int commandChar = 105;
        String other = null;
        if (inString.length() > 0) {
            commandChar = inString.charAt(0);
            other = inString.substring(1);
            if (other.trim().length() == 0) {
                other = null;
            }
        }
        switch (commandChar) {
            case 59: {
                this.curCommand = this.commandFromHistory(0);
                this.stdprintln("Executing command from buffer:\n" + this.curCommand + '\n');
                this.processSQL();
                return;
            }
            case 65: 
            case 97: {
                this.stringBuffer.append(this.commandFromHistory(0));
                if (other != null) {
                    String deTerminated = SqlFile.deTerminated(other);
                    if (!other.equals(";")) {
                        this.stringBuffer.append(deTerminated == null ? other : deTerminated);
                    }
                    if (deTerminated != null) {
                        this.curCommand = this.stringBuffer.toString();
                        this.setBuf(this.curCommand);
                        this.stdprintln("Executing:\n" + this.curCommand + '\n');
                        this.processSQL();
                        this.stringBuffer.setLength(0);
                        return;
                    }
                }
                this.stdprintln("Appending to:\n" + this.stringBuffer);
                return;
            }
            case 76: 
            case 108: {
                this.stdprintln("Current Buffer:\n" + this.commandFromHistory(0));
                return;
            }
            case 83: 
            case 115: {
                boolean modeIC = false;
                boolean modeGlobal = false;
                boolean modeExecute = false;
                int modeLine = 0;
                try {
                    int i;
                    String fromHist = this.commandFromHistory(0);
                    StringBuffer sb = new StringBuffer(fromHist);
                    if (other == null) {
                        throw new BadSwitch(0);
                    }
                    String delim = other.substring(0, 1);
                    StringTokenizer toker = new StringTokenizer(other, delim, true);
                    if (toker.countTokens() < 4 || !toker.nextToken().equals(delim)) {
                        throw new BadSwitch(1);
                    }
                    String from = toker.nextToken().replace('$', '\n');
                    if (!toker.nextToken().equals(delim)) {
                        throw new BadSwitch(2);
                    }
                    String to = toker.nextToken().replace('$', '\n');
                    if (to.equals(delim)) {
                        to = "";
                    } else if (toker.countTokens() > 0 && !toker.nextToken().equals(delim)) {
                        throw new BadSwitch(3);
                    }
                    if (toker.countTokens() > 0) {
                        String opts = toker.nextToken("");
                        int j = 0;
                        while (j < opts.length()) {
                            switch (opts.charAt(j)) {
                                case 'i': {
                                    modeIC = true;
                                    break;
                                }
                                case ';': {
                                    modeExecute = true;
                                    break;
                                }
                                case 'g': {
                                    modeGlobal = true;
                                    break;
                                }
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    modeLine = Character.digit(opts.charAt(j), 10);
                                    break;
                                }
                                default: {
                                    throw new BadSpecial("Unknown Substitution option: " + opts.charAt(j));
                                }
                            }
                            ++j;
                        }
                    }
                    if (modeIC) {
                        fromHist = fromHist.toUpperCase();
                        from = from.toUpperCase();
                    }
                    int lineStart = 0;
                    int lineStop = -1;
                    if (modeLine > 0) {
                        int j = 1;
                        while (j < modeLine) {
                            if ((lineStart = fromHist.indexOf(10, lineStart) + 1) < 1) {
                                throw new BadSpecial("There are not " + modeLine + " lines in the buffer.");
                            }
                            ++j;
                        }
                        lineStop = fromHist.indexOf(10, lineStart);
                    }
                    if (lineStop < 0) {
                        lineStop = fromHist.length();
                    }
                    if (modeGlobal) {
                        i = lineStop;
                        while ((i = fromHist.lastIndexOf(from, i - 1)) >= lineStart) {
                            sb.replace(i, i + from.length(), to);
                        }
                    } else {
                        i = fromHist.indexOf(from, lineStart);
                        if (i > -1 && i < lineStop) {
                            sb.replace(i, i + from.length(), to);
                        }
                    }
                    this.curCommand = sb.toString();
                    this.setBuf(this.curCommand);
                    this.stdprintln(String.valueOf(modeExecute ? "Executing" : "Current Buffer") + ":\n" + this.curCommand);
                    if (modeExecute) {
                        this.stdprintln();
                    }
                }
                catch (BadSwitch badswitch) {
                    throw new BadSpecial("Substitution syntax:  \":s/from this/to that/i;g2\".  Use '$' for line separations.  [" + badswitch.getMessage() + ']');
                }
                if (modeExecute) {
                    this.processSQL();
                    this.stringBuffer.setLength(0);
                }
                return;
            }
            case 63: {
                this.stdprintln(BUFFER_HELP_TEXT);
                return;
            }
        }
        throw new BadSpecial("Unknown Buffer Command");
    }

    private void processSpecial(String inString) throws BadSpecial, QuitNow, SQLException, SqlToolError {
        boolean index = false;
        String other = null;
        if (inString.length() < 1) {
            throw new BadSpecial("Null special command");
        }
        if (this.plMode) {
            inString = this.dereference(inString, false);
        }
        StringTokenizer toker = new StringTokenizer(inString);
        String arg1 = toker.nextToken();
        if (toker.hasMoreTokens()) {
            other = toker.nextToken("").trim();
        }
        switch (arg1.charAt(0)) {
            case 'q': {
                if (other != null) {
                    throw new QuitNow(other);
                }
                throw new QuitNow();
            }
            case 'H': {
                this.htmlMode = !this.htmlMode;
                this.stdprintln("HTML Mode is now set to: " + this.htmlMode);
                return;
            }
            case 'm': {
                if (arg1.length() != 1 || other == null) {
                    throw new BadSpecial();
                }
                this.csvColDelim = SqlFile.convertEscapes((String)this.userVars.get("*CSV_COL_DELIM"));
                this.csvRowDelim = SqlFile.convertEscapes((String)this.userVars.get("*CSV_ROW_DELIM"));
                this.csvNullRep = (String)this.userVars.get("*CSV_NULL_REP");
                if (this.csvColDelim == null) {
                    this.csvColDelim = DEFAULT_COL_DELIM;
                }
                if (this.csvRowDelim == null) {
                    this.csvRowDelim = DEFAULT_ROW_DELIM;
                }
                if (this.csvNullRep == null) {
                    this.csvNullRep = DEFAULT_NULL_REP;
                }
                try {
                    this.importCsv(other);
                }
                catch (IOException ioe) {
                    System.err.println("Failed to read in CSV file:  " + ioe);
                }
                return;
            }
            case 'x': {
                try {
                    try {
                        if (arg1.length() != 1 || other == null) {
                            throw new BadSpecial();
                        }
                        String tableName = other.indexOf(32) > 0 ? null : other;
                        this.csvColDelim = SqlFile.convertEscapes((String)this.userVars.get("*CSV_COL_DELIM"));
                        this.csvRowDelim = SqlFile.convertEscapes((String)this.userVars.get("*CSV_ROW_DELIM"));
                        this.csvNullRep = (String)this.userVars.get("*CSV_NULL_REP");
                        String csvFilepath = (String)this.userVars.get("*CSV_FILEPATH");
                        if (csvFilepath == null && tableName == null) {
                            throw new BadSpecial("You must set PL variable '*CSV_FILEPATH' in order to use the query variant of \\x");
                        }
                        File csvFile = new File(csvFilepath == null ? String.valueOf(tableName) + ".csv" : csvFilepath);
                        if (this.csvColDelim == null) {
                            this.csvColDelim = DEFAULT_COL_DELIM;
                        }
                        if (this.csvRowDelim == null) {
                            this.csvRowDelim = DEFAULT_ROW_DELIM;
                        }
                        if (this.csvNullRep == null) {
                            this.csvNullRep = DEFAULT_NULL_REP;
                        }
                        this.pwCsv = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), this.charset));
                        this.displayResultSet(null, this.curConn.createStatement().executeQuery(tableName == null ? other : "SELECT * FROM " + tableName), null, null);
                        this.pwCsv.flush();
                        this.stdprintln("Wrote " + csvFile.length() + " characters to file '" + csvFile + "'");
                    }
                    catch (Exception e) {
                        if (e instanceof BadSpecial) {
                            if (e.getMessage() == null) {
                                throw new BadSpecial(CSV_SYNTAX_MSG);
                            }
                            throw (BadSpecial)e;
                        }
                        throw new BadSpecial("Failed to write to file '" + other + "':  " + e);
                    }
                }
                finally {
                    if (this.pwCsv != null) {
                        this.pwCsv.close();
                    }
                    this.pwCsv = null;
                    this.csvColDelim = null;
                    this.csvRowDelim = null;
                }
                return;
            }
            case 'd': {
                if (arg1.length() == 2) {
                    this.listTables(arg1.charAt(1), other);
                    return;
                }
                if (arg1.length() == 1 && other != null) {
                    int space = other.indexOf(32);
                    if (space < 0) {
                        this.describe(other, null);
                    } else {
                        this.describe(other.substring(0, space), other.substring(space + 1).trim());
                    }
                    return;
                }
                throw new BadSpecial("Describe commands must be like '\\dX' or like '\\d OBJECTNAME'.");
            }
            case 'o': {
                if (other == null) {
                    if (this.pwQuery == null) {
                        throw new BadSpecial("There is no query output file to close");
                    }
                    this.closeQueryOutputStream();
                    return;
                }
                if (this.pwQuery != null) {
                    this.stdprintln("Closing current query output file and opening new one");
                    this.closeQueryOutputStream();
                }
                try {
                    this.pwQuery = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(other, true), this.charset));
                    this.pwQuery.println(String.valueOf(this.htmlMode ? "<HTML>\n<!--" : "#") + " " + new Date() + ".  Query output from " + this.getClass().getName() + (this.htmlMode ? ". -->\n\n<BODY>" : ".\n"));
                    this.pwQuery.flush();
                }
                catch (Exception e) {
                    throw new BadSpecial("Failed to write to file '" + other + "':  " + e);
                }
                return;
            }
            case 'w': {
                if (other == null) {
                    throw new BadSpecial("You must supply a destination file name");
                }
                if (this.commandFromHistory(0).length() == 0) {
                    throw new BadSpecial("Empty command in buffer");
                }
                try {
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(other, true), this.charset));
                    pw.println(String.valueOf(this.commandFromHistory(0)) + ';');
                    pw.flush();
                    pw.close();
                }
                catch (Exception e) {
                    throw new BadSpecial("Failed to append to file '" + other + "':  " + e);
                }
                return;
            }
            case 'i': {
                if (other == null) {
                    throw new BadSpecial("You must supply an SQL file name");
                }
                try {
                    SqlFile sf = new SqlFile(new File(other), false, this.userVars);
                    sf.recursed = true;
                    sf.possiblyUncommitteds = this.possiblyUncommitteds;
                    sf.plMode = this.plMode;
                    sf.execute(this.curConn, this.continueOnError);
                }
                catch (ContinueException ce) {
                    throw ce;
                }
                catch (BreakException be) {
                    String beMessage = be.getMessage();
                    if (beMessage != null && !beMessage.equals("file")) {
                        throw be;
                    }
                }
                catch (QuitNow qe) {
                    throw qe;
                }
                catch (Exception e) {
                    throw new BadSpecial("Failed to execute SQL from file '" + other + "':  " + e.getMessage());
                }
                return;
            }
            case 'p': {
                if (other == null) {
                    this.stdprintln(true);
                } else {
                    this.stdprintln(other, true);
                }
                return;
            }
            case 'a': {
                if (other != null) {
                    this.curConn.setAutoCommit(Boolean.valueOf(other));
                }
                this.stdprintln("Auto-commit is set to: " + this.curConn.getAutoCommit());
                return;
            }
            case 'b': {
                if (arg1.length() == 1) {
                    this.fetchBinary = true;
                    return;
                }
                if (arg1.charAt(1) == 'p') {
                    this.doPrepare = true;
                    return;
                }
                if (arg1.charAt(1) != 'd' && arg1.charAt(1) != 'l' || other == null) {
                    throw new BadSpecial("Malformatted binary command");
                }
                File file = new File(other);
                try {
                    if (arg1.charAt(1) == 'd') {
                        this.dump(file);
                    } else {
                        this.load(file);
                    }
                }
                catch (Exception e) {
                    throw new BadSpecial("Failed to load/dump binary  data to file '" + other + "'");
                }
                return;
            }
            case '*': 
            case 'c': {
                if (other != null) {
                    this.continueOnError = Boolean.valueOf(other);
                }
                this.stdprintln("Continue-on-error is set to: " + this.continueOnError);
                return;
            }
            case 's': {
                this.showHistory();
                return;
            }
            case '-': {
                String numStr;
                boolean executeMode;
                int commandsAgo = 0;
                boolean bl = executeMode = arg1.charAt(arg1.length() - 1) == ';';
                if (executeMode) {
                    arg1 = arg1.substring(0, arg1.length() - 1);
                }
                String string = numStr = arg1.length() == 1 ? null : arg1.substring(1, arg1.length());
                if (numStr == null) {
                    commandsAgo = 0;
                } else {
                    try {
                        commandsAgo = Integer.parseInt(numStr);
                    }
                    catch (NumberFormatException nfe) {
                        throw new BadSpecial("Malformatted command number");
                    }
                }
                this.setBuf(this.commandFromHistory(commandsAgo));
                if (executeMode) {
                    this.processBuffer(";");
                } else {
                    this.stdprintln("RESTORED following command to buffer.  Enter \":?\" to see buffer commands:\n" + this.commandFromHistory(0));
                }
                return;
            }
            case '?': {
                this.stdprintln(HELP_TEXT);
                return;
            }
            case '!': {
                byte[] ba = new byte[1024];
                String extCommand = String.valueOf(arg1.length() == 1 ? "" : arg1.substring(1)) + (arg1.length() > 1 && other != null ? " " : "") + (other == null ? "" : other);
                try {
                    int i;
                    Process proc = Runtime.getRuntime().exec(extCommand);
                    proc.getOutputStream().close();
                    InputStream stream = proc.getInputStream();
                    while ((i = stream.read(ba)) > 0) {
                        this.stdprint(new String(ba, 0, i));
                    }
                    stream.close();
                    stream = proc.getErrorStream();
                    while ((i = stream.read(ba)) > 0) {
                        this.errprint(new String(ba, 0, i));
                    }
                    stream.close();
                    if (proc.waitFor() != 0) {
                        throw new BadSpecial("External command failed: '" + extCommand + "'");
                    }
                }
                catch (Exception e) {
                    throw new BadSpecial("Failed to execute command '" + extCommand + "':  " + e);
                }
                return;
            }
            case '.': {
                this.chunking = true;
                if (this.interactive) {
                    this.stdprintln("Enter RAW SQL.  No \\, :, * commands.  End with a line containing only \".\":");
                }
                return;
            }
        }
        throw new BadSpecial("Unknown Special Command");
    }

    static int pastName(String inString, int startIndex) {
        String workString = inString.substring(startIndex);
        int e = inString.length();
        int i = 0;
        while (i < nonVarChars.length) {
            int nonVarIndex = workString.indexOf(nonVarChars[i]);
            if (nonVarIndex > -1 && nonVarIndex < e) {
                e = nonVarIndex;
            }
            ++i;
        }
        return startIndex + e;
    }

    private String dereference(String inString, boolean permitAlias) throws SQLException {
        String s;
        int b;
        String varName;
        int e;
        StringBuffer expandBuffer = new StringBuffer(inString);
        if (permitAlias && inString.trim().charAt(0) == '/') {
            int slashIndex = inString.indexOf(47);
            e = SqlFile.pastName(inString.substring(slashIndex + 1), 0);
            if (e < 1) {
                throw new SQLException("Malformed PL alias use");
            }
            varName = inString.substring(slashIndex + 1, slashIndex + 1 + e);
            String varValue = (String)this.userVars.get(varName);
            if (varValue == null) {
                throw new SQLException("Undefined PL variable:  " + varName);
            }
            expandBuffer.replace(slashIndex, slashIndex + 1 + e, (String)this.userVars.get(varName));
        }
        while ((b = (s = expandBuffer.toString()).indexOf("*{")) >= 0) {
            e = s.indexOf(125, b + 2);
            if (e == b + 2) {
                throw new SQLException("Empty PL variable name");
            }
            if (e < 0) {
                throw new SQLException("Unterminated PL variable name");
            }
            varName = s.substring(b + 2, e);
            if (!this.userVars.containsKey(varName)) {
                throw new SQLException("Use of undefined PL variable: " + varName);
            }
            expandBuffer.replace(b, e + 1, (String)this.userVars.get(varName));
        }
        return expandBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private void processPL(String inString) throws BadSpecial, SqlToolError, SQLException {
        block77: {
            if (inString.length() < 1) {
                this.plMode = true;
                this.stdprintln("PL variable expansion mode is now on");
                return;
            }
            if (inString.charAt(0) == '?') {
                this.stdprintln("PROCEDURAL LANGUAGE Commands.\n    *?                            Help\n    *                             Expand PL variables from now on.\n                                  (this is also implied by all the following).\n    * VARNAME = Variable value    Set variable value\n    * VARNAME =                   Unset variable\n    * VARNAME ~                   Set variable value to the value of the very\n                                  next SQL statement executed (see details\n                                  at the bottom of this listing).\n    * VARNAME _                   Same as * VARNAME _, except the query is\n                                  done silently (i.e, no rows to screen)\n    * list[value] [VARNAME1...]   List variable(s) (defaults to all)\n    * load VARNAME path.txt       Load variable value from text file\n    * dump VARNAME path.txt       Dump variable value to text file\n    * prepare VARNAME             Use ? in next SQL statement to upload val.\n    * foreach VARNAME ([val1...]) Repeat the following PL block with the\n                                  variable set to each value in turn.\n    * if (logical expr)           Execute following PL block only if expr true\n    * while (logical expr)        Repeat following PL block while expr true\n    * end foreach|if|while        Ends a PL block\n    * break [foreach|if|while|file] Exits a PL block or file early\n    * continue [foreach|while]    Exits a PL block iteration early\n\nUse PL variables (which you have set) like: *{VARNAME}.\nYou may use /VARNAME instead iff /VARNAME is the first word of a SQL command.\nUse PL variables in logical expressions like: *VARNAME.\n\n'* VARNAME ~' or '* VARNAME _' sets the variable value according to the very\nnext SQL statement (~ will echo the value, _ will do it silently):\n    Query:  The value of the first field of the first row returned.\n    other:  Return status of the command (for updates this will be\n            the number of rows updated).\n");
                return;
            }
            if (this.plMode) {
                inString = this.dereference(inString, false);
            }
            toker = new StringTokenizer(inString);
            arg1 = toker.nextToken();
            tokenArray = null;
            this.plMode = true;
            if (this.userVars == null) {
                this.userVars = new HashMap<K, V>();
            }
            if (arg1.equals("end")) {
                throw new BadSpecial("PL end statements may only occur inside of a PL block");
            }
            if (arg1.equals("continue")) {
                if (toker.hasMoreTokens()) {
                    s = toker.nextToken("").trim();
                    if (s.equals("foreach") || s.equals("while")) {
                        throw new ContinueException(s);
                    }
                    throw new BadSpecial("Bad continue statement.You may use no argument or one of 'foreach', 'while'");
                }
                throw new ContinueException();
            }
            if (arg1.equals("break")) {
                if (toker.hasMoreTokens()) {
                    s = toker.nextToken("").trim();
                    if (s.equals("foreach") || s.equals("if") || s.equals("while") || s.equals("file")) {
                        throw new BreakException(s);
                    }
                    throw new BadSpecial("Bad break statement.You may use no argument or one of 'foreach', 'if', 'while', 'file'");
                }
                throw new BreakException();
            }
            if (arg1.equals("list") || arg1.equals("listvalue")) {
                doValues = arg1.equals("listvalue");
                if (toker.countTokens() == 0) {
                    this.stdprint(SqlFile.formatNicely(this.userVars, doValues));
                } else {
                    tokenArray = SqlFile.getTokenArray(toker.nextToken(""));
                    if (doValues) {
                        this.stdprintln("The outermost parentheses are not part of the values.");
                    } else {
                        this.stdprintln("Showing variable names and length of values (use 'listvalue' to see values).");
                    }
                    i = 0;
                    while (i < tokenArray.length) {
                        s = (String)this.userVars.get(tokenArray[i]);
                        this.stdprintln("    " + tokenArray[i] + ": " + (doValues != false ? "(" + s + ')' : Integer.toString(s.length())));
                        ++i;
                    }
                }
                return;
            }
            if (arg1.equals("dump") || arg1.equals("load")) {
                if (toker.countTokens() != 2) {
                    throw new BadSpecial("Malformatted PL dump/load command");
                }
                varName = toker.nextToken();
                file = new File(toker.nextToken());
                try {
                    if (arg1.equals("dump")) {
                        this.dump(varName, file);
                    } else {
                        this.load(varName, file);
                    }
                }
                catch (Exception e) {
                    throw new BadSpecial("Failed to dump/load variable '" + varName + "' to file '" + file + "'");
                }
                return;
            }
            if (arg1.equals("prepare")) {
                if (toker.countTokens() != 1) {
                    throw new BadSpecial("Malformatted prepare command");
                }
                s = toker.nextToken();
                if (this.userVars.get(s) == null) {
                    throw new SQLException("Use of unset PL variable: " + s);
                }
                this.prepareVar = s;
                this.doPrepare = true;
                return;
            }
            if (arg1.equals("foreach")) {
                if (toker.countTokens() < 2) {
                    throw new BadSpecial("Malformatted PL foreach command (1)");
                }
                varName = toker.nextToken();
                parenExpr = toker.nextToken("").trim();
                if (parenExpr.length() < 2 || parenExpr.charAt(0) != '(' || parenExpr.charAt(parenExpr.length() - 1) != ')') {
                    throw new BadSpecial("Malformatted PL foreach command (2)");
                }
                values = SqlFile.getTokenArray(parenExpr.substring(1, parenExpr.length() - 1));
                tmpFile = null;
                try {
                    tmpFile = this.plBlockFile("foreach");
                }
                catch (IOException ioe) {
                    throw new BadSpecial("Failed to write given PL block temp file: " + ioe);
                }
                origval = (String)this.userVars.get(varName);
                try {
                    i = 0;
                    while (i < values.length) {
                        block76: {
                            try {
                                varVal = values[i];
                                this.userVars.put(varName, varVal);
                                sf = new SqlFile(tmpFile, false, this.userVars);
                                sf.plMode = true;
                                sf.recursed = true;
                                sf.possiblyUncommitteds = this.possiblyUncommitteds;
                                sf.execute(this.curConn, this.continueOnError);
                            }
                            catch (ContinueException ce) {
                                ceMessage = ce.getMessage();
                                if (ceMessage == null || ceMessage.equals("foreach")) break block76;
                                throw ce;
                            }
                        }
                        ++i;
                    }
                }
                catch (BreakException be) {
                    beMessage = be.getMessage();
                    if (beMessage != null && !beMessage.equals("foreach")) {
                        throw be;
                    }
                }
                catch (QuitNow qe) {
                    throw qe;
                }
                catch (Exception e) {
                    throw new BadSpecial("Failed to execute SQL from PL block.  " + e.getMessage());
                }
                if (origval == null) {
                    this.userVars.remove(varName);
                } else {
                    this.userVars.put(varName, origval);
                }
                if (tmpFile != null && !tmpFile.delete()) {
                    throw new BadSpecial("Error occurred while trying to remove temp file '" + tmpFile + "'");
                }
                return;
            }
            if (arg1.equals("if")) {
                if (toker.countTokens() < 1) {
                    throw new BadSpecial("Malformatted PL if command (1)");
                }
                parenExpr = toker.nextToken("").trim();
                if (parenExpr.length() < 2 || parenExpr.charAt(0) != '(' || parenExpr.charAt(parenExpr.length() - 1) != ')') {
                    throw new BadSpecial("Malformatted PL if command (2)");
                }
                values = SqlFile.getTokenArray(parenExpr.substring(1, parenExpr.length() - 1));
                tmpFile = null;
                try {
                    tmpFile = this.plBlockFile("if");
                }
                catch (IOException ioe) {
                    throw new BadSpecial("Failed to write given PL block temp file: " + ioe);
                }
                try {
                    if (this.eval(values)) {
                        sf = new SqlFile(tmpFile, false, this.userVars);
                        sf.plMode = true;
                        sf.recursed = true;
                        sf.possiblyUncommitteds = this.possiblyUncommitteds;
                        sf.execute(this.curConn, this.continueOnError);
                    }
                }
                catch (BreakException be) {
                    beMessage = be.getMessage();
                    if (beMessage == null || !beMessage.equals("if")) {
                        throw be;
                    }
                }
                catch (ContinueException ce) {
                    throw ce;
                }
                catch (QuitNow qe) {
                    throw qe;
                }
                catch (BadSpecial bs) {
                    throw new BadSpecial("Malformatted PL if command (3): " + bs);
                }
                catch (Exception e) {
                    throw new BadSpecial("Failed to execute SQL from PL block.  " + e.getMessage());
                }
                if (tmpFile != null && !tmpFile.delete()) {
                    throw new BadSpecial("Error occurred while trying to remove temp file '" + tmpFile + "'");
                }
                return;
            }
            if (!arg1.equals("while")) break block77;
            if (toker.countTokens() < 1) {
                throw new BadSpecial("Malformatted PL while command (1)");
            }
            parenExpr = toker.nextToken("").trim();
            if (parenExpr.length() < 2 || parenExpr.charAt(0) != '(' || parenExpr.charAt(parenExpr.length() - 1) != ')') {
                throw new BadSpecial("Malformatted PL while command (2)");
            }
            values = SqlFile.getTokenArray(parenExpr.substring(1, parenExpr.length() - 1));
            tmpFile = null;
            try {
                tmpFile = this.plBlockFile("while");
                if (true) ** GOTO lbl188
            }
            catch (IOException ioe) {
                throw new BadSpecial("Failed to write given PL block temp file: " + ioe);
            }
            {
                do {
                    try {
                        sf = new SqlFile(tmpFile, false, this.userVars);
                        sf.recursed = true;
                        sf.possiblyUncommitteds = this.possiblyUncommitteds;
                        sf.plMode = true;
                        sf.execute(this.curConn, this.continueOnError);
                    }
                    catch (ContinueException ce) {
                        ceMessage = ce.getMessage();
                        if (ceMessage == null || ceMessage.equals("while")) continue;
                        throw ce;
                    }
lbl188:
                    // 3 sources

                } while (this.eval(values));
            }
            if (tmpFile != null && !tmpFile.delete()) {
                throw new BadSpecial("Error occurred while trying to remove temp file '" + tmpFile + "'");
            }
            return;
        }
        toker = null;
        index = SqlFile.pastName(inString, 0);
        inLength = inString.length();
        varName = inString.substring(0, index);
        while (index + 1 < inLength && (inString.charAt(index) == ' ' || inString.charAt(index) == '\t')) {
            ++index;
        }
        if (index + 1 > inLength) {
            throw new BadSpecial("Unterminated PL variable definition");
        }
        operator = inString.charAt(index);
        remainder = inString.substring(index + 1);
        switch (inString.charAt(index)) {
            case '_': {
                this.silentFetch = true;
            }
            case '~': {
                if (remainder.length() > 0) {
                    throw new BadSpecial("PL ~/_ set commands take no other args");
                }
                this.userVars.remove(varName);
                this.fetchingVar = varName;
                return;
            }
            case '=': {
                if (this.fetchingVar != null && this.fetchingVar.equals(varName)) {
                    this.fetchingVar = null;
                }
                if (remainder.length() > 0) {
                    this.userVars.put(varName, inString.substring(index + 1).trim());
                } else {
                    this.userVars.remove(varName);
                }
                return;
            }
        }
        throw new BadSpecial("Unknown PL command (3)");
    }

    private File plBlockFile(String type) throws IOException, SqlToolError {
        int nestlevel = 1;
        if (type == null || !type.equals("foreach") && !type.equals("if") && !type.equals("while")) {
            throw new RuntimeException("Assertion failed.  Unsupported PL block type:  " + type);
        }
        File tmpFile = File.createTempFile("sqltool-", ".sql");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), this.charset));
        pw.println("/* " + new Date() + ". " + this.getClass().getName() + " PL block. */\n");
        while (true) {
            String s;
            if ((s = this.br.readLine()) == null) {
                this.errprintln("Unterminated '" + type + "' PL block");
                throw new SqlToolError("Unterminated '" + type + "' PL block");
            }
            ++this.curLinenum;
            if (s.trim().length() > 1 && s.trim().charAt(0) == '*') {
                StringTokenizer toker = new StringTokenizer(s.trim().substring(1));
                String curPlCommand = toker.nextToken();
                if (curPlCommand.equals(type)) {
                    ++nestlevel;
                } else if (curPlCommand.equals("end")) {
                    if (toker.countTokens() < 1) {
                        this.errprintln("PL end statement requires arg of 'foreach' or 'if' or 'while' (1)");
                        throw new SqlToolError("PL end statement requires arg  of 'foreach' or 'if' or 'while' (1)");
                    }
                    String inType = toker.nextToken();
                    if (inType.equals(type) && --nestlevel < 1) break;
                    if (!(inType.equals("foreach") || inType.equals("if") || inType.equals("while"))) {
                        this.errprintln("PL end statement requires arg of 'foreach' or 'if' or 'while' (2)");
                        throw new SqlToolError("PL end statement requires arg of 'foreach' or 'if' or 'while' (2)");
                    }
                }
            }
            pw.println(s);
        }
        pw.flush();
        pw.close();
        return tmpFile;
    }

    private void stdprintln() {
        this.stdprintln(false);
    }

    private void stdprint(String s) {
        this.stdprint(s, false);
    }

    private void stdprintln(String s) {
        this.stdprintln(s, false);
    }

    private void stdprintln(boolean queryOutput) {
        if (this.htmlMode) {
            this.psStd.println("<BR>");
        } else {
            this.psStd.println();
        }
        if (queryOutput && this.pwQuery != null) {
            if (this.htmlMode) {
                this.pwQuery.println("<BR>");
            } else {
                this.pwQuery.println();
            }
            this.pwQuery.flush();
        }
    }

    private void errprint(String s) {
        this.psErr.print(this.htmlMode ? "<DIV style='color:white; background: red; font-weight: bold'>" + s + "</DIV>" : s);
    }

    private void errprintln(String s) {
        this.psErr.println(this.htmlMode ? "<DIV style='color:white; background: red; font-weight: bold'>" + s + "</DIV>" : s);
    }

    private void stdprint(String s, boolean queryOutput) {
        this.psStd.print(this.htmlMode ? "<P>" + s + "</P>" : s);
        if (queryOutput && this.pwQuery != null) {
            this.pwQuery.print(this.htmlMode ? "<P>" + s + "</P>" : s);
            this.pwQuery.flush();
        }
    }

    private void stdprintln(String s, boolean queryOutput) {
        this.psStd.println(this.htmlMode ? "<P>" + s + "</P>" : s);
        if (queryOutput && this.pwQuery != null) {
            this.pwQuery.println(this.htmlMode ? "<P>" + s + "</P>" : s);
            this.pwQuery.flush();
        }
    }

    /*
     * Exception decompiling
     */
    private void listTables(char c, String inFilter) throws BadSpecial {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[CASE]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processSQL() throws SQLException {
        String sql = this.plMode ? this.dereference(this.curCommand, true) : this.curCommand;
        Statement statement = null;
        if (this.doPrepare) {
            if (sql.indexOf(63) < 1) {
                throw new SQLException("Prepared statements must contain one '?'");
            }
            this.doPrepare = false;
            PreparedStatement ps = this.curConn.prepareStatement(sql);
            if (this.prepareVar == null) {
                if (this.binBuffer == null) {
                    throw new SQLException("Binary SqlFile buffer is empty");
                }
                ps.setBytes(1, this.binBuffer);
            } else {
                String val = (String)this.userVars.get(this.prepareVar);
                if (val == null) {
                    throw new SQLException("PL Variable '" + this.prepareVar + "' is empty");
                }
                this.prepareVar = null;
                ps.setString(1, val);
            }
            ps.executeUpdate();
            statement = ps;
        } else {
            statement = this.curConn.createStatement();
            statement.execute(sql);
        }
        this.possiblyUncommitteds.set(true);
        try {
            this.displayResultSet(statement, statement.getResultSet(), null, null);
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Unable to fully structure code
     */
    private void displayResultSet(Statement statement, ResultSet r, int[] incCols, String filter) throws SQLException {
        updateCount = statement == null ? -1 : statement.getUpdateCount();
        silent = this.silentFetch;
        binary = this.fetchBinary;
        this.silentFetch = false;
        this.fetchBinary = false;
        if (this.excludeSysSchemas) {
            this.stdprintln("*** WARNING:\n*** Omitting tables from system-supplied schemas\n*** (because Oracle(TM) doesn't differentiate them to JDBC).");
        }
        switch (updateCount) {
            case -1: {
                if (r == null) {
                    this.stdprintln("No result", true);
                    break;
                }
                m = r.getMetaData();
                cols = m.getColumnCount();
                incCount = incCols == null ? cols : incCols.length;
                rows = new ArrayList<String[]>();
                headerArray = null;
                maxWidth = new int[incCount];
                if (!this.htmlMode) {
                    i = 0;
                    while (i < maxWidth.length) {
                        maxWidth[i] = 0;
                        ++i;
                    }
                }
                rightJust = new boolean[incCount];
                dataType = new int[incCount];
                autonulls = new boolean[incCount];
                insi = -1;
                headerArray = new String[incCount];
                i = 1;
                while (i <= cols) {
                    if (incCols == null) ** GOTO lbl41
                    skip = true;
                    j = 0;
                    while (j < incCols.length) {
                        if (i == incCols[j]) {
                            skip = false;
                        }
                        ++j;
                    }
                    if (skip) ** GOTO lbl53
lbl41:
                    // 2 sources

                    headerArray[++insi] = m.getColumnLabel(i);
                    dataType[insi] = m.getColumnType(i);
                    rightJust[insi] = false;
                    autonulls[insi] = true;
                    switch (dataType[insi]) {
                        case -7: 
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            rightJust[insi] = true;
                            break;
                        }
                        case -3: 
                        case 12: {
                            autonulls[insi] = false;
                        }
                    }
                    if (!this.htmlMode && headerArray[insi].length() > maxWidth[insi]) {
                        maxWidth[insi] = headerArray[insi].length();
                    }
lbl53:
                    // 4 sources

                    ++i;
                }
                while (r.next()) {
                    fieldArray = new String[incCount];
                    insi = -1;
                    filteredOut = filter != null;
                    i = 1;
                    while (i <= cols) {
                        if (incCols == null) ** GOTO lbl70
                        skip = true;
                        j = 0;
                        while (j < incCols.length) {
                            if (i == incCols[j]) {
                                skip = false;
                            }
                            ++j;
                        }
                        if (skip) ** GOTO lbl114
lbl70:
                        // 2 sources

                        if (!SqlFile.canDisplayType(dataType[++insi])) {
                            binary = true;
                        }
                        val = null;
                        if (!binary) {
                            if (dataType[insi] == 93) {
                                ts = r.getTimestamp(i);
                                val = ts == null ? null : ts.toString();
                            } else {
                                val = r.getString(i);
                                if (val == null) {
                                    try {
                                        val = this.streamToString(r.getAsciiStream(i));
                                    }
                                    catch (Exception j) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                        if (binary || val == null && !r.wasNull()) {
                            if (this.pwCsv != null) {
                                throw new SQLException("Table has a binary column.  CSV files are text, not binary, files");
                            }
                            try {
                                this.binBuffer = this.streamToBytes(r.getBinaryStream(i));
                            }
                            catch (IOException ioe) {
                                throw new SQLException("Failed to read value using stream");
                            }
                            this.stdprintln("Read " + this.binBuffer.length + " bytes from field '" + headerArray[insi] + "' (type " + SqlFile.sqlTypeToString(dataType[insi]) + ") into binary buffer");
                            return;
                        }
                        if (this.excludeSysSchemas && i == 2) {
                            z = 0;
                            while (z < SqlFile.oracleSysSchemas.length) {
                                if (val.equals(SqlFile.oracleSysSchemas[z])) {
                                    filteredOut = true;
                                    break;
                                }
                                ++z;
                            }
                        }
                        if (this.fetchingVar != null) {
                            this.userVars.put(this.fetchingVar, val);
                            this.fetchingVar = null;
                        }
                        if (silent) {
                            return;
                        }
                        if (filter != null && (val == null || val.indexOf(filter) > -1)) {
                            filteredOut = false;
                        }
                        fieldArray[insi] = val == null && this.pwCsv == null ? (dataType[insi] == 12 ? (this.htmlMode != false ? "<I>null</I>" : "[null]") : "") : val;
                        if (!this.htmlMode && this.pwCsv == null && fieldArray[insi].length() > maxWidth[insi]) {
                            maxWidth[insi] = fieldArray[insi].length();
                        }
lbl114:
                        // 4 sources

                        ++i;
                    }
                    if (filteredOut) continue;
                    rows.add(fieldArray);
                }
                if (this.pwCsv == null) {
                    this.condlPrintln("<TABLE border='1'>", true);
                    if (incCount > 1) {
                        this.condlPrint(String.valueOf(SqlFile.htmlRow(0)) + '\n' + SqlFile.PRE_TD, true);
                        i = 0;
                        while (i < headerArray.length) {
                            this.condlPrint("<TD>" + headerArray[i] + "</TD>", true);
                            this.condlPrint(String.valueOf(i > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(headerArray[i], maxWidth[i], rightJust[i], i < headerArray.length - 1 || rightJust[i] != false), false);
                            ++i;
                        }
                        this.condlPrintln("\n" + SqlFile.PRE_TR + "</TR>", true);
                        this.condlPrintln("", false);
                        if (!this.htmlMode) {
                            i = 0;
                            while (i < headerArray.length) {
                                this.condlPrint(String.valueOf(i > 0 ? SqlFile.spaces(2) : "") + SqlFile.divider(maxWidth[i]), false);
                                ++i;
                            }
                            this.condlPrintln("", false);
                        }
                    }
                    i = 0;
                    while (i < rows.size()) {
                        this.condlPrint(String.valueOf(SqlFile.htmlRow(i % 2 == 0 ? 2 : 1)) + '\n' + SqlFile.PRE_TD, true);
                        fieldArray = (String[])rows.get(i);
                        j = 0;
                        while (j < fieldArray.length) {
                            this.condlPrint("<TD>" + fieldArray[j] + "</TD>", true);
                            this.condlPrint(String.valueOf(j > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(fieldArray[j], maxWidth[j], rightJust[j], j < fieldArray.length - 1 || rightJust[j] != false), false);
                            ++j;
                        }
                        this.condlPrintln("\n" + SqlFile.PRE_TR + "</TR>", true);
                        this.condlPrintln("", false);
                        ++i;
                    }
                    this.condlPrintln("</TABLE>", true);
                    if (rows.size() != 1) {
                        this.stdprintln("\n" + rows.size() + " rows", true);
                    }
                    this.condlPrintln("<HR>", true);
                    break;
                }
                if (incCount > 0) {
                    i = 0;
                    while (i < headerArray.length) {
                        this.csvSafe(headerArray[i]);
                        this.pwCsv.print(headerArray[i]);
                        if (i < headerArray.length - 1) {
                            this.pwCsv.print(this.csvColDelim);
                        }
                        ++i;
                    }
                    this.pwCsv.print(this.csvRowDelim);
                }
                i = 0;
                while (i < rows.size()) {
                    fieldArray = (String[])rows.get(i);
                    j = 0;
                    while (j < fieldArray.length) {
                        this.csvSafe(fieldArray[j]);
                        this.pwCsv.print(fieldArray[j] == null ? (autonulls[j] ? "" : this.csvNullRep) : fieldArray[j]);
                        if (j < fieldArray.length - 1) {
                            this.pwCsv.print(this.csvColDelim);
                        }
                        ++j;
                    }
                    this.pwCsv.print(this.csvRowDelim);
                    ++i;
                }
                this.stdprintln(String.valueOf(Integer.toString(rows.size())) + " rows read from DB");
                break;
            }
            default: {
                if (this.fetchingVar != null) {
                    this.userVars.put(this.fetchingVar, Integer.toString(updateCount));
                    this.fetchingVar = null;
                }
                if (updateCount == 0) break;
                this.stdprintln(String.valueOf(Integer.toString(updateCount)) + " row" + (updateCount == 1 ? "" : "s") + " updated");
            }
        }
    }

    private static String htmlRow(int colType) {
        switch (colType) {
            case 0: {
                return String.valueOf(PRE_TR) + "<TR style='font-weight: bold;'>";
            }
            case 1: {
                return String.valueOf(PRE_TR) + "<TR style='background: #94d6ef; font: normal " + "normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
            case 2: {
                return String.valueOf(PRE_TR) + "<TR style='background: silver; font: normal " + "normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
        }
        return null;
    }

    private static String divider(int len) {
        return len > DIVIDER.length() ? DIVIDER : DIVIDER.substring(0, len);
    }

    private static String spaces(int len) {
        return len > SPACES.length() ? SPACES : SPACES.substring(0, len);
    }

    private static String pad(String inString, int fulllen, boolean rightJustify, boolean doPad) {
        if (!doPad) {
            return inString;
        }
        int len = fulllen - inString.length();
        if (len < 1) {
            return inString;
        }
        String pad = SqlFile.spaces(len);
        return String.valueOf(rightJustify ? pad : "") + inString + (rightJustify ? "" : pad);
    }

    /*
     * Exception decompiling
     */
    private void showHistory() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 6[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String commandFromHistory(int commandsAgo) throws BadSpecial {
        if (commandsAgo >= this.statementHistory.length) {
            throw new BadSpecial("History can only hold up to " + this.statementHistory.length + " commands");
        }
        String s = this.statementHistory[(this.statementHistory.length + this.curHist - commandsAgo) % this.statementHistory.length];
        if (s == null) {
            throw new BadSpecial("History doesn't go back that far");
        }
        return s;
    }

    private void setBuf(String inString) {
        ++this.curHist;
        if (this.curHist == this.statementHistory.length) {
            this.curHist = 0;
        }
        this.statementHistory[this.curHist] = inString;
    }

    private void describe(String tableName, String inFilter) throws SQLException {
        String filter = inFilter;
        ArrayList<String[]> rows = new ArrayList<String[]>();
        String[] headerArray = new String[]{"name", "datatype", "width", "no-nulls"};
        int[] maxWidth = new int[4];
        boolean[] blArray = new boolean[4];
        blArray[2] = true;
        boolean[] rightJust = blArray;
        int i = 0;
        while (i < headerArray.length) {
            if (!this.htmlMode && headerArray[i].length() > maxWidth[i]) {
                maxWidth[i] = headerArray[i].length();
            }
            ++i;
        }
        Statement statement = this.curConn.createStatement();
        ResultSet r = null;
        try {
            int j;
            String[] fieldArray;
            statement.execute("SELECT * FROM " + tableName + " WHERE 1 = 2");
            r = statement.getResultSet();
            ResultSetMetaData m = r.getMetaData();
            int cols = m.getColumnCount();
            int i2 = 0;
            while (i2 < cols) {
                fieldArray = new String[4];
                fieldArray[0] = m.getColumnName(i2 + 1);
                if (filter == null || fieldArray[0].indexOf(filter) >= 0) {
                    fieldArray[1] = m.getColumnTypeName(i2 + 1);
                    fieldArray[2] = Integer.toString(m.getColumnDisplaySize(i2 + 1));
                    fieldArray[3] = m.isNullable(i2 + 1) == 1 ? (this.htmlMode ? "&nbsp;" : "") : "*";
                    rows.add(fieldArray);
                    j = 0;
                    while (j < fieldArray.length) {
                        if (fieldArray[j].length() > maxWidth[j]) {
                            maxWidth[j] = fieldArray[j].length();
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            this.condlPrint("<TABLE border='1'>\n" + SqlFile.htmlRow(0) + '\n' + PRE_TD, true);
            i2 = 0;
            while (i2 < headerArray.length) {
                this.condlPrint("<TD>" + headerArray[i2] + "</TD>", true);
                this.condlPrint(String.valueOf(i2 > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(headerArray[i2], maxWidth[i2], rightJust[i2], i2 < headerArray.length - 1 || rightJust[i2]), false);
                ++i2;
            }
            this.condlPrintln("\n" + PRE_TR + "</TR>", true);
            this.condlPrintln("", false);
            if (!this.htmlMode) {
                i2 = 0;
                while (i2 < headerArray.length) {
                    this.condlPrint(String.valueOf(i2 > 0 ? SqlFile.spaces(2) : "") + SqlFile.divider(maxWidth[i2]), false);
                    ++i2;
                }
                this.condlPrintln("", false);
            }
            i2 = 0;
            while (i2 < rows.size()) {
                this.condlPrint(String.valueOf(SqlFile.htmlRow(i2 % 2 == 0 ? 2 : 1)) + '\n' + PRE_TD, true);
                fieldArray = (String[])rows.get(i2);
                j = 0;
                while (j < fieldArray.length) {
                    this.condlPrint("<TD>" + fieldArray[j] + "</TD>", true);
                    this.condlPrint(String.valueOf(j > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(fieldArray[j], maxWidth[j], rightJust[j], j < fieldArray.length - 1 || rightJust[j]), false);
                    ++j;
                }
                this.condlPrintln("\n" + PRE_TR + "</TR>", true);
                this.condlPrintln("", false);
                ++i2;
            }
            this.condlPrintln("\n</TABLE>\n<HR>", true);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                    r = null;
                }
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String[] getTokenArray(String inString) {
        String[] mtString = new String[]{};
        if (inString == null) {
            return mtString;
        }
        StringTokenizer toker = new StringTokenizer(inString);
        String[] sa = new String[toker.countTokens()];
        int i = 0;
        while (i < sa.length) {
            sa[i] = toker.nextToken();
            ++i;
        }
        return sa;
    }

    private boolean eval(String[] inTokens) throws BadSpecial {
        boolean negate = inTokens.length > 0 && inTokens[0].equals("!");
        String[] tokens = new String[negate ? inTokens.length - 1 : inTokens.length];
        int i = 0;
        while (i < tokens.length) {
            String string = inTokens[i + (negate ? 1 : 0)].length() > 1 && inTokens[i + (negate ? 1 : 0)].charAt(0) == '*' ? (String)this.userVars.get(inTokens[i + (negate ? 1 : 0)].substring(1)) : (tokens[i] = inTokens[i + (negate ? 1 : 0)]);
            if (tokens[i] == null) {
                tokens[i] = "";
            }
            ++i;
        }
        if (tokens.length == 1) {
            return (tokens[0].length() > 0 && !tokens[0].equals("0")) ^ negate;
        }
        if (tokens.length == 3) {
            if (tokens[1].equals("==")) {
                return tokens[0].equals(tokens[2]) ^ negate;
            }
            if (tokens[1].equals("!=") || tokens[1].equals("<>") || tokens[1].equals("><")) {
                return !tokens[0].equals(tokens[2]) ^ negate;
            }
            if (tokens[1].equals(">")) {
                return (tokens[0].length() > tokens[2].length() || tokens[0].length() == tokens[2].length() && tokens[0].compareTo(tokens[2]) > 0) ^ negate;
            }
            if (tokens[1].equals("<")) {
                return (tokens[2].length() > tokens[0].length() || tokens[2].length() == tokens[0].length() && tokens[2].compareTo(tokens[0]) > 0) ^ negate;
            }
        }
        throw new BadSpecial("Unrecognized logical operation");
    }

    private void closeQueryOutputStream() {
        if (this.pwQuery == null) {
            return;
        }
        if (this.htmlMode) {
            this.pwQuery.println("</BODY></HTML>");
            this.pwQuery.flush();
        }
        this.pwQuery.close();
        this.pwQuery = null;
    }

    private void condlPrintln(String s, boolean printHtml) {
        if (printHtml && !this.htmlMode || this.htmlMode && !printHtml) {
            return;
        }
        this.psStd.println(s);
        if (this.pwQuery != null) {
            this.pwQuery.println(s);
            this.pwQuery.flush();
        }
    }

    private void condlPrint(String s, boolean printHtml) {
        if (printHtml && !this.htmlMode || this.htmlMode && !printHtml) {
            return;
        }
        this.psStd.print(s);
        if (this.pwQuery != null) {
            this.pwQuery.print(s);
            this.pwQuery.flush();
        }
    }

    private static String formatNicely(Map map, boolean withValues) {
        StringBuffer sb = new StringBuffer();
        Iterator it = new TreeMap(map).keySet().iterator();
        if (withValues) {
            sb.append("The outermost parentheses are not part of the values.\n");
        } else {
            sb.append("Showing variable names and length of values (use 'listvalue' to see values).\n");
        }
        while (it.hasNext()) {
            String key = (String)it.next();
            String s = (String)map.get(key);
            sb.append("    " + key + ": " + (withValues ? "(" + s + ')' : Integer.toString(s.length())) + '\n');
        }
        return sb.toString();
    }

    private void dump(String varName, File dumpFile) throws IOException, BadSpecial {
        char lastChar;
        String val = (String)this.userVars.get(varName);
        if (val == null) {
            throw new BadSpecial("Variable '" + varName + "' has no value set");
        }
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(dumpFile), this.charset);
        osw.write(val);
        boolean terminated = false;
        if (val.length() > 0 && (lastChar = val.charAt(val.length() - 1)) != '\n' && lastChar != '\r') {
            terminated = true;
            osw.write(10);
        }
        osw.flush();
        osw.close();
        this.stdprintln("Saved " + dumpFile.length() + " characters to '" + dumpFile + "'");
    }

    private void dump(File dumpFile) throws IOException, BadSpecial {
        if (this.binBuffer == null) {
            throw new BadSpecial("Binary SqlFile buffer is currently empty");
        }
        FileOutputStream fos = new FileOutputStream(dumpFile);
        fos.write(this.binBuffer);
        int len = this.binBuffer.length;
        this.binBuffer = null;
        fos.flush();
        fos.close();
        this.stdprintln("Saved " + len + " bytes to '" + dumpFile + "'");
    }

    private String streamToString(InputStream is) throws IOException {
        int i;
        char[] xferBuffer = new char[10240];
        StringWriter stringWriter = new StringWriter();
        InputStreamReader isr = new InputStreamReader(is, this.charset);
        while ((i = isr.read(xferBuffer)) > 0) {
            stringWriter.write(xferBuffer, 0, i);
        }
        return stringWriter.toString();
    }

    private byte[] streamToBytes(InputStream is) throws IOException {
        int i;
        byte[] xferBuffer = new byte[10240];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((i = is.read(xferBuffer)) > 0) {
            baos.write(xferBuffer, 0, i);
        }
        return baos.toByteArray();
    }

    private void load(String varName, File asciiFile) throws IOException {
        int i;
        char[] xferBuffer = new char[10240];
        StringWriter stringWriter = new StringWriter();
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(asciiFile), this.charset);
        while ((i = isr.read(xferBuffer)) > 0) {
            stringWriter.write(xferBuffer, 0, i);
        }
        isr.close();
        this.userVars.put(varName, stringWriter.toString());
    }

    private void load(File binFile) throws IOException {
        int i;
        byte[] xferBuffer = new byte[10240];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream fis = new FileInputStream(binFile);
        while ((i = fis.read(xferBuffer)) > 0) {
            baos.write(xferBuffer, 0, i);
        }
        fis.close();
        this.binBuffer = baos.toByteArray();
        this.stdprintln("Loaded " + this.binBuffer.length + " bytes into Binary buffer");
    }

    public static boolean canDisplayType(int i) {
        switch (i) {
            case 1111: 
            case 2000: 
            case 2002: 
            case 2004: {
                return false;
            }
        }
        return true;
    }

    public static String sqlTypeToString(int i) {
        switch (i) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "Unknown type " + i;
    }

    public void csvSafe(String s) throws SQLException {
        if (this.pwCsv == null || this.csvColDelim == null || this.csvRowDelim == null || this.csvNullRep == null) {
            throw new RuntimeException("Assertion failed.  \ncsvSafe called when CSV settings are incomplete");
        }
        if (s == null) {
            return;
        }
        if (s.indexOf(this.csvColDelim) > 0) {
            throw new SQLException("Table data contains our column delimiter '" + this.csvColDelim + "'");
        }
        if (s.indexOf(this.csvRowDelim) > 0) {
            throw new SQLException("Table data contains our row delimiter '" + this.csvRowDelim + "'");
        }
        if (s.indexOf(this.csvNullRep) > 0) {
            throw new SQLException("Table data contains our null representation '" + this.csvNullRep + "'");
        }
    }

    public static String convertEscapes(String inString) {
        if (inString == null) {
            return null;
        }
        String workString = new String(inString);
        int i = 0;
        while ((i = workString.indexOf("\\n", i)) > -1 && i < workString.length() - 1) {
            workString = String.valueOf(workString.substring(0, i)) + '\n' + workString.substring(i + 2);
        }
        i = 0;
        while ((i = workString.indexOf("\\r", i)) > -1 && i < workString.length() - 1) {
            workString = String.valueOf(workString.substring(0, i)) + '\r' + workString.substring(i + 2);
        }
        i = 0;
        while ((i = workString.indexOf("\\t", i)) > -1 && i < workString.length() - 1) {
            workString = String.valueOf(workString.substring(0, i)) + '\t' + workString.substring(i + 2);
        }
        return workString;
    }

    public void importCsv(String filePath) throws IOException, BadSpecial {
        int i;
        char[] bfr = null;
        File file = new File(filePath);
        if (!file.canRead()) {
            throw new IOException("Can't read file '" + file + "'");
        }
        int fileLength = (int)file.length();
        try {
            bfr = new char[fileLength];
        }
        catch (RuntimeException re) {
            throw new IOException("SqlFile can only read in your CSV file in one chunk at this time.\nPlease run the program with more RAM (try Java -Xm* switches).");
        }
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), this.charset);
        int retval = isr.read(bfr, 0, bfr.length);
        isr.close();
        if (retval != bfr.length) {
            throw new IOException("Didn't read all characters.  Read in " + retval + " characters");
        }
        String string = null;
        try {
            string = new String(bfr);
        }
        catch (RuntimeException re) {
            throw new IOException("SqlFile converts your entire CSV file to a String at this time.\nPlease run the program with more RAM (try Java -Xm* switches).");
        }
        ArrayList<String> headerList = new ArrayList<String>();
        int recStart = 0;
        int recEnd = string.indexOf(this.csvRowDelim, recStart);
        if (recEnd < 0) {
            recEnd = string.length();
        }
        int colStart = recStart;
        int colEnd = -1;
        while (colEnd != recEnd) {
            colEnd = string.indexOf(this.csvColDelim, colStart);
            if (colEnd < 0 || colEnd > recEnd) {
                colEnd = recEnd;
            }
            if (colEnd - colStart < 1) {
                throw new IOException("No column header for column " + (headerList.size() + 1));
            }
            headerList.add(string.substring(colStart, colEnd));
            colStart = colEnd + this.csvColDelim.length();
        }
        String[] headers = headerList.toArray(new String[0]);
        boolean[] autonulls = new boolean[headers.length];
        String tableName = (String)this.userVars.get("*CSV_TABLENAME");
        if (tableName == null && (i = (tableName = file.getName()).lastIndexOf(46)) > 0) {
            tableName = tableName.substring(0, i);
        }
        StringBuffer tmpSb = new StringBuffer();
        int i2 = 0;
        while (i2 < headers.length) {
            if (i2 > 0) {
                tmpSb.append(", ");
            }
            tmpSb.append(headers[i2]);
            ++i2;
        }
        StringBuffer sb = new StringBuffer("INSERT INTO " + tableName + " (" + tmpSb + ") VALUES (");
        StringBuffer typeQuerySb = new StringBuffer("SELECT " + tmpSb + " FROM " + tableName + " WHERE 1 = 2");
        try {
            ResultSetMetaData rsmd = this.curConn.createStatement().executeQuery(typeQuerySb.toString()).getMetaData();
            if (rsmd.getColumnCount() != autonulls.length) {
                throw new BadSpecial("Metadata mismatch for columns");
            }
            int i3 = 0;
            while (i3 < autonulls.length) {
                int ctype = rsmd.getColumnType(i3 + 1);
                autonulls[i3] = ctype != -3 && ctype != 12;
                ++i3;
            }
        }
        catch (SQLException se) {
            throw new BadSpecial("Failed to get metadata for query: " + se.getMessage());
        }
        int i4 = 0;
        while (i4 < headers.length) {
            if (i4 > 0) {
                sb.append(", ");
            }
            sb.append('?');
            ++i4;
        }
        try {
            PreparedStatement ps = this.curConn.prepareStatement(String.valueOf(sb.toString()) + ')');
            String[] dataVals = new String[headers.length];
            int recCount = 0;
            while ((recStart = recEnd + this.csvRowDelim.length()) < string.length()) {
                recEnd = string.indexOf(this.csvRowDelim, recStart);
                if (recEnd < 0) {
                    recEnd = string.length();
                }
                colStart = recStart;
                colEnd = -1;
                int colCount = 0;
                ++recCount;
                while (colEnd != recEnd) {
                    colEnd = string.indexOf(this.csvColDelim, colStart);
                    if (colEnd < 0 || colEnd > recEnd) {
                        colEnd = recEnd;
                    }
                    if (colCount == dataVals.length) {
                        throw new IOException("Header has " + headers.length + " columns.  CSV record " + recCount + " has too many column values.");
                    }
                    dataVals[colCount++] = string.substring(colStart, colEnd);
                    colStart = colEnd + this.csvColDelim.length();
                }
                if (colCount != dataVals.length) {
                    throw new IOException("Header has " + headers.length + " columns.  CSV record " + recCount + " has " + colCount + " column values.");
                }
                int i5 = 0;
                while (i5 < dataVals.length) {
                    ps.setString(i5 + 1, dataVals[i5].length() < 1 && autonulls[i5] || dataVals[i5].equals(this.csvNullRep) ? null : dataVals[i5]);
                    ++i5;
                }
                retval = ps.executeUpdate();
                if (retval != 1) {
                    this.curConn.rollback();
                    throw new BadSpecial("Insert of row " + recCount + " failed.  " + retval + " rows modified");
                }
                this.possiblyUncommitteds.set(true);
            }
            this.stdprintln("Successfully inserted " + recCount + " rows into table '" + tableName + "'");
        }
        catch (SQLException se) {
            try {
                this.curConn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new BadSpecial("SQL error encountered when inserting CSV data: " + se);
        }
    }

    private static class BooleanBucket {
        private boolean bPriv = false;

        private BooleanBucket() {
        }

        public void set(boolean bIn) {
            this.bPriv = bIn;
        }

        public boolean get() {
            return this.bPriv;
        }
    }

    private class BadSpecial
    extends Exception {
        private static final long serialVersionUID = 1L;

        private BadSpecial() {
        }

        private BadSpecial(String s) {
            super(s);
        }
    }

    private class QuitNow
    extends SqlToolError {
        private static final long serialVersionUID = 1L;

        public QuitNow(String s) {
            super(s);
        }

        public QuitNow() {
        }
    }

    private class BreakException
    extends SqlToolError {
        private static final long serialVersionUID = 1L;

        public BreakException() {
        }

        public BreakException(String s) {
            super(s);
        }
    }

    private class ContinueException
    extends SqlToolError {
        private static final long serialVersionUID = 1L;

        public ContinueException() {
        }

        public ContinueException(String s) {
            super(s);
        }
    }

    private class BadSwitch
    extends Exception {
        private static final long serialVersionUID = 1L;

        private BadSwitch(int i) {
            super(Integer.toString(i));
        }
    }
}

