/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.recommenders.rec10;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jcolibri.casebase.LinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.PlainTextConnector;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.recommendation.casesDisplay.UserChoice;
import jcolibri.extensions.recommendation.conditionals.BuyOrQuit;
import jcolibri.extensions.recommendation.conditionals.ContinueOrFinish;
import jcolibri.extensions.recommendation.navigationByProposing.CriticalUserChoice;
import jcolibri.extensions.recommendation.navigationByProposing.CritiqueOption;
import jcolibri.extensions.recommendation.navigationByProposing.DisplayCasesTableWithCritiquesMethod;
import jcolibri.extensions.recommendation.navigationByProposing.queryElicitation.MoreLikeThis;
import jcolibri.method.retrieve.DiverseByMedianRetrieval.ExpertClerkMedianScoring;
import jcolibri.method.retrieve.FilterBasedRetrieval.FilterBasedRetrievalMethod;
import jcolibri.method.retrieve.FilterBasedRetrieval.FilterConfig;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.NotEqual;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.QueryLess;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.QueryMore;
import jcolibri.method.retrieve.NNretrieval.NNConfig;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.NNretrieval.similarity.global.Average;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Equal;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Table;
import jcolibri.method.retrieve.NNretrieval.similarity.local.recommenders.InrecaLessIsBetter;
import jcolibri.method.retrieve.NNretrieval.similarity.local.recommenders.InrecaMoreIsBetter;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.SelectCases;
import jcolibri.test.recommenders.housesData.HouseDescription;
import jcolibri.util.FileIO;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Houses10
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;
    NNConfig simConfig;
    Collection<Attribute> hiddenAtts;
    Map<Attribute, String> labels;
    Collection<CritiqueOption> critiques;

    @Override
    public void configure() throws ExecutionException {
        this._connector = new PlainTextConnector();
        this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/recommenders/housesData/plaintextconfig.xml"));
        this._caseBase = new LinealCaseBase();
        this.simConfig = new NNConfig();
        this.simConfig.setDescriptionSimFunction(new Average());
        this.simConfig.addMapping(new Attribute("area", HouseDescription.class), new Table("jcolibri/test/recommenders/housesData/area.csv"));
        this.simConfig.addMapping(new Attribute("beds", HouseDescription.class), new InrecaMoreIsBetter(0.5));
        this.simConfig.addMapping(new Attribute("price", HouseDescription.class), new InrecaLessIsBetter(2000.0, 0.5));
        this.simConfig.addMapping(new Attribute("furnished", HouseDescription.class), new Equal());
        this.simConfig.addMapping(new Attribute("type", HouseDescription.class), new Equal());
        this.simConfig.addMapping(new Attribute("baths", HouseDescription.class), new InrecaMoreIsBetter(0.5));
        this.hiddenAtts = new ArrayList<Attribute>();
        this.labels = new HashMap<Attribute, String>();
        this.labels.put(new Attribute("beds", HouseDescription.class), "Min bedrooms");
        this.labels.put(new Attribute("price", HouseDescription.class), "Max price");
        this.labels.put(new Attribute("baths", HouseDescription.class), "Min bahtrooms");
        this.critiques = new ArrayList<CritiqueOption>();
        this.critiques.add(new CritiqueOption("More Beds", new Attribute("beds", HouseDescription.class), new QueryLess()));
        this.critiques.add(new CritiqueOption("Cheaper", new Attribute("price", HouseDescription.class), new QueryMore()));
        this.critiques.add(new CritiqueOption("More Bathrooms", new Attribute("baths", HouseDescription.class), new QueryLess()));
        this.critiques.add(new CritiqueOption("Change Area", new Attribute("area", HouseDescription.class), new jcolibri.method.retrieve.FilterBasedRetrieval.predicates.Equal()));
        this.critiques.add(new CritiqueOption("Another Area", new Attribute("area", HouseDescription.class), new NotEqual()));
    }

    @Override
    public void cycle(CBRQuery query) throws ExecutionException {
        HashMap<Attribute, Double> thresholds = new HashMap<Attribute, Double>();
        thresholds.put(new Attribute("beds", HouseDescription.class), 2.0);
        thresholds.put(new Attribute("price", HouseDescription.class), 300.0);
        thresholds.put(new Attribute("baths", HouseDescription.class), 2.0);
        thresholds.put(new Attribute("area", HouseDescription.class), 0.99);
        thresholds.put(new Attribute("type", HouseDescription.class), 0.99);
        Collection<RetrievalResult> retrievedCases = ExpertClerkMedianScoring.getDiverseByMedian(this._caseBase.getCases(), this.simConfig, thresholds);
        Collection<CBRCase> selectedCases = SelectCases.selectTopK(retrievedCases, 5);
        CriticalUserChoice choice = DisplayCasesTableWithCritiquesMethod.displayCasesInTableWithCritiques(selectedCases, this.critiques, this._caseBase.getCases());
        this.sequence1(choice.getSelectedCaseAsQuery(), choice.getFilterConfig());
    }

    public void sequence1(CBRQuery query, FilterConfig filterConfig) throws ExecutionException {
        Collection<CBRCase> filtered = FilterBasedRetrievalMethod.filterCases(this._caseBase.getCases(), query, filterConfig);
        Collection<RetrievalResult> retrievedCases = NNScoringMethod.evaluateSimilarity(filtered, query, this.simConfig);
        Collection<CBRCase> selectedCases = SelectCases.selectTopK(retrievedCases, 5);
        CriticalUserChoice choice = DisplayCasesTableWithCritiquesMethod.displayCasesInTableWithCritiques(selectedCases, this.critiques, this._caseBase.getCases());
        if (ContinueOrFinish.continueOrFinish(choice)) {
            this.sequence2(query, choice);
        } else {
            this.sequence3(choice, selectedCases);
        }
    }

    public void sequence2(CBRQuery query, CriticalUserChoice cuc) throws ExecutionException {
        MoreLikeThis.moreLikeThis(query, cuc.getSelectedCase());
        this.sequence1(query, cuc.getFilterConfig());
    }

    public void sequence3(UserChoice choice, Collection<CBRCase> retrievedCases) throws ExecutionException {
        if (BuyOrQuit.buyOrQuit(choice)) {
            System.out.println("Finish - User Buys: " + choice.getSelectedCase());
        } else {
            System.out.println("Finish - User Quits");
        }
    }

    @Override
    public void postCycle() throws ExecutionException {
    }

    @Override
    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        Collection<CBRCase> cases = this._caseBase.getCases();
        for (CBRCase c : cases) {
            System.out.println(c);
        }
        return this._caseBase;
    }

    public static void main(String[] args) {
        Houses10 recommender = new Houses10();
        try {
            recommender.configure();
            recommender.preCycle();
            CBRQuery query = new CBRQuery();
            HouseDescription hd = new HouseDescription();
            query.setDescription(hd);
            recommender.cycle(query);
            recommender.postCycle();
        }
        catch (Exception e) {
            LogFactory.getLog(Houses10.class).error((Object)e);
        }
    }
}

