/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.recommenders.rec11;

import java.util.Collection;
import java.util.HashMap;
import jcolibri.casebase.LinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.PlainTextConnector;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.recommendation.casesDisplay.DisplayCasesTableMethod;
import jcolibri.extensions.recommendation.casesDisplay.UserChoice;
import jcolibri.extensions.recommendation.conditionals.BuyOrQuit;
import jcolibri.extensions.recommendation.conditionals.ContinueOrFinish;
import jcolibri.extensions.recommendation.navigationByProposing.queryElicitation.LessLikeThis;
import jcolibri.extensions.recommendation.navigationByProposing.queryElicitation.MoreAndLessLikeThis;
import jcolibri.extensions.recommendation.navigationByProposing.queryElicitation.MoreLikeThis;
import jcolibri.extensions.recommendation.navigationByProposing.queryElicitation.PartialMoreLikeThis;
import jcolibri.extensions.recommendation.navigationByProposing.queryElicitation.WeightedMoreLikeThis;
import jcolibri.method.retrieve.DiverseByMedianRetrieval.ExpertClerkMedianScoring;
import jcolibri.method.retrieve.FilterBasedRetrieval.FilterBasedRetrievalMethod;
import jcolibri.method.retrieve.FilterBasedRetrieval.FilterConfig;
import jcolibri.method.retrieve.NNretrieval.NNConfig;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.NNretrieval.similarity.global.Average;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Equal;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Table;
import jcolibri.method.retrieve.NNretrieval.similarity.local.recommenders.InrecaLessIsBetter;
import jcolibri.method.retrieve.NNretrieval.similarity.local.recommenders.InrecaMoreIsBetter;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.SelectCases;
import jcolibri.test.recommenders.housesData.HouseDescription;
import jcolibri.util.FileIO;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Houses11
implements StandardCBRApplication {
    private QueryElicitationStrategy strategy;
    Connector _connector;
    CBRCaseBase _caseBase;
    NNConfig simConfig;
    FilterConfig filterConfig;

    @Override
    public void configure() throws ExecutionException {
        this._connector = new PlainTextConnector();
        this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/recommenders/housesData/plaintextconfig.xml"));
        this._caseBase = new LinealCaseBase();
        this.simConfig = new NNConfig();
        this.simConfig.setDescriptionSimFunction(new Average());
        this.simConfig.addMapping(new Attribute("area", HouseDescription.class), new Table("jcolibri/test/recommenders/housesData/area.csv"));
        this.simConfig.addMapping(new Attribute("beds", HouseDescription.class), new InrecaMoreIsBetter(0.5));
        this.simConfig.addMapping(new Attribute("price", HouseDescription.class), new InrecaLessIsBetter(2000.0, 0.5));
        this.simConfig.addMapping(new Attribute("furnished", HouseDescription.class), new Equal());
        this.simConfig.addMapping(new Attribute("type", HouseDescription.class), new Equal());
        this.simConfig.addMapping(new Attribute("baths", HouseDescription.class), new InrecaMoreIsBetter(0.5));
        this.filterConfig = new FilterConfig();
        this.strategy = QueryElicitationStrategy.MLT_LLT;
    }

    @Override
    public void cycle(CBRQuery query) throws ExecutionException {
        HashMap<Attribute, Double> thresholds = new HashMap<Attribute, Double>();
        thresholds.put(new Attribute("beds", HouseDescription.class), 2.0);
        thresholds.put(new Attribute("price", HouseDescription.class), 300.0);
        thresholds.put(new Attribute("baths", HouseDescription.class), 2.0);
        thresholds.put(new Attribute("area", HouseDescription.class), 0.99);
        thresholds.put(new Attribute("type", HouseDescription.class), 0.99);
        Collection<RetrievalResult> retrievedCases = ExpertClerkMedianScoring.getDiverseByMedian(this._caseBase.getCases(), this.simConfig, thresholds);
        Collection<CBRCase> selectedCases = SelectCases.selectTopK(retrievedCases, 5);
        UserChoice choice = DisplayCasesTableMethod.displayCasesInTableSelectCase(selectedCases);
        this.sequence1(choice.getSelectedCaseAsQuery());
    }

    public void sequence1(CBRQuery query) throws ExecutionException {
        Collection<CBRCase> filtered = FilterBasedRetrievalMethod.filterCases(this._caseBase.getCases(), query, this.filterConfig);
        Collection<RetrievalResult> retrievedCases = NNScoringMethod.evaluateSimilarity(filtered, query, this.simConfig);
        Collection<CBRCase> selectedCases = SelectCases.selectTopK(retrievedCases, 10);
        System.out.println("Retrieved cases");
        for (CBRCase c : selectedCases) {
            System.out.println(c);
        }
        UserChoice choice = DisplayCasesTableMethod.displayCasesInTableSelectCase(selectedCases);
        if (ContinueOrFinish.continueOrFinish(choice)) {
            this.sequence2(query, choice, selectedCases);
        } else {
            this.sequence3(choice, selectedCases);
        }
    }

    public void sequence2(CBRQuery query, UserChoice uc, Collection<CBRCase> proposedCases) throws ExecutionException {
        if (this.strategy == QueryElicitationStrategy.MLT) {
            MoreLikeThis.moreLikeThis(query, uc.getSelectedCase());
        } else if (this.strategy == QueryElicitationStrategy.pMLT) {
            PartialMoreLikeThis.partialMoreLikeThis(query, uc.getSelectedCase(), proposedCases);
        } else if (this.strategy == QueryElicitationStrategy.wMLT) {
            WeightedMoreLikeThis.weightedMoreLikeThis(query, uc.getSelectedCase(), proposedCases, this.simConfig);
        } else if (this.strategy == QueryElicitationStrategy.LLT) {
            LessLikeThis.lessLikeThis(query, uc.getSelectedCase(), proposedCases, this.filterConfig);
        } else if (this.strategy == QueryElicitationStrategy.MLT_LLT) {
            MoreAndLessLikeThis.moreAndLessLikeThis(query, uc.getSelectedCase(), proposedCases, this.filterConfig);
        }
        this.sequence1(query);
    }

    public void sequence3(UserChoice choice, Collection<CBRCase> retrievedCases) throws ExecutionException {
        if (BuyOrQuit.buyOrQuit(choice)) {
            System.out.println("Finish - User Buys: " + choice.getSelectedCase());
        } else {
            System.out.println("Finish - User Quits");
        }
    }

    @Override
    public void postCycle() throws ExecutionException {
    }

    @Override
    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        Collection<CBRCase> cases = this._caseBase.getCases();
        for (CBRCase c : cases) {
            System.out.println(c);
        }
        return this._caseBase;
    }

    public static void main(String[] args) {
        Houses11 recommender = new Houses11();
        try {
            recommender.configure();
            recommender.preCycle();
            CBRQuery query = new CBRQuery();
            HouseDescription hd = new HouseDescription();
            query.setDescription(hd);
            recommender.cycle(query);
            recommender.postCycle();
        }
        catch (Exception e) {
            LogFactory.getLog(Houses11.class).error((Object)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum QueryElicitationStrategy {
        MLT,
        pMLT,
        wMLT,
        LLT,
        MLT_LLT;

    }
}

