/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.recommenders.rec3;

import es.ucm.fdi.gaia.ontobridge.OntoBridge;
import es.ucm.fdi.gaia.ontobridge.OntologyDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jcolibri.casebase.LinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.DataBaseConnector;
import jcolibri.datatypes.Instance;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.recommendation.casesDisplay.DisplayCasesTableMethod;
import jcolibri.extensions.recommendation.casesDisplay.UserChoice;
import jcolibri.extensions.recommendation.conditionals.BuyOrQuit;
import jcolibri.extensions.recommendation.conditionals.ContinueOrFinish;
import jcolibri.extensions.recommendation.conditionals.DisplayCasesIfNumber;
import jcolibri.method.gui.formFilling.ObtainQueryWithFormMethod;
import jcolibri.method.retrieve.FilterBasedRetrieval.FilterBasedRetrievalMethod;
import jcolibri.method.retrieve.FilterBasedRetrieval.FilterConfig;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.Equal;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.OntologyCompatible;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.QueryLessOrEqual;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.QueryMoreOrEqual;
import jcolibri.test.database.HSQLDBserver;
import jcolibri.test.recommenders.travelData.TravelDescription;
import jcolibri.util.FileIO;
import jcolibri.util.OntoBridgeSingleton;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Travel3
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;
    Map<Attribute, String> labels;
    ArrayList<Attribute> hiddenAtts;
    FilterConfig filterConfig;

    @Override
    public void configure() throws ExecutionException {
        HSQLDBserver.init();
        this._connector = new DataBaseConnector();
        this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/recommenders/travelData/databaseconfig.xml"));
        this._caseBase = new LinealCaseBase();
        OntoBridge ob = OntoBridgeSingleton.getOntoBridge();
        ob.initWithPelletReasoner();
        OntologyDocument mainOnto = new OntologyDocument("http://gaia.fdi.ucm.es/ontologies/travel-destinations.owl", FileIO.findFile("jcolibri/test/recommenders/travelData/travel-destinations.owl").toExternalForm());
        ArrayList subOntologies = new ArrayList();
        ob.loadOntology(mainOnto, subOntologies, false);
        this.hiddenAtts = new ArrayList();
        this.labels = new HashMap<Attribute, String>();
        this.labels.put(new Attribute("Duration", TravelDescription.class), "Min duration");
        this.labels.put(new Attribute("Accommodation", TravelDescription.class), "Min accommodation");
        this.labels.put(new Attribute("Price", TravelDescription.class), "Max price");
        this.filterConfig = new FilterConfig();
        this.filterConfig.addPredicate(new Attribute("HolidayType", TravelDescription.class), new Equal());
        this.filterConfig.addPredicate(new Attribute("NumberOfPersons", TravelDescription.class), new Equal());
        this.filterConfig.addPredicate(new Attribute("Region", TravelDescription.class), new OntologyCompatible());
        this.filterConfig.addPredicate(new Attribute("Transportation", TravelDescription.class), new Equal());
        this.filterConfig.addPredicate(new Attribute("Duration", TravelDescription.class), new QueryLessOrEqual());
        this.filterConfig.addPredicate(new Attribute("Season", TravelDescription.class), new Equal());
        this.filterConfig.addPredicate(new Attribute("Accommodation", TravelDescription.class), new QueryLessOrEqual());
        this.filterConfig.addPredicate(new Attribute("Price", TravelDescription.class), new QueryMoreOrEqual());
    }

    @Override
    public void cycle(CBRQuery query) throws ExecutionException {
        ObtainQueryWithFormMethod.obtainQueryWithInitialValues(query, this.hiddenAtts, this.labels);
        this.sequence1(query);
    }

    public void sequence1(CBRQuery query) {
        Collection<CBRCase> retrievedCases = FilterBasedRetrievalMethod.filterCases(this._caseBase.getCases(), query, this.filterConfig);
        if (DisplayCasesIfNumber.displayCases(50, 1, retrievedCases, true)) {
            this.sequence2(query, retrievedCases);
        } else {
            this.sequence3(query);
        }
    }

    public void sequence2(CBRQuery query, Collection<CBRCase> retrievedCases) {
        UserChoice choice = DisplayCasesTableMethod.displayCasesInTableEditQuery(retrievedCases);
        if (ContinueOrFinish.continueOrFinish(choice)) {
            this.sequence3(query);
        } else {
            this.sequence4(choice, retrievedCases);
        }
    }

    public void sequence3(CBRQuery query) {
        ObtainQueryWithFormMethod.obtainQueryWithInitialValues(query, this.hiddenAtts, this.labels);
        this.sequence1(query);
    }

    public void sequence4(UserChoice choice, Collection<CBRCase> retrievedCases) {
        if (BuyOrQuit.buyOrQuit(choice)) {
            System.out.println("Finish - User Buys: " + choice.getSelectedCase());
        } else {
            System.out.println("Finish - User Quits");
        }
    }

    @Override
    public void postCycle() throws ExecutionException {
        this._connector.close();
        HSQLDBserver.shutDown();
    }

    @Override
    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        Collection<CBRCase> cases = this._caseBase.getCases();
        for (CBRCase c : cases) {
            System.out.println(c);
        }
        return this._caseBase;
    }

    public static void main(String[] args) {
        Travel3 recommender = new Travel3();
        try {
            recommender.configure();
            recommender.preCycle();
            CBRQuery query = new CBRQuery();
            TravelDescription td = new TravelDescription();
            td.setAccommodation(TravelDescription.AccommodationTypes.ThreeStars);
            td.setDuration(7);
            td.setHolidayType("bathing");
            td.setNumberOfPersons(2);
            td.setRegion(new Instance("Spain"));
            td.setSeason(TravelDescription.Seasons.July);
            td.setTransportation("plane");
            td.setPrice(1000);
            query.setDescription(td);
            recommender.cycle(query);
            recommender.postCycle();
            System.exit(0);
        }
        catch (Exception e) {
            LogFactory.getLog(Travel3.class).error((Object)e);
        }
    }
}

