/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.recommenders.rec5;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jcolibri.casebase.LinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.PlainTextConnector;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.recommendation.casesDisplay.DisplayCasesTableMethod;
import jcolibri.extensions.recommendation.casesDisplay.UserChoice;
import jcolibri.extensions.recommendation.conditionals.BuyOrQuit;
import jcolibri.extensions.recommendation.conditionals.ContinueOrFinish;
import jcolibri.extensions.recommendation.navigationByAsking.ObtainQueryWithAttributeQuestionMethod;
import jcolibri.extensions.recommendation.navigationByAsking.SimilarityInfluence;
import jcolibri.method.retrieve.NNretrieval.NNConfig;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.NNretrieval.similarity.global.Average;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Equal;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Table;
import jcolibri.method.retrieve.NNretrieval.similarity.local.recommenders.InrecaLessIsBetter;
import jcolibri.method.retrieve.NNretrieval.similarity.local.recommenders.InrecaMoreIsBetter;
import jcolibri.method.retrieve.NNretrieval.similarity.local.recommenders.McSherryMoreIsBetter;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.SelectCases;
import jcolibri.test.main.SwingProgressBar;
import jcolibri.test.recommenders.housesData.HouseDescription;
import jcolibri.util.FileIO;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Houses5
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;
    NNConfig simConfig;
    Collection<Attribute> hiddenAtts;
    Map<Attribute, String> labels;
    Collection<CBRCase> workingCases;

    @Override
    public void configure() throws ExecutionException {
        this._connector = new PlainTextConnector();
        this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/recommenders/housesData/plaintextconfig.xml"));
        this._caseBase = new LinealCaseBase();
        this.simConfig = new NNConfig();
        this.simConfig.setDescriptionSimFunction(new Average());
        this.simConfig.addMapping(new Attribute("area", HouseDescription.class), new Table("jcolibri/test/recommenders/housesData/area.csv"));
        this.simConfig.addMapping(new Attribute("beds", HouseDescription.class), new McSherryMoreIsBetter(0.0, 0.0));
        this.simConfig.addMapping(new Attribute("price", HouseDescription.class), new InrecaLessIsBetter(2000.0, 0.5));
        this.simConfig.addMapping(new Attribute("furnished", HouseDescription.class), new Equal());
        this.simConfig.addMapping(new Attribute("type", HouseDescription.class), new Equal());
        this.simConfig.addMapping(new Attribute("baths", HouseDescription.class), new InrecaMoreIsBetter(0.5));
        this.hiddenAtts = new ArrayList<Attribute>();
        this.hiddenAtts.add(new Attribute("beds", HouseDescription.class));
        this.labels = new HashMap<Attribute, String>();
        this.labels.put(new Attribute("price", HouseDescription.class), "Max price");
        this.labels.put(new Attribute("baths", HouseDescription.class), "Min bahtrooms");
    }

    @Override
    public void cycle(CBRQuery query) throws ExecutionException {
        Collection<CBRCase> loadedCases = this._caseBase.getCases();
        this.workingCases = new ArrayList<CBRCase>();
        Iterator<CBRCase> iter = loadedCases.iterator();
        int i = 0;
        while (i < 200) {
            this.workingCases.add(iter.next());
            ++i;
        }
        Attribute att = SimilarityInfluence.getMoreSimVarAttribute(this.workingCases, query, this.simConfig, true);
        ObtainQueryWithAttributeQuestionMethod.obtainQueryWithAttributeQuestion(query, att, this.labels, this.workingCases);
        this.sequence1(query);
    }

    public void sequence1(CBRQuery query) throws ExecutionException {
        Collection<RetrievalResult> eval = NNScoringMethod.evaluateSimilarity(this.workingCases, query, this.simConfig);
        Collection<CBRCase> retrievedCases = SelectCases.selectTopK(eval, 5);
        UserChoice choice = DisplayCasesTableMethod.displayCasesInTableEditQuery(retrievedCases);
        if (ContinueOrFinish.continueOrFinish(choice)) {
            this.sequence2(query);
        } else {
            this.sequence3(choice, retrievedCases);
        }
    }

    public void sequence2(CBRQuery query) throws ExecutionException {
        Attribute att = SimilarityInfluence.getMoreSimVarAttribute(this.workingCases, query, this.simConfig, true);
        ObtainQueryWithAttributeQuestionMethod.obtainQueryWithAttributeQuestion(query, att, this.labels, this.workingCases);
        this.sequence1(query);
    }

    public void sequence3(UserChoice choice, Collection<CBRCase> retrievedCases) throws ExecutionException {
        if (BuyOrQuit.buyOrQuit(choice)) {
            System.out.println("Finish - User Buys: " + choice.getSelectedCase());
        } else {
            System.out.println("Finish - User Quits");
        }
    }

    @Override
    public void postCycle() throws ExecutionException {
    }

    @Override
    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        Collection<CBRCase> cases = this._caseBase.getCases();
        for (CBRCase c : cases) {
            System.out.println(c);
        }
        return this._caseBase;
    }

    public static void main(String[] args) {
        ProgressController.clear();
        ProgressController.register(new SwingProgressBar(), SimilarityInfluence.class);
        Houses5 recommender = new Houses5();
        try {
            recommender.configure();
            recommender.preCycle();
            CBRQuery query = new CBRQuery();
            HouseDescription hd = new HouseDescription();
            query.setDescription(hd);
            recommender.cycle(query);
            recommender.postCycle();
        }
        catch (Exception e) {
            LogFactory.getLog(Houses5.class).error((Object)e);
        }
    }
}

