/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.recommenders.rec8;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import jcolibri.casebase.LinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.PlainTextConnector;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.recommendation.askingAndProposing.AskingAndProposingPreferenceElicitation;
import jcolibri.extensions.recommendation.askingAndProposing.DisplayCasesIfNumberAndChangeNavigation;
import jcolibri.extensions.recommendation.casesDisplay.UserChoice;
import jcolibri.extensions.recommendation.conditionals.BuyOrQuit;
import jcolibri.extensions.recommendation.conditionals.ContinueOrFinish;
import jcolibri.extensions.recommendation.navigationByAsking.InformationGain;
import jcolibri.extensions.recommendation.navigationByAsking.ObtainQueryWithAttributeQuestionMethod;
import jcolibri.extensions.recommendation.navigationByAsking.SelectAttributeMethod;
import jcolibri.extensions.recommendation.navigationByProposing.CriticalUserChoice;
import jcolibri.extensions.recommendation.navigationByProposing.CritiqueOption;
import jcolibri.extensions.recommendation.navigationByProposing.DisplayCasesTableWithCritiquesMethod;
import jcolibri.method.retrieve.FilterBasedRetrieval.FilterBasedRetrievalMethod;
import jcolibri.method.retrieve.FilterBasedRetrieval.FilterConfig;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.NotEqual;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.QueryLess;
import jcolibri.method.retrieve.FilterBasedRetrieval.predicates.QueryMore;
import jcolibri.method.retrieve.NNretrieval.NNConfig;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.NNretrieval.similarity.global.Average;
import jcolibri.method.retrieve.NNretrieval.similarity.local.EnumDistance;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Equal;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Table;
import jcolibri.method.retrieve.NNretrieval.similarity.local.recommenders.InrecaMoreIsBetter;
import jcolibri.method.retrieve.NNretrieval.similarity.local.recommenders.McSherryMoreIsBetter;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.diversity.BoundedGreedySelection;
import jcolibri.test.recommenders.rec8.housesData.HouseDescription;
import jcolibri.util.FileIO;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Houses8
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;
    FilterConfig filterConfig;
    NNConfig simConfig;
    SelectAttributeMethod selectAttributeMethod;
    Collection<CritiqueOption> critiques;

    @Override
    public void configure() throws ExecutionException {
        this._connector = new PlainTextConnector();
        this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/recommenders/rec8/housesData/plaintextconfig.xml"));
        this._caseBase = new LinealCaseBase();
        this.filterConfig = new FilterConfig();
        this.filterConfig.addPredicate(new Attribute("area", HouseDescription.class), new jcolibri.method.retrieve.FilterBasedRetrieval.predicates.Equal());
        this.filterConfig.addPredicate(new Attribute("beds", HouseDescription.class), new jcolibri.method.retrieve.FilterBasedRetrieval.predicates.Equal());
        this.filterConfig.addPredicate(new Attribute("priceRange", HouseDescription.class), new jcolibri.method.retrieve.FilterBasedRetrieval.predicates.Equal());
        this.filterConfig.addPredicate(new Attribute("furnished", HouseDescription.class), new jcolibri.method.retrieve.FilterBasedRetrieval.predicates.Equal());
        this.filterConfig.addPredicate(new Attribute("type", HouseDescription.class), new jcolibri.method.retrieve.FilterBasedRetrieval.predicates.Equal());
        this.filterConfig.addPredicate(new Attribute("baths", HouseDescription.class), new jcolibri.method.retrieve.FilterBasedRetrieval.predicates.Equal());
        this.simConfig = new NNConfig();
        this.simConfig.setDescriptionSimFunction(new Average());
        this.simConfig.addMapping(new Attribute("area", HouseDescription.class), new Table("jcolibri/test/recommenders/housesData/area.csv"));
        this.simConfig.addMapping(new Attribute("beds", HouseDescription.class), new McSherryMoreIsBetter(0.0, 0.0));
        this.simConfig.addMapping(new Attribute("priceRange", HouseDescription.class), new EnumDistance());
        this.simConfig.addMapping(new Attribute("furnished", HouseDescription.class), new Equal());
        this.simConfig.addMapping(new Attribute("type", HouseDescription.class), new Equal());
        this.simConfig.addMapping(new Attribute("baths", HouseDescription.class), new InrecaMoreIsBetter(0.5));
        this.selectAttributeMethod = new InformationGain(this._caseBase.getCases());
        this.critiques = new ArrayList<CritiqueOption>();
        this.critiques.add(new CritiqueOption("More Beds", new Attribute("beds", HouseDescription.class), new QueryLess()));
        this.critiques.add(new CritiqueOption("Cheaper", new Attribute("priceRange", HouseDescription.class), new QueryMore()));
        this.critiques.add(new CritiqueOption("More Bathrooms", new Attribute("baths", HouseDescription.class), new QueryLess()));
        this.critiques.add(new CritiqueOption("Change Area", new Attribute("area", HouseDescription.class), new jcolibri.method.retrieve.FilterBasedRetrieval.predicates.Equal()));
        this.critiques.add(new CritiqueOption("Another Area", new Attribute("area", HouseDescription.class), new NotEqual()));
    }

    @Override
    public void cycle(CBRQuery query) throws ExecutionException {
        Attribute att = this.selectAttributeMethod.getAttribute(this._caseBase.getCases(), query);
        HashMap<Attribute, String> labels = new HashMap<Attribute, String>();
        ObtainQueryWithAttributeQuestionMethod.obtainQueryWithAttributeQuestion(query, att, labels, this._caseBase.getCases());
        this.sequence1(query, this._caseBase.getCases(), this.filterConfig);
    }

    public void sequence1(CBRQuery query, Collection<CBRCase> cases, FilterConfig fc) throws ExecutionException {
        Collection<CBRCase> workingCases = FilterBasedRetrievalMethod.filterCases(cases, query, fc);
        if (DisplayCasesIfNumberAndChangeNavigation.displayCasesIfNumberAndChangeNavigation(50, workingCases)) {
            this.sequence2(query, workingCases);
        } else {
            this.sequence3(query, workingCases, null);
        }
    }

    public void sequence2(CBRQuery query, Collection<CBRCase> workingCases) throws ExecutionException {
        Collection<RetrievalResult> retrievedCases = NNScoringMethod.evaluateSimilarity(workingCases, query, this.simConfig);
        Collection<CBRCase> selectedCases = BoundedGreedySelection.boundedGreddySelection(retrievedCases, query, this.simConfig, 3, 3);
        CriticalUserChoice choice = DisplayCasesTableWithCritiquesMethod.displayCasesInTableWithCritiques(selectedCases, this.critiques, workingCases);
        if (ContinueOrFinish.continueOrFinish(choice)) {
            this.sequence3(query, workingCases, choice);
        } else {
            this.sequence4(choice, workingCases);
        }
    }

    public void sequence3(CBRQuery query, Collection<CBRCase> workingCases, CriticalUserChoice choice) throws ExecutionException {
        AskingAndProposingPreferenceElicitation.doPreferenceElicitation(query, workingCases, this.selectAttributeMethod, choice);
        if (choice != null) {
            this.sequence1(query, workingCases, choice.getFilterConfig());
        } else {
            this.sequence1(query, workingCases, this.filterConfig);
        }
    }

    public void sequence4(UserChoice choice, Collection<CBRCase> workingCases) throws ExecutionException {
        if (BuyOrQuit.buyOrQuit(choice)) {
            System.out.println("Finish - User Buys: " + choice.getSelectedCase());
        } else {
            System.out.println("Finish - User Quits");
        }
    }

    @Override
    public void postCycle() throws ExecutionException {
    }

    @Override
    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        Collection<CBRCase> cases = this._caseBase.getCases();
        for (CBRCase c : cases) {
            System.out.println(c);
        }
        return this._caseBase;
    }

    public static void main(String[] args) {
        Houses8 recommender = new Houses8();
        try {
            recommender.configure();
            recommender.preCycle();
            CBRQuery query = new CBRQuery();
            HouseDescription hd = new HouseDescription();
            query.setDescription(hd);
            recommender.cycle(query);
        }
        catch (Exception e) {
            LogFactory.getLog(Houses8.class).error((Object)e);
        }
    }
}

