/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test13;

import java.util.Collection;
import javax.swing.JOptionPane;
import jcolibri.casebase.LinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.textual.IE.opennlp.IETextOpenNLP;
import jcolibri.extensions.textual.lucene.LuceneIndex;
import jcolibri.method.precycle.LuceneIndexCreator;
import jcolibri.method.retrieve.NNretrieval.NNConfig;
import jcolibri.method.retrieve.NNretrieval.NNScoringMethod;
import jcolibri.method.retrieve.NNretrieval.similarity.global.Average;
import jcolibri.method.retrieve.NNretrieval.similarity.local.textual.LuceneTextSimilarity;
import jcolibri.method.retrieve.RetrievalResult;
import jcolibri.method.retrieve.selection.SelectCases;
import jcolibri.test.main.SwingProgressBar;
import jcolibri.test.test13.RestaurantDescription;
import jcolibri.test.test13.connector.RestaurantsConnector;
import jcolibri.test.test13.gui.ResultFrame;
import jcolibri.util.ProgressController;
import org.apache.commons.logging.LogFactory;

public class Test13b
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;
    LuceneIndex luceneIndex;

    public void configure() throws ExecutionException {
        try {
            this._connector = new RestaurantsConnector("jcolibri/test/test13/restaurants-large-v2.txt");
            this._caseBase = new LinealCaseBase();
            ProgressController.clear();
            SwingProgressBar pb = new SwingProgressBar();
            ProgressController.register(pb);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        this.luceneIndex = LuceneIndexCreator.createLuceneIndex(this._caseBase);
        return this._caseBase;
    }

    public void cycle(CBRQuery query) throws ExecutionException {
        Collection<CBRCase> cases = this._caseBase.getCases();
        NNConfig nnConfig = new NNConfig();
        nnConfig.setDescriptionSimFunction(new Average());
        Attribute textualAttribute = new Attribute("description", RestaurantDescription.class);
        nnConfig.addMapping(textualAttribute, new LuceneTextSimilarity(this.luceneIndex, query, textualAttribute, true));
        System.out.println("RESULT: ");
        Collection<RetrievalResult> res = NNScoringMethod.evaluateSimilarity(cases, query, nnConfig);
        res = SelectCases.selectTopKRR(res, 5);
        for (RetrievalResult rr : res) {
            System.out.println(rr);
        }
        RestaurantDescription qrd = (RestaurantDescription)query.getDescription();
        CBRCase mostSimilar = res.iterator().next().get_case();
        RestaurantDescription rrd = (RestaurantDescription)mostSimilar.getDescription();
        new ResultFrame(qrd.getDescription().getRAWContent(), rrd.getName(), rrd.getAddress(), rrd.getDescription().getRAWContent());
    }

    public void postCycle() throws ExecutionException {
        this._connector.close();
    }

    public static void main(String[] args) {
        Test13b test = new Test13b();
        try {
            test.configure();
            CBRCaseBase caseBase = test.preCycle();
            System.out.println("CASE BASE: ");
            for (CBRCase c : caseBase.getCases()) {
                System.out.println(c);
            }
            System.out.println("Total: " + caseBase.getCases().size() + " cases");
            boolean _continue = true;
            while (_continue) {
                String queryString = JOptionPane.showInputDialog("Please enter the restaurant description:");
                if (queryString == null) {
                    _continue = false;
                    continue;
                }
                CBRQuery query = new CBRQuery();
                RestaurantDescription queryDescription = new RestaurantDescription();
                queryDescription.setDescription(new IETextOpenNLP(queryString));
                query.setDescription(queryDescription);
                test.cycle(query);
            }
            test.postCycle();
        }
        catch (ExecutionException e) {
            LogFactory.getLog(Test13b.class).error((Object)e);
        }
    }
}

