/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test13.connector;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CaseBaseFilter;
import jcolibri.cbrcore.Connector;
import jcolibri.exception.InitializingException;
import jcolibri.extensions.textual.IE.opennlp.IETextOpenNLP;
import jcolibri.test.test13.RestaurantDescription;
import jcolibri.util.FileIO;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestaurantsConnector
implements Connector {
    private URL file;

    public RestaurantsConnector(String sourceFile) {
        this.file = FileIO.findFile(sourceFile);
    }

    @Override
    public void close() {
    }

    @Override
    public void deleteCases(Collection<CBRCase> cases) {
    }

    @Override
    public void initFromXMLfile(URL file) throws InitializingException {
    }

    @Override
    public Collection<CBRCase> retrieveAllCases() {
        ArrayList<CBRCase> res = new ArrayList<CBRCase>();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.file.openStream()));
            String line = "";
            while ((line = br.readLine()) != null) {
                RestaurantDescription restaurant = new RestaurantDescription();
                restaurant.setName(line);
                restaurant.setAddress(br.readLine());
                restaurant.setLocation(br.readLine());
                restaurant.setPhone(br.readLine());
                restaurant.setDescription(new IETextOpenNLP(br.readLine()));
                br.readLine();
                br.readLine();
                br.readLine();
                CBRCase _case = new CBRCase();
                _case.setDescription(restaurant);
                res.add(_case);
            }
            br.close();
        }
        catch (IOException e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
        return res;
    }

    @Override
    public Collection<CBRCase> retrieveSomeCases(CaseBaseFilter filter) {
        return null;
    }

    @Override
    public void storeCases(Collection<CBRCase> cases) {
    }
}

