/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test14;

import jcolibri.casebase.CachedLinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.PlainTextConnector;
import jcolibri.evaluation.Evaluator;
import jcolibri.exception.ExecutionException;
import jcolibri.method.retrieve.NNretrieval.similarity.global.Average;
import jcolibri.method.retrieve.NNretrieval.similarity.local.Interval;
import jcolibri.method.reuse.classification.KNNClassificationConfig;
import jcolibri.method.reuse.classification.SimilarityWeightedVotingMethod;
import jcolibri.method.revise.classification.BasicClassificationOracle;
import jcolibri.test.test14.GlassDescription;
import jcolibri.util.FileIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GlassEvaluableApp
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;
    KNNClassificationConfig glassSimConfig;
    private Log log;
    public static final String DATA_SERIES_NAME = "Glass Prediction Cost";

    public void configure() throws ExecutionException {
        try {
            this._connector = new PlainTextConnector();
            this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/test14/plaintextconfigGlass.xml"));
            this._caseBase = new CachedLinealCaseBase();
            this.glassSimConfig = new KNNClassificationConfig();
            this.glassSimConfig.setDescriptionSimFunction(new Average());
            this.glassSimConfig.addMapping(new Attribute("ri", GlassDescription.class), new Interval(0.02278));
            this.glassSimConfig.addMapping(new Attribute("na", GlassDescription.class), new Interval(6.65));
            this.glassSimConfig.addMapping(new Attribute("mg", GlassDescription.class), new Interval(4.49));
            this.glassSimConfig.addMapping(new Attribute("al", GlassDescription.class), new Interval(3.21));
            this.glassSimConfig.addMapping(new Attribute("si", GlassDescription.class), new Interval(5.6));
            this.glassSimConfig.addMapping(new Attribute("k", GlassDescription.class), new Interval(6.21));
            this.glassSimConfig.addMapping(new Attribute("ca", GlassDescription.class), new Interval(10.76));
            this.glassSimConfig.addMapping(new Attribute("ba", GlassDescription.class), new Interval(3.15));
            this.glassSimConfig.addMapping(new Attribute("fe", GlassDescription.class), new Interval(0.51));
            this.glassSimConfig.setClassificationMethod(new SimilarityWeightedVotingMethod());
            this.glassSimConfig.setK(3);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        this.log = LogFactory.getLog(this.getClass());
    }

    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        return this._caseBase;
    }

    public void cycle(CBRQuery query) throws ExecutionException {
        this.log.info((Object)("Query: " + query.getDescription()));
        BasicClassificationOracle oracle = new BasicClassificationOracle();
        double predictionCost = oracle.getPredictionCost(query, this._caseBase, this.glassSimConfig);
        Evaluator.getEvaluationReport().addDataToSeries(DATA_SERIES_NAME, predictionCost);
    }

    public void postCycle() throws ExecutionException {
        this._connector.close();
    }
}

