/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test16;

import java.util.Collection;
import jcolibri.casebase.CachedLinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.evaluation.Evaluator;
import jcolibri.exception.ExecutionException;
import jcolibri.extensions.textual.IE.common.StopWordsDetector;
import jcolibri.extensions.textual.IE.common.TextStemmer;
import jcolibri.extensions.textual.IE.opennlp.OpennlpSplitter;
import jcolibri.method.retrieve.NNretrieval.similarity.LocalSimilarityFunction;
import jcolibri.method.retrieve.NNretrieval.similarity.global.Average;
import jcolibri.method.reuse.classification.KNNClassificationConfig;
import jcolibri.method.reuse.classification.KNNClassificationMethod;
import jcolibri.method.revise.classification.BasicClassificationOracle;
import jcolibri.test.test16.EmailConnector;
import jcolibri.test.test16.EmailDescription;
import jcolibri.test.test16.EmailSolution;

public class SpamFilterApp
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;
    private int k = 3;
    private LocalSimilarityFunction similFunc = null;
    private KNNClassificationMethod clasifMethod = null;
    private String corpusZipFile = null;
    private double tp;
    private double tn;
    private double fp;
    private double fn;
    private KNNClassificationConfig spamFilterSimConfig;

    public SpamFilterApp(String corpusZipFile) {
        this.corpusZipFile = corpusZipFile;
        this.spamFilterSimConfig = new KNNClassificationConfig();
    }

    public void configure() throws ExecutionException {
        this._connector = new EmailConnector(this.corpusZipFile);
        this._caseBase = new CachedLinealCaseBase();
    }

    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        Collection<CBRCase> cases = this._caseBase.getCases();
        OpennlpSplitter.split(cases);
        StopWordsDetector.detectStopWords(cases);
        TextStemmer.stem(cases);
        this.fn = 0.0;
        this.fp = 0.0;
        this.tp = 0.0;
        this.tn = 0.0;
        return this._caseBase;
    }

    public void cycle(CBRQuery query) throws ExecutionException {
        KNNClassificationConfig spamFilterSimConfig = this.getKNNConfig();
        BasicClassificationOracle oracle = new BasicClassificationOracle();
        double predictionCost = oracle.getPredictionCost(query, this._caseBase, spamFilterSimConfig);
        CBRCase _case = (CBRCase)query;
        EmailSolution sol = (EmailSolution)_case.getSolution();
        String _class = sol.getEmailClass();
        if (predictionCost == 0.0) {
            if (_class.equals("spam")) {
                this.tp += 1.0;
            } else {
                this.tn += 1.0;
            }
        } else if (_class.equals("spam")) {
            this.fn += 1.0;
        } else {
            this.fp += 1.0;
        }
        Evaluator.getEvaluationReport().addDataToSeries("Evaluation", new Double(predictionCost));
    }

    public void postCycle() throws ExecutionException {
    }

    public KNNClassificationConfig getKNNConfig() {
        this.spamFilterSimConfig.setDescriptionSimFunction(new Average());
        this.spamFilterSimConfig.setClassificationMethod(this.clasifMethod);
        this.spamFilterSimConfig.setK(this.k);
        this.spamFilterSimConfig.addMapping(new Attribute("content", EmailDescription.class), this.similFunc);
        return this.spamFilterSimConfig;
    }

    public void setK(int k) {
        this.k = k;
    }

    public void setSimilFunc(LocalSimilarityFunction similFunc) {
        this.similFunc = similFunc;
    }

    public void setClasifMethod(KNNClassificationMethod clasifMethod) {
        this.clasifMethod = clasifMethod;
    }

    public double getFalseNegatives() {
        return this.fn;
    }

    public double getFalsePositives() {
        return this.fp;
    }

    public double getTruePositives() {
        return this.tp;
    }

    public double getTrueNegatives() {
        return this.tn;
    }
}

