/*
 * Decompiled with CFR 0.152.
 */
package jcolibri.test.test6;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import jcolibri.casebase.LinealCaseBase;
import jcolibri.cbraplications.StandardCBRApplication;
import jcolibri.cbrcore.Attribute;
import jcolibri.cbrcore.CBRCase;
import jcolibri.cbrcore.CBRCaseBase;
import jcolibri.cbrcore.CBRQuery;
import jcolibri.cbrcore.Connector;
import jcolibri.connector.PlainTextConnector;
import jcolibri.exception.AttributeAccessException;
import jcolibri.exception.ExecutionException;
import jcolibri.util.FileIO;
import org.apache.commons.logging.LogFactory;

public class Test6
implements StandardCBRApplication {
    Connector _connector;
    CBRCaseBase _caseBase;

    public void configure() throws ExecutionException {
        try {
            this._connector = new PlainTextConnector();
            this._connector.initFromXMLfile(FileIO.findFile("jcolibri/test/test6/plaintextconfig.xml"));
            this._caseBase = new LinealCaseBase();
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public CBRCaseBase preCycle() throws ExecutionException {
        this._caseBase.init(this._connector);
        Collection<CBRCase> cases = this._caseBase.getCases();
        for (CBRCase c : cases) {
            System.out.println(c);
        }
        return this._caseBase;
    }

    public void cycle(CBRQuery query) throws ExecutionException {
        CBRCase newcase = this._caseBase.getCases().iterator().next();
        Attribute id = newcase.getDescription().getIdAttribute();
        try {
            Date d = new Date();
            id.setValue(newcase.getDescription(), ("case " + d.toString()).replaceAll(" ", "_"));
        }
        catch (AttributeAccessException e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
        }
        ArrayList<CBRCase> casestoLearnt = new ArrayList<CBRCase>();
        casestoLearnt.add(newcase);
        this._caseBase.learnCases(casestoLearnt);
    }

    public void postCycle() throws ExecutionException {
        this._connector.close();
    }

    public static void main(String[] args) {
        Test6 test = new Test6();
        try {
            test.configure();
            test.preCycle();
            test.cycle(null);
        }
        catch (ExecutionException e) {
            LogFactory.getLog(Test6.class).error((Object)e);
        }
    }
}

