/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.io.ByteArrayInputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java_cup.runtime.DefaultSymbolFactory;
import weka.core.AttributeStats;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.mathematicalexpression.Parser;
import weka.core.mathematicalexpression.Scanner;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class MathExpression
extends PotentialClassIgnorer
implements UnsupervisedFilter {
    static final long serialVersionUID = -3713222714671997901L;
    protected Range m_SelectCols = new Range();
    public static final String m_defaultExpression = "(A-MIN)/(MAX-MIN)";
    private String m_expression = "(A-MIN)/(MAX-MIN)";
    private AttributeStats[] m_attStats;

    public MathExpression() {
        this.setInvertSelection(false);
    }

    public String globalInfo() {
        return "Modify numeric attributes according to a given expression ";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        this.m_SelectCols.setUpper(instanceInfo.numAttributes() - 1);
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        this.m_attStats = null;
        return true;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_attStats == null) {
            this.bufferInput(instance);
            return false;
        }
        this.convertInstance(instance);
        return true;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_attStats == null) {
            int i;
            Instances input = this.getInputFormat();
            this.m_attStats = new AttributeStats[input.numAttributes()];
            for (i = 0; i < input.numAttributes(); ++i) {
                if (!input.attribute(i).isNumeric() || input.classIndex() == i) continue;
                this.m_attStats[i] = input.attributeStats(i);
            }
            for (i = 0; i < input.numInstances(); ++i) {
                this.convertInstance(input.instance(i));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    protected double eval(HashMap symbols) {
        double result;
        try {
            DefaultSymbolFactory sf = new DefaultSymbolFactory();
            ByteArrayInputStream parserInput = new ByteArrayInputStream(this.m_expression.getBytes());
            Parser parser = new Parser(new Scanner(parserInput, sf), sf);
            parser.setSymbols(symbols);
            parser.parse();
            result = parser.getResult();
        }
        catch (Exception e) {
            result = Double.NaN;
            e.printStackTrace();
        }
        return result;
    }

    private void convertInstance(Instance instance) throws Exception {
        Instance inst = null;
        HashMap<String, Double> symbols = new HashMap<String, Double>(5);
        if (instance instanceof SparseInstance) {
            double[] newVals = new double[instance.numAttributes()];
            int[] newIndices = new int[instance.numAttributes()];
            double[] vals = instance.toDoubleArray();
            int ind = 0;
            for (int j = 0; j < instance.numAttributes(); ++j) {
                double value;
                if (this.m_SelectCols.isInRange(j)) {
                    if (!instance.attribute(j).isNumeric() || Instance.isMissingValue(vals[j]) || this.getInputFormat().classIndex() == j) continue;
                    symbols.put("A", new Double(vals[j]));
                    symbols.put("MAX", new Double(this.m_attStats[j].numericStats.max));
                    symbols.put("MIN", new Double(this.m_attStats[j].numericStats.min));
                    symbols.put("MEAN", new Double(this.m_attStats[j].numericStats.mean));
                    symbols.put("SD", new Double(this.m_attStats[j].numericStats.stdDev));
                    symbols.put("COUNT", new Double(this.m_attStats[j].numericStats.count));
                    symbols.put("SUM", new Double(this.m_attStats[j].numericStats.sum));
                    symbols.put("SUMSQUARED", new Double(this.m_attStats[j].numericStats.sumSq));
                    value = this.eval(symbols);
                    if (Double.isNaN(value) || Double.isInfinite(value)) {
                        System.err.println("WARNING:Error in evaluating the expression: missing value set");
                        value = Instance.missingValue();
                    }
                    if (value == 0.0) continue;
                    newVals[ind] = value;
                    newIndices[ind] = j;
                    ++ind;
                    continue;
                }
                value = vals[j];
                if (value == 0.0) continue;
                newVals[ind] = value;
                newIndices[ind] = j;
                ++ind;
            }
            double[] tempVals = new double[ind];
            int[] tempInd = new int[ind];
            System.arraycopy(newVals, 0, tempVals, 0, ind);
            System.arraycopy(newIndices, 0, tempInd, 0, ind);
            inst = new SparseInstance(instance.weight(), tempVals, tempInd, instance.numAttributes());
        } else {
            double[] vals = instance.toDoubleArray();
            for (int j = 0; j < this.getInputFormat().numAttributes(); ++j) {
                if (!this.m_SelectCols.isInRange(j) || !instance.attribute(j).isNumeric() || Instance.isMissingValue(vals[j]) || this.getInputFormat().classIndex() == j) continue;
                symbols.put("A", new Double(vals[j]));
                symbols.put("MAX", new Double(this.m_attStats[j].numericStats.max));
                symbols.put("MIN", new Double(this.m_attStats[j].numericStats.min));
                symbols.put("MEAN", new Double(this.m_attStats[j].numericStats.mean));
                symbols.put("SD", new Double(this.m_attStats[j].numericStats.stdDev));
                symbols.put("COUNT", new Double(this.m_attStats[j].numericStats.count));
                symbols.put("SUM", new Double(this.m_attStats[j].numericStats.sum));
                symbols.put("SUMSQUARED", new Double(this.m_attStats[j].numericStats.sumSq));
                vals[j] = this.eval(symbols);
                if (!Double.isNaN(vals[j]) && !Double.isInfinite(vals[j])) continue;
                System.err.println("WARNING:Error in Evaluation the Expression: missing value set");
                vals[j] = Instance.missingValue();
            }
            inst = new Instance(instance.weight(), vals);
        }
        inst.setDataset(instance.dataset());
        this.push(inst);
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String expString = Utils.getOption('E', options);
        if (expString.length() != 0) {
            this.setExpression(expString);
        } else {
            this.setExpression(m_defaultExpression);
        }
        String ignoreList = Utils.getOption('R', options);
        if (ignoreList.length() != 0) {
            this.setIgnoreRange(ignoreList);
        }
        this.setInvertSelection(Utils.getFlag('V', options));
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-E");
        result.add(this.getExpression());
        if (this.getInvertSelection()) {
            result.add("-V");
        }
        if (!this.getIgnoreRange().equals("")) {
            result.add("-R");
            result.add(this.getIgnoreRange());
        }
        return result.toArray(new String[result.size()]);
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        result.addElement(new Option("\tSpecify the expression to apply. Eg. pow(A,6)/(MEAN+MAX)\n\tSupported operators are +, -, *, /, pow, log,\n\tabs, cos, exp, sqrt, tan, sin, ceil, floor, rint, (, ), \n\tMEAN, MAX, MIN, SD, COUNT, SUM, SUMSQUARED, ifelse", "E", 1, "-E <expression>"));
        result.addElement(new Option("\tSpecify list of columns to ignore. First and last are valid\n\tindexes. (default none)", "R", 1, "-R <index1,index2-index4,...>"));
        result.addElement(new Option("\tInvert matching sense (i.e. only modify specified columns)", "V", 0, "-V"));
        return result.elements();
    }

    public String expressionTipText() {
        return "Specify the expression to apply. The 'A' letterrefers to the attribute value. MIN,MAX,MEAN,SDrefer respectively to minimum, maximum, mean andstandard deviation of the attribute.\n\tSupported operators are +, -, *, /, pow, log,abs, cos, exp, sqrt, tan, sin, ceil, floor, rint, (, ),A,MEAN, MAX, MIN, SD, COUNT, SUM, SUMSQUARED, ifelse\n\tEg. pow(A,6)/(MEAN+MAX)*ifelse(A<0,0,sqrt(A))+ifelse(![A>9 && A<15])";
    }

    public void setExpression(String expr) {
        this.m_expression = expr;
    }

    public String getExpression() {
        return this.m_expression;
    }

    public String invertSelectionTipText() {
        return "Determines whether action is to select or unselect. If set to true, only the specified attributes will be modified; If set to false, specified attributes will not be modified.";
    }

    public boolean getInvertSelection() {
        return !this.m_SelectCols.getInvert();
    }

    public void setInvertSelection(boolean invert) {
        this.m_SelectCols.setInvert(!invert);
    }

    public String ignoreRangeTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getIgnoreRange() {
        return this.m_SelectCols.getRanges();
    }

    public void setIgnoreRange(String rangeList) {
        this.m_SelectCols.setRanges(rangeList);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5543 $");
    }

    public static void main(String[] argv) {
        MathExpression.runFilter(new MathExpression(), argv);
    }
}

